/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DeterminizeNwa<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedWordAutomaton<LETTER, STATE> mCache;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private final IStateFactory<STATE> mStateFactory;
    private final Set<STATE> mPredefinedInitials;
    private final boolean mMakeAutomatonTotal;
    private final Map<STATE, DeterminizedState<LETTER, STATE>> mRes2det = new HashMap<STATE, DeterminizedState<LETTER, STATE>>();
    private final Map<DeterminizedState<LETTER, STATE>, STATE> mDet2res = new HashMap<DeterminizedState<LETTER, STATE>, STATE>();

    public DeterminizeNwa(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, iStateDeterminizer, iEmptyStackStateFactory, null, false);
    }

    public DeterminizeNwa(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory, Set<STATE> set, boolean bl) {
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateDeterminizer = iStateDeterminizer;
        this.mStateFactory = iEmptyStackStateFactory;
        this.mCache = new NestedWordAutomaton(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), iEmptyStackStateFactory);
        this.mPredefinedInitials = set;
        this.mMakeAutomatonTotal = bl;
    }

    public boolean isTotal() {
        return this.mMakeAutomatonTotal;
    }

    private void constructInitialState() {
        if (this.mPredefinedInitials == null) {
            DeterminizedState<LETTER, STATE> determinizedState = this.mStateDeterminizer.initialState();
            STATE STATE = this.mStateDeterminizer.getState(determinizedState);
            this.mDet2res.put(determinizedState, STATE);
            this.mRes2det.put(STATE, determinizedState);
            this.mCache.addState(true, determinizedState.containsFinal(), STATE);
        } else {
            for (STATE STATE : this.mPredefinedInitials) {
                DeterminizedState determinizedState = new DeterminizedState(this.mOperand);
                determinizedState.addPair(this.mOperand.getEmptyStackState(), STATE, this.mOperand);
                STATE STATE2 = this.mStateDeterminizer.getState(determinizedState);
                this.mDet2res.put(determinizedState, STATE2);
                this.mRes2det.put(STATE2, determinizedState);
                this.mCache.addState(true, determinizedState.containsFinal(), STATE2);
            }
        }
    }

    private STATE getOrConstructState(DeterminizedState<LETTER, STATE> determinizedState) {
        STATE STATE = this.mDet2res.get(determinizedState);
        if (STATE == null) {
            STATE = this.mStateDeterminizer.getState(determinizedState);
            this.mDet2res.put(determinizedState, STATE);
            this.mRes2det.put(STATE, determinizedState);
            this.mCache.addState(false, determinizedState.containsFinal(), STATE);
        }
        return STATE;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        if (this.mCache.getInitialStates().isEmpty()) {
            this.constructInitialState();
        }
        return this.mCache.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mCache.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mCache.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mCache.isFinal(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mCache.getEmptyStackState();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        if (this.mMakeAutomatonTotal) {
            return this.getVpAlphabet().getInternalAlphabet();
        }
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        for (STATE STATE2 : determinizedState.getDownStates()) {
            for (STATE STATE3 : determinizedState.getUpStates(STATE2)) {
                hashSet.addAll(this.mOperand.lettersInternal(STATE3));
            }
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        if (this.mMakeAutomatonTotal) {
            return this.getVpAlphabet().getCallAlphabet();
        }
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        for (STATE STATE2 : determinizedState.getDownStates()) {
            for (STATE STATE3 : determinizedState.getUpStates(STATE2)) {
                hashSet.addAll(this.mOperand.lettersCall(STATE3));
            }
        }
        return hashSet;
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        if (this.mMakeAutomatonTotal) {
            return this.getVpAlphabet().getReturnAlphabet();
        }
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        DeterminizedState<LETTER, STATE> determinizedState2 = this.mRes2det.get(STATE2);
        for (STATE STATE3 : determinizedState2.getDownStates()) {
            for (STATE STATE4 : determinizedState2.getUpStates(STATE3)) {
                Set<STATE> set = determinizedState.getUpStates(STATE4);
                if (set == null) continue;
                for (STATE STATE5 : set) {
                    hashSet.addAll(this.mOperand.lettersReturn(STATE5, STATE4));
                }
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        Iterator<OutgoingInternalTransition<LETTER, STATE>> iterator = this.mCache.internalSuccessors(STATE, LETTER).iterator();
        if (!iterator.hasNext()) {
            DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
            assert (determinizedState != null);
            DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.internalSuccessor(determinizedState, LETTER);
            STATE STATE2 = this.getOrConstructState(determinizedState2);
            this.mCache.addInternalTransition(STATE, LETTER, STATE2);
        }
        return this.mCache.internalSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        for (LETTER LETTER : this.lettersInternal(STATE)) {
            this.internalSuccessors(STATE, LETTER);
        }
        return this.mCache.internalSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        Iterator<OutgoingCallTransition<LETTER, STATE>> iterator = this.mCache.callSuccessors(STATE, LETTER).iterator();
        if (!iterator.hasNext()) {
            DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
            assert (determinizedState != null);
            DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.callSuccessor(determinizedState, LETTER);
            STATE STATE2 = this.getOrConstructState(determinizedState2);
            this.mCache.addCallTransition(STATE, LETTER, STATE2);
        }
        return this.mCache.callSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        for (LETTER LETTER : this.lettersCall(STATE)) {
            this.callSuccessors(STATE, LETTER);
        }
        return this.mCache.callSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        Iterator<OutgoingReturnTransition<LETTER, STATE>> iterator = this.mCache.returnSuccessors(STATE, STATE2, LETTER).iterator();
        if (!iterator.hasNext()) {
            DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
            assert (determinizedState != null);
            DeterminizedState<LETTER, STATE> determinizedState2 = this.mRes2det.get(STATE2);
            assert (determinizedState2 != null);
            DeterminizedState<LETTER, STATE> determinizedState3 = this.mStateDeterminizer.returnSuccessor(determinizedState, determinizedState2, LETTER);
            STATE STATE3 = this.getOrConstructState(determinizedState3);
            this.mCache.addReturnTransition(STATE, STATE2, LETTER, STATE3);
        }
        return this.mCache.returnSuccessors(STATE, STATE2, LETTER);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        for (LETTER LETTER : this.lettersReturn(STATE, STATE2)) {
            this.returnSuccessors(STATE, STATE2, LETTER);
        }
        return this.mCache.returnSuccessorsGivenHier(STATE, STATE2);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String sizeInformation() {
        return "size Information not available";
    }
}

