/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.InteractiveMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.NwaApproximateDelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedConsistencyGeneratorDelayedSimulationPair;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGeneratorPair;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeNwaPmaxSatDelayed<LETTER, STATE>
extends MinimizeNwaMaxSat2<LETTER, STATE, Pair<STATE, STATE>> {
    final BiPredicate<STATE, STATE> nothingMergedYet = (object, object2) -> false;
    private static final PreprocessingMode PREPROCESSING_STANDALONE = PreprocessingMode.PAIRS;
    private static final boolean USE_FULL_PREPROCESSING = false;
    private static final Pair[] EMPTY_LITERALS = new Pair[0];
    private STATE mEmptyStackState = this.mOperand.getEmptyStackState();
    private ScopedConsistencyGeneratorDelayedSimulationPair<STATE, LETTER, STATE> mConsistencyGenerator;
    final ISetOfPairs<STATE, ?> mSpoilerWinnings;
    final ISetOfPairs<STATE, ?> mDuplicatorFollowing;
    final ISetOfPairs<STATE, ?> mSimulation;

    public MinimizeNwaPmaxSatDelayed(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, MinimizeNwaPmaxSatDelayed.createAtsInitialPairs(automataLibraryServices, iDoubleDeckerAutomaton), new MinimizeNwaMaxSat2.Settings().setLibraryMode(false));
    }

    public MinimizeNwaPmaxSatDelayed(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, Iterable<Pair<STATE, STATE>> iterable, MinimizeNwaMaxSat2.Settings<STATE> settings) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, MinimizeNwaPmaxSatDelayed.createNestedMapWithInitialPairs(iterable), settings);
    }

    public MinimizeNwaPmaxSatDelayed(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, NestedMap2<STATE, STATE, Pair<STATE, STATE>> nestedMap2, MinimizeNwaMaxSat2.Settings<STATE> settings) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, settings, nestedMap2, null);
        this.mSettings.setUseInternalCallConstraints(false);
        NwaApproximateDelayedSimulation nwaApproximateDelayedSimulation = new NwaApproximateDelayedSimulation(this.mServices, this.mOperand, this.nothingMergedYet);
        this.mSpoilerWinnings = nwaApproximateDelayedSimulation.getSpoilerWinningStates();
        this.mDuplicatorFollowing = nwaApproximateDelayedSimulation.getDuplicatorEventuallyAcceptingStates();
        this.mSimulation = nwaApproximateDelayedSimulation.computeOrdinarySimulation();
        this.printStartMessage();
        this.run();
        this.printExitMessage();
    }

    private static <LETTER, STATE> Iterable<Pair<STATE, STATE>> createAtsInitialPairs(AutomataLibraryServices automataLibraryServices, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        switch (PREPROCESSING_STANDALONE) {
            case PARTITION: {
                return MinimizeNwaPmaxSatDelayed.createPairs(iDoubleDeckerAutomaton.getStates());
            }
            case PAIRS: {
                return MinimizeNwaPmaxSatDelayed.createPairs(iDoubleDeckerAutomaton.getStates());
            }
            case NONE: {
                return MinimizeNwaPmaxSatDelayed.createPairs(iDoubleDeckerAutomaton.getStates());
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + String.valueOf((Object)PREPROCESSING_STANDALONE));
    }

    @Override
    protected AbstractMaxSatSolver<Pair<STATE, STATE>> createTransitivitySolver() {
        this.mTransitivityGenerator = new ScopedTransitivityGeneratorPair(this.mSettings.isUsePathCompression());
        this.mConsistencyGenerator = new ScopedConsistencyGeneratorDelayedSimulationPair(this.mSettings.isUsePathCompression(), this.mServices, this.mOperand);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.mTransitivityGenerator);
        arrayList.add(this.mConsistencyGenerator);
        return new InteractiveMaxSatSolver<Pair<STATE, STATE>>(this.mServices, arrayList);
    }

    @Override
    protected void generateVariablesAndAcceptingConstraints() throws AutomataOperationCanceledException {
        Set<STATE> set = this.computeDuplicatorComplement(this.mDuplicatorFollowing, this.mSimulation);
        STATE[] STATEArray = this.constructStateArray(set);
        this.generateVariablesHelper(STATEArray);
        this.checkTimeout("generating variables");
    }

    protected void generateVariablesHelper(STATE[] STATEArray) {
        if (STATEArray.length <= 1) {
            return;
        }
        int n = 0;
        while (n < STATEArray.length) {
            STATE STATE = STATEArray[n];
            if (this.mTransitivityGenerator != null) {
                this.mTransitivityGenerator.addContent(STATE);
            }
            if (this.mConsistencyGenerator != null) {
                this.mConsistencyGenerator.addContent(STATE);
            }
            int n2 = 0;
            while (n2 < n) {
                STATE STATE2 = STATEArray[n2];
                Pair pair = new Pair(STATE, STATE2);
                Pair pair2 = new Pair(STATE2, STATE);
                this.mStatePair2Var.put(STATE, STATE2, (Object)pair);
                this.mStatePair2Var.put(STATE2, STATE, (Object)pair2);
                this.mSolver.addVariable(pair);
                this.mSolver.addVariable(pair2);
                if (!this.mSpoilerWinnings.containsPair(STATE, STATE2)) {
                    this.setVariableFalse(pair);
                }
                if (!this.mSpoilerWinnings.containsPair(STATE2, STATE)) {
                    this.setVariableFalse(pair2);
                }
                ++n2;
            }
            ++n;
        }
    }

    private Set<STATE> computeDuplicatorComplement(ISetOfPairs<STATE, ?> iSetOfPairs, ISetOfPairs<STATE, ?> iSetOfPairs2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Pair pair : iSetOfPairs2) {
            if (iSetOfPairs.containsPair(pair.getFirst(), pair.getSecond())) continue;
            hashSet.add(pair.getFirst());
            hashSet.add(pair.getSecond());
        }
        return hashSet;
    }

    @Override
    protected boolean isInitialPair(STATE STATE, STATE STATE2) {
        if (STATE.equals(this.mEmptyStackState) || STATE2.equals(this.mEmptyStackState)) {
            return false;
        }
        Map map = this.mStatePair2Var.get(STATE);
        if (map == null) {
            return false;
        }
        return map.containsKey(STATE2);
    }

    private static <STATE> NestedMap2<STATE, STATE, Pair<STATE, STATE>> createNestedMapWithInitialPairs(Iterable<Pair<STATE, STATE>> iterable) {
        NestedMap2 nestedMap2 = new NestedMap2();
        for (Pair<STATE, STATE> pair : iterable) {
            if (pair.getFirst().equals(pair.getSecond())) continue;
            nestedMap2.put(pair.getFirst(), pair.getSecond(), pair);
        }
        return nestedMap2;
    }

    @Override
    protected void generateTransitionAndTransitivityConstraints(boolean bl) throws AutomataOperationCanceledException {
        for (Object object : this.mStatePair2Var.entrySet()) {
            this.checkTimeout("adding transition constraints");
            Pair pair = (Pair)object.getThird();
            this.generateTransitionConstraintsHelper(object.getFirst(), object.getSecond(), pair);
            if (!bl) continue;
            this.generateTransitivityConstraints(pair);
        }
        for (Object object : this.mOperand.getStates()) {
            this.checkTimeout("adding transition constraints");
            this.generateTransitionConstraintsHelperReturnSameLinPred(object, this.getDownStatesArray(object));
        }
    }

    private void generateTransitivityConstraints(Pair<STATE, STATE> pair) {
        Map map = this.mStatePair2Var.get(pair.getSecond());
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Pair pair2 = (Pair)entry.getValue();
            Pair pair3 = (Pair)this.mStatePair2Var.get(pair.getFirst(), k);
            if (pair3 == null) continue;
            this.addTransitivityClausesToSolver(pair, pair2, pair3);
        }
    }

    @Override
    protected IPartition<STATE> constructResultEquivalenceClasses() throws AssertionError {
        HashMap<Object, HashSet<Object>> hashMap = new HashMap<Object, HashSet<Object>>();
        UnionFind unionFind = new UnionFind();
        for (Object object : this.mOperand.getStates()) {
            unionFind.makeEquivalenceClass(object);
        }
        for (Map.Entry entry : this.mSolver.getValues().entrySet()) {
            Set<Object> set;
            if (entry.getValue() == null) {
                throw new AssertionError((Object)("value not determined " + String.valueOf(entry.getKey())));
            }
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            Object object = ((Pair)entry.getKey()).getFirst();
            Object object2 = ((Pair)entry.getKey()).getSecond();
            Set set2 = (Set)hashMap.get(object2);
            if (set2 != null && set2.remove(object)) {
                set = unionFind.findAndConstructEquivalenceClassIfNeeded(object);
                Object object3 = unionFind.findAndConstructEquivalenceClassIfNeeded(object2);
                unionFind.union((Object)set, object3);
                continue;
            }
            if (!this.isInitialPair(object2, object)) continue;
            set = (Set)hashMap.get(object);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(object, (HashSet<Object>)set);
            }
            set.add(object2);
        }
        return unionFind;
    }

    @Override
    protected boolean isInitialPair(Pair<STATE, STATE> pair) {
        return this.isInitialPair(pair.getFirst(), pair.getSecond());
    }

    protected Pair<STATE, STATE>[] getEmptyVariableArray() {
        return EMPTY_LITERALS;
    }

    @Override
    protected String createTaskDescription() {
        return "minimizing NWA with " + this.mOperand.size() + " states";
    }

    @Override
    protected void generateTransitionConstraintGeneralInternalCallHelper(Pair<STATE, STATE> pair, Set<STATE> set, Set<STATE> set2) {
        this.generateTransitionConstraintGeneralInternalCallHelperOneSide(pair, set, set2, null);
    }

    @Override
    protected void generateTransitionConstraintGeneralReturnHelper(Pair<STATE, STATE> pair, Pair<STATE, STATE> pair2, Set<STATE> set, Set<STATE> set2) {
        this.generateTransitionConstraintGeneralReturnHelperOneSide(pair, pair2, set, set2, null);
    }

    @Override
    protected boolean testOutgoingSymbols(Set<LETTER> set, Set<LETTER> set2) {
        return set2.containsAll(set);
    }

    private static <STATE> Iterable<Pair<STATE, STATE>> createPairs(Set<STATE> set) {
        ArrayList<Pair<STATE, STATE>> arrayList = new ArrayList<Pair<STATE, STATE>>(set.size() * set.size());
        for (STATE STATE : set) {
            for (STATE STATE2 : set) {
                arrayList.add(new Pair(STATE, STATE2));
            }
        }
        return arrayList;
    }

    public static enum PreprocessingMode {
        PARTITION,
        PAIRS,
        NONE;

    }
}

