/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.BuchiWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.IBuchiWaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.StateWaNCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.BitSet;
import java.util.LinkedList;

public class BuchiWaComplement
extends BuchiWa
implements IBuchiWaComplement {
    private final IBuchiWa mOperand;
    private final TObjectIntMap<StateWaNCSB> mStateIndices = new TObjectIntHashMap();
    private boolean mExplored = false;

    public BuchiWaComplement(IBuchiWa iBuchiWa) {
        super(iBuchiWa.getAlphabetSize());
        this.mOperand = iBuchiWa;
        this.computeInitialStates();
    }

    private void computeInitialStates() {
        IntSet intSet = this.mOperand.getInitialStates().clone();
        intSet.and(this.mOperand.getFinalStates());
        IntSet intSet2 = this.mOperand.getInitialStates().clone();
        intSet2.andNot(intSet);
        NCSB nCSB = new NCSB(intSet2, intSet, UtilIntSet.newIntSet(), intSet);
        StateWaNCSB stateWaNCSB = new StateWaNCSB(this, 0, nCSB);
        if (intSet.isEmpty()) {
            this.setFinal(0);
        }
        this.setInitial(0);
        int n = this.addState(stateWaNCSB);
        this.mStateIndices.put((Object)stateWaNCSB, n);
    }

    protected StateWaNCSB addState(NCSB nCSB) {
        StateWaNCSB stateWaNCSB = new StateWaNCSB(this, 0, nCSB);
        if (this.mStateIndices.containsKey((Object)stateWaNCSB)) {
            return (StateWaNCSB)this.getState(this.mStateIndices.get((Object)stateWaNCSB));
        }
        int n = this.getStateSize();
        StateWaNCSB stateWaNCSB2 = new StateWaNCSB(this, n, nCSB);
        int n2 = this.addState(stateWaNCSB2);
        this.mStateIndices.put((Object)stateWaNCSB2, n2);
        if (nCSB.getBSet().isEmpty()) {
            this.setFinal(n);
        }
        return stateWaNCSB2;
    }

    @Override
    public IBuchiWa getOperand() {
        return this.mOperand;
    }

    public void explore() {
        if (this.mExplored) {
            return;
        }
        this.mExplored = true;
        LinkedList<IStateWa> linkedList = new LinkedList<IStateWa>();
        IntSet intSet = this.getInitialStates();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            linkedList.addFirst(this.getState(intIterator.next()));
        }
        BitSet bitSet = new BitSet();
        while (!linkedList.isEmpty()) {
            IStateWa iStateWa = (IStateWa)linkedList.remove();
            if (bitSet.get(iStateWa.getId())) continue;
            bitSet.set(iStateWa.getId());
            if (Options.verbose) {
                System.out.println("s" + iStateWa.getId() + ": " + iStateWa.toString());
            }
            int n = 0;
            while (n < this.mOperand.getAlphabetSize()) {
                IntSet intSet2 = iStateWa.getSuccessors(n);
                intIterator = intSet2.iterator();
                while (intIterator.hasNext()) {
                    int n2 = intIterator.next();
                    if (Options.verbose) {
                        System.out.println(" s" + iStateWa.getId() + ": " + iStateWa.toString() + "- L" + n + " -> s" + n2 + ": " + String.valueOf(this.getState(n2)));
                    }
                    if (bitSet.get(n2)) continue;
                    linkedList.addFirst(this.getState(n2));
                }
                ++n;
            }
        }
    }
}

