/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChangeType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FairGameGraph<LETTER, STATE>
extends AGameGraph<LETTER, STATE> {
    private boolean mAreThereMergeableStates;
    private final INestedWordAutomaton<LETTER, STATE> mBuechi;
    private final Set<Triple<STATE, LETTER, STATE>> mBuechiTransitions;
    private final NestedMap3<STATE, LETTER, STATE, GameGraphChangeType> mChangedBuechiTransitionsInverse;
    private final UnionFind<STATE> mEquivalenceClasses;
    private long mGraphBuildTime;
    private final AutomataLibraryServices mServices;
    private List<Triple<STATE, LETTER, STATE>> mTransitionsToRemove;

    public FairGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMergeStateFactory, iProgressAwareTimer, iLogger, iNestedWordAutomaton);
        INestedWordAutomaton iNestedWordAutomaton2 = this.getAutomaton();
        this.verifyAutomatonValidity(iNestedWordAutomaton2);
        this.mServices = automataLibraryServices;
        this.mBuechi = iNestedWordAutomaton2;
        this.mChangedBuechiTransitionsInverse = new NestedMap3();
        this.mBuechiTransitions = new HashSet<Triple<STATE, LETTER, STATE>>();
        this.mEquivalenceClasses = new UnionFind();
        this.mAreThereMergeableStates = false;
        this.mTransitionsToRemove = null;
        this.mGraphBuildTime = 0L;
    }

    public boolean areThereMergeableStates() {
        return this.mAreThereMergeableStates;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
        Object object;
        ImmutableSet immutableSet;
        Object object22;
        SimulationPerformance simulationPerformance = this.getSimulationPerformance();
        if (simulationPerformance != null) {
            simulationPerformance.startTimeMeasure(TimeMeasure.BUILD_RESULT);
        }
        boolean bl = this.mAreThereMergeableStates;
        boolean bl2 = this.mTransitionsToRemove != null && !this.mTransitionsToRemove.isEmpty();
        HashMap<Triple, ImmutableSet> hashMap = null;
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mBuechi.getVpAlphabet(), this.getStateFactory());
        if (bl) {
            Object object32;
            object22 = new HashSet();
            for (Object object32 : this.mBuechi.getInitialStates()) {
                object22.add(this.mEquivalenceClasses.find(object32));
            }
            object32 = new HashSet();
            for (Object object4 : this.mBuechi.getFinalStates()) {
                object32.add(this.mEquivalenceClasses.find(object4));
            }
            if (this.getProgressTimer() != null && !this.getProgressTimer().continueProcessing()) {
                this.getLogger().debug((Object)"Stopped in generateBuchiAutomatonFromGraph/state calculation finished");
                throw new AutomataOperationCanceledException(this.getClass());
            }
            hashMap = new HashMap<Triple, ImmutableSet>(this.mBuechi.size());
            for (Object object4 : this.mEquivalenceClasses.getAllRepresentatives()) {
                boolean bl3 = object22.contains(object4);
                boolean bl4 = object32.contains(object4);
                immutableSet = this.mEquivalenceClasses.getEquivalenceClassMembers(object4);
                object = this.getStateFactory().merge(immutableSet);
                nestedWordAutomaton.addState(bl3, bl4, object);
                for (Object object5 : immutableSet) {
                    hashMap.put((Triple)object5, (ImmutableSet)object);
                }
            }
        } else {
            for (Object object22 : this.mBuechi.getStates()) {
                boolean bl5 = this.mBuechi.isInitial((HashSet<Object>)object22);
                boolean bl6 = this.mBuechi.isFinal((HashSet<Object>)object22);
                nestedWordAutomaton.addState(bl5, bl6, object22);
            }
        }
        for (Object object22 : this.mBuechi.getStates()) {
            Object object6 = bl ? hashMap.get(object22) : object22;
            for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(object22)) {
                Object LETTER = outgoingInternalTransition.getLetter();
                immutableSet = outgoingInternalTransition.getSucc();
                object = bl ? hashMap.get(immutableSet) : immutableSet;
                if (bl2) {
                    Object object5;
                    object5 = new Triple(object22, LETTER, immutableSet);
                    if (this.mTransitionsToRemove.contains(object5)) continue;
                    nestedWordAutomaton.addInternalTransition(object6, LETTER, object);
                    continue;
                }
                nestedWordAutomaton.addInternalTransition(object6, LETTER, object);
            }
        }
        if (this.getProgressTimer() != null && !this.getProgressTimer().continueProcessing()) {
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomatonFromGraph/states and transitions added");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (simulationPerformance != null) {
            simulationPerformance.stopTimeMeasure(TimeMeasure.BUILD_RESULT);
            simulationPerformance.addTimeMeasureValue(TimeMeasure.BUILD_GRAPH, this.mGraphBuildTime);
        }
        if (bl2) {
            object22 = new RemoveUnreachable(this.mServices, nestedWordAutomaton).getResult();
            return object22;
        }
        return nestedWordAutomaton;
    }

    @Override
    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        long l = System.currentTimeMillis();
        INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton = this.mBuechi;
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            for (STATE object : iNestedWordAutomaton.getStates()) {
                int n = this.calculatePriority(STATE, object);
                if (n == 1) {
                    this.increaseGlobalInfinity();
                }
                SpoilerVertex spoilerVertex = new SpoilerVertex(n, false, STATE, object);
                this.addSpoilerVertex(spoilerVertex);
                for (Vertex vertex : iNestedWordAutomaton.lettersInternalIncoming(STATE)) {
                    DuplicatorVertex duplicatorVertex = new DuplicatorVertex(2, false, STATE, object, vertex);
                    this.addDuplicatorVertex(duplicatorVertex);
                }
                if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
                this.getLogger().debug((Object)"Stopped in generateGameGraphFromBuechi/generating vertices");
                throw new AutomataOperationCanceledException(this.getClass());
            }
            this.mEquivalenceClasses.makeEquivalenceClass(STATE);
        }
        this.increaseGlobalInfinity();
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors(STATE)) {
                for (Object e : iNestedWordAutomaton.getStates()) {
                    Vertex vertex;
                    vertex = this.getDuplicatorVertex(e, incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), false);
                    DuplicatorVertex duplicatorVertex = this.getSpoilerVertex(e, STATE, false);
                    if (vertex != null && duplicatorVertex != null) {
                        this.addEdge(vertex, duplicatorVertex);
                    }
                    vertex = this.getSpoilerVertex(incomingInternalTransition.getPred(), e, false);
                    duplicatorVertex = this.getDuplicatorVertex(STATE, e, incomingInternalTransition.getLetter(), false);
                    if (vertex != null && duplicatorVertex != null) {
                        this.addEdge(vertex, duplicatorVertex);
                    }
                    if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
                    this.getLogger().debug((Object)"Stopped in generateGameGraphFromBuechi/generating edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                this.mBuechiTransitions.add(new Triple(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE));
            }
        }
        this.mGraphBuildTime = System.currentTimeMillis() - l;
    }

    public Set<Triple<STATE, LETTER, STATE>> getBuechiTransitions() {
        return this.mBuechiTransitions;
    }

    public UnionFind<STATE> getEquivalenceClasses() {
        return this.mEquivalenceClasses;
    }

    public List<Triple<STATE, LETTER, STATE>> getTransitionsToRemove() {
        return this.mTransitionsToRemove;
    }

    @Override
    public void undoChanges(GameGraphChanges<LETTER, STATE> gameGraphChanges) {
        super.undoChanges(gameGraphChanges);
        if (gameGraphChanges == null) {
            return;
        }
        if (gameGraphChanges instanceof FairGameGraphChanges) {
            FairGameGraphChanges fairGameGraphChanges = (FairGameGraphChanges)gameGraphChanges;
            NestedMap3 nestedMap3 = fairGameGraphChanges.getChangedBuechiTransitions();
            for (Object e : nestedMap3.keySet()) {
                for (Triple triple : nestedMap3.get(e).entrySet()) {
                    Object e2 = e;
                    Object object = triple.getFirst();
                    Object object2 = triple.getSecond();
                    if (!((GameGraphChangeType)((Object)triple.getThird())).equals((Object)GameGraphChangeType.ADDITION) && !((GameGraphChangeType)((Object)triple.getThird())).equals((Object)GameGraphChangeType.REMOVAL)) continue;
                    this.mChangedBuechiTransitionsInverse.get(object2).remove(object, e2);
                }
            }
        }
    }

    private FairGameGraphChanges<LETTER, STATE> equalizeBuechiStatesOneDir(STATE STATE, STATE STATE2) {
        FairGameGraphChanges fairGameGraphChanges;
        STATE STATE3;
        Object LETTER;
        STATE STATE4;
        Set<STATE> set = this.mBuechi.getStates();
        if (STATE2 == null || STATE == null || !set.contains(STATE2) || !set.contains(STATE) || STATE2 == STATE) {
            throw new IllegalArgumentException("Arguments must exist in the automaton, be different and not null.");
        }
        FairGameGraphChanges fairGameGraphChanges2 = new FairGameGraphChanges();
        boolean bl = false;
        Iterator iterator = this.mBuechi.internalSuccessors(STATE2).iterator();
        while (iterator.hasNext()) {
            STATE4 = STATE;
            OutgoingInternalTransition iTransitionlet = iterator.next();
            LETTER = iTransitionlet.getLetter();
            if (this.hasBuechiTransition(new Triple(STATE4, LETTER, STATE3 = iTransitionlet.getSucc())) || (fairGameGraphChanges = this.addBuechiTransition(STATE4, LETTER, STATE3)) == null) continue;
            fairGameGraphChanges2.merge(fairGameGraphChanges, true);
            bl = true;
        }
        for (IncomingInternalTransition incomingInternalTransition : this.mBuechi.internalPredecessors(STATE2)) {
            STATE4 = incomingInternalTransition.getPred();
            if (this.hasBuechiTransition(new Triple(STATE4, LETTER = incomingInternalTransition.getLetter(), STATE3 = STATE)) || (fairGameGraphChanges = this.addBuechiTransition(STATE4, LETTER, STATE)) == null) continue;
            fairGameGraphChanges2.merge(fairGameGraphChanges, true);
            bl = true;
        }
        if (bl) {
            return fairGameGraphChanges2;
        }
        return null;
    }

    protected FairGameGraphChanges<LETTER, STATE> addBuechiTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        Set<STATE> set = this.mBuechi.getStates();
        if (STATE == null || STATE2 == null || !set.contains(STATE) || !set.contains(STATE2) || this.hasBuechiTransition(new Triple(STATE, LETTER, STATE2))) {
            throw new IllegalArgumentException("Arguments must exist in the automaton, not be null and the given transitions must not already exist.");
        }
        GameGraphChangeType gameGraphChangeType = (GameGraphChangeType)((Object)this.mChangedBuechiTransitionsInverse.get(STATE2, LETTER, STATE));
        if (gameGraphChangeType != null && gameGraphChangeType.equals((Object)GameGraphChangeType.ADDITION)) {
            return null;
        }
        boolean bl = true;
        Map map = this.mChangedBuechiTransitionsInverse.get(STATE2, LETTER);
        Iterator<IncomingInternalTransition<LETTER, STATE>> iterator = this.mBuechi.internalPredecessors(STATE2, LETTER).iterator();
        while (iterator.hasNext()) {
            Object object;
            STATE object3 = iterator.next().getPred();
            if (map != null && (object = (GameGraphChangeType)((Object)map.get(object3))) != null && ((Enum)object).equals((Object)GameGraphChangeType.REMOVAL)) continue;
            bl = false;
            break;
        }
        if (bl && map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null || !((GameGraphChangeType)((Object)entry.getValue())).equals((Object)GameGraphChangeType.ADDITION)) continue;
                bl = false;
                break;
            }
        }
        FairGameGraphChanges fairGameGraphChanges = new FairGameGraphChanges();
        for (Object object : set) {
            DuplicatorVertex duplicatorVertex;
            Object object2;
            if (bl) {
                object2 = object;
                if (this.getDuplicatorVertex(STATE2, object2, LETTER, false) != null) continue;
                duplicatorVertex = new DuplicatorVertex(2, false, STATE2, object2, LETTER);
                this.addDuplicatorVertex(duplicatorVertex);
                fairGameGraphChanges.addedVertex(duplicatorVertex);
                for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(duplicatorVertex.getQ1(), duplicatorVertex.getLetter())) {
                    SpoilerVertex spoilerVertex = this.getSpoilerVertex(duplicatorVertex.getQ0(), outgoingInternalTransition.getSucc(), false);
                    if (duplicatorVertex == null || spoilerVertex == null) continue;
                    this.addEdge(duplicatorVertex, spoilerVertex);
                    fairGameGraphChanges.addedEdge(duplicatorVertex, spoilerVertex);
                }
            }
            object2 = this.getSpoilerVertex(STATE, object, false);
            duplicatorVertex = this.getDuplicatorVertex(STATE2, object, LETTER, false);
            if (STATE == null || STATE2 == null) continue;
            this.addEdge(object2, duplicatorVertex);
            fairGameGraphChanges.addedEdge(object2, duplicatorVertex);
        }
        this.mChangedBuechiTransitionsInverse.put(STATE2, LETTER, STATE, (Object)GameGraphChangeType.ADDITION);
        fairGameGraphChanges.addedBuechiTransition(STATE, LETTER, STATE2);
        return fairGameGraphChanges;
    }

    protected boolean areInSameEquivalenceClasses(STATE STATE, STATE STATE2) {
        if (STATE == null || STATE2 == null) {
            throw new IllegalArgumentException("The given states must not be null.");
        }
        if (STATE.equals(STATE2)) {
            return true;
        }
        ImmutableSet immutableSet = this.mEquivalenceClasses.getEquivalenceClassMembers(STATE);
        return immutableSet != null && immutableSet.contains(STATE2);
    }

    protected int calculatePriority(STATE STATE, STATE STATE2) {
        if (this.mBuechi.isFinal(STATE2)) {
            return 0;
        }
        if (this.mBuechi.isFinal(STATE)) {
            return 1;
        }
        return 2;
    }

    protected FairGameGraphChanges<LETTER, STATE> equalizeBuechiStates(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mBuechi.getStates();
        if (STATE == null || STATE2 == null || !set.contains(STATE) || !set.contains(STATE2) || STATE == STATE2) {
            throw new IllegalArgumentException("Arguments must exist in the automaton, be different and not null.");
        }
        FairGameGraphChanges<LETTER, STATE> fairGameGraphChanges = new FairGameGraphChanges<LETTER, STATE>();
        boolean bl = false;
        FairGameGraphChanges<LETTER, STATE> fairGameGraphChanges2 = this.equalizeBuechiStatesOneDir(STATE2, STATE);
        if (fairGameGraphChanges2 != null) {
            fairGameGraphChanges.merge(fairGameGraphChanges2, true);
            bl = true;
        }
        if ((fairGameGraphChanges2 = this.equalizeBuechiStatesOneDir(STATE, STATE2)) != null) {
            fairGameGraphChanges.merge(fairGameGraphChanges2, true);
            bl = true;
        }
        if (bl) {
            return fairGameGraphChanges;
        }
        return null;
    }

    protected boolean hasBuechiTransition(Triple<STATE, LETTER, STATE> triple) {
        return this.mBuechiTransitions.contains(triple);
    }

    protected void markMergeable(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mBuechi.getStates();
        if (!set.contains(STATE) || !set.contains(STATE2)) {
            throw new IllegalArgumentException("The given states must exist in the buechi automaton.");
        }
        this.mEquivalenceClasses.union(STATE, STATE2);
        if (!this.mAreThereMergeableStates && STATE != STATE2) {
            this.mAreThereMergeableStates = true;
        }
    }

    protected void markRemoveableTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        Triple triple = new Triple(STATE, LETTER, STATE2);
        if (!this.hasBuechiTransition(triple)) {
            throw new IllegalArgumentException("The given transition must exist in the buechi automaton.");
        }
        if (this.mTransitionsToRemove == null) {
            this.mTransitionsToRemove = new LinkedList<Triple<STATE, LETTER, STATE>>();
        }
        this.mTransitionsToRemove.add(triple);
    }

    protected FairGameGraphChanges<LETTER, STATE> removeBuechiTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        Set<STATE> set = this.mBuechi.getStates();
        if (!(STATE != null && STATE2 != null && set.contains(STATE) && set.contains(STATE2) && this.hasBuechiTransition(new Triple(STATE, LETTER, STATE2)))) {
            throw new IllegalArgumentException("Arguments must exist in the automaton, not be null and the given transitions must exist.");
        }
        GameGraphChangeType gameGraphChangeType = (GameGraphChangeType)((Object)this.mChangedBuechiTransitionsInverse.get(STATE2, LETTER, STATE));
        if (gameGraphChangeType != null && gameGraphChangeType.equals((Object)GameGraphChangeType.REMOVAL)) {
            return null;
        }
        FairGameGraphChanges<LETTER, STATE> fairGameGraphChanges = new FairGameGraphChanges<LETTER, STATE>();
        for (STATE STATE3 : set) {
            DuplicatorVertex<LETTER, STATE> duplicatorVertex = this.getDuplicatorVertex(STATE3, STATE, LETTER, false);
            SpoilerVertex spoilerVertex = this.getSpoilerVertex(STATE3, STATE2, false);
            if (duplicatorVertex == null || spoilerVertex == null) continue;
            this.removeEdge(duplicatorVertex, spoilerVertex);
            fairGameGraphChanges.removedEdge(duplicatorVertex, spoilerVertex);
        }
        this.mChangedBuechiTransitionsInverse.put(STATE2, LETTER, STATE, (Object)GameGraphChangeType.REMOVAL);
        fairGameGraphChanges.removedBuechiTransition(STATE, LETTER, STATE2);
        return fairGameGraphChanges;
    }

    protected void setGraphBuildTime(long l) {
        this.mGraphBuildTime = l;
    }
}

