/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.CommonExternalFormatWriter;
import java.io.PrintWriter;

public final class HanoiFormatWriter<LETTER, STATE>
extends CommonExternalFormatWriter<LETTER, STATE> {
    private static final int MINIMUM_HEADER_SIZE = 137;
    private static final int MINIMUM_STATE_SIZE = 15;
    private static final boolean USE_LABELS = false;
    private final CommonExternalFormatWriter.IConverter<LETTER> mLetterConverter;

    public HanoiFormatWriter(PrintWriter printWriter, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(printWriter, iNestedWordAutomaton);
        this.mLetterConverter = new CommonExternalFormatWriter.MapBasedConverter(this.mAlphabetMapping);
        this.doPrint();
        this.finish();
    }

    private void doPrint() {
        StringBuilder stringBuilder = this.constructHeader();
        this.print(stringBuilder);
        this.print("--BODY--");
        this.print(NEW_LINE);
        StringBuilder stringBuilder2 = this.constructBody();
        this.print(stringBuilder2);
        this.print("--END--");
    }

    private StringBuilder constructHeader() {
        StringBuilder stringBuilder = new StringBuilder(137);
        stringBuilder.append("HOA: v1").append(NEW_LINE).append("States: ").append(this.mNwa.getStates().size()).append(NEW_LINE);
        for (Object object : this.mNwa.getInitialStates()) {
            stringBuilder.append("Start: ").append((String)this.mStateMapping.get(object)).append(NEW_LINE);
        }
        stringBuilder.append("AP: ").append(this.mNwa.getVpAlphabet().getInternalAlphabet().size());
        for (Object object : this.mNwa.getVpAlphabet().getInternalAlphabet()) {
            stringBuilder.append(" \"p").append(this.mLetterConverter.convert(object) + "\"");
        }
        stringBuilder.append(NEW_LINE);
        for (Object object : this.mNwa.getVpAlphabet().getInternalAlphabet()) {
            stringBuilder.append("Alias: @").append((String)this.mAlphabetMapping.get(object));
            boolean bl = true;
            for (Object LETTER : this.mNwa.getVpAlphabet().getInternalAlphabet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" &");
                }
                if (LETTER == object) {
                    stringBuilder.append(' ').append((String)this.mAlphabetMapping.get(LETTER));
                    continue;
                }
                stringBuilder.append(" !").append((String)this.mAlphabetMapping.get(LETTER));
            }
            stringBuilder.append(NEW_LINE);
        }
        stringBuilder.append("Acceptance: 1 Inf(0)").append(NEW_LINE).append("acc-name: Buchi").append(NEW_LINE).append("tool: \"Ultimate Automata Library\"").append(NEW_LINE);
        return stringBuilder;
    }

    private StringBuilder constructBody() {
        StringBuilder stringBuilder = new StringBuilder(15 * this.mNwa.size());
        for (Object STATE : this.mNwa.getStates()) {
            stringBuilder.append("State: ").append((String)this.mStateMapping.get(STATE));
            if (this.mNwa.isFinal(STATE)) {
                stringBuilder.append(" {0}");
            }
            stringBuilder.append(NEW_LINE);
            for (Object LETTER : this.mNwa.lettersInternal(STATE)) {
                for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE, LETTER)) {
                    stringBuilder.append("[@").append((String)this.mAlphabetMapping.get(outgoingInternalTransition.getLetter())).append("] ").append((String)this.mStateMapping.get(outgoingInternalTransition.getSucc())).append(NEW_LINE);
                }
            }
        }
        return stringBuilder;
    }
}

