/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.HashMap;

public final class Sort {
    final SortSymbol mSymbol;
    final Sort[] mArgs;
    final String[] mIndices;
    Sort mRealSort;
    private int mHash;

    Sort(SortSymbol sortSymbol, String[] stringArray, Sort[] sortArray) {
        assert (sortArray != null);
        assert (sortArray.length == (sortSymbol.isSortVariable() ? 0 : sortSymbol.mNumParams)) : "Sort created with wrong number of args";
        this.mSymbol = sortSymbol;
        this.mIndices = stringArray;
        this.mArgs = sortArray;
        this.mHash = HashUtils.hashJenkins((int)this.mSymbol.hashCode(), (Object[])this.mArgs);
        if (this.mIndices != null) {
            this.mHash = HashUtils.hashJenkins((int)this.mHash, (Object[])this.mIndices);
        }
    }

    public String getName() {
        return this.mSymbol.getName();
    }

    public String getIndexedName() {
        String string = PrintTerm.quoteIdentifier(this.mSymbol.getName());
        if (this.mIndices == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(_ ").append(string);
        String[] stringArray = this.mIndices;
        int n = this.mIndices.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            stringBuilder.append(' ').append(string2);
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public SortSymbol getSortSymbol() {
        return this.mSymbol;
    }

    public String[] getIndices() {
        return this.mIndices;
    }

    public Sort[] getArguments() {
        return this.mArgs;
    }

    public Sort getRealSort() {
        if (this.mRealSort == null) {
            if (this.mSymbol.mSortDefinition == null) {
                if (this.mArgs.length == 0) {
                    this.mRealSort = this;
                } else {
                    Sort[] sortArray = this.mArgs;
                    int n = 0;
                    while (n < sortArray.length) {
                        Sort sort = this.mArgs[n].getRealSort();
                        if (sort != this.mArgs[n]) {
                            if (sortArray == this.mArgs) {
                                sortArray = (Sort[])this.mArgs.clone();
                            }
                            sortArray[n] = sort;
                        }
                        ++n;
                    }
                    this.mRealSort = sortArray == this.mArgs ? this : this.mSymbol.getSort(this.mIndices, sortArray).getRealSort();
                }
            } else {
                this.mRealSort = this.mSymbol.mSortDefinition.mapSort(this.mArgs).getRealSort();
            }
        }
        return this.mRealSort;
    }

    boolean equalsSort(Sort sort) {
        if (this == sort) {
            return true;
        }
        return this.getRealSort() == sort.getRealSort();
    }

    boolean unifySort(HashMap<Sort, Sort> hashMap, Sort sort) {
        assert (sort.getRealSort() == sort);
        Sort sort2 = hashMap.get(this);
        if (sort2 != null) {
            return sort2 == sort;
        }
        if (!this.mSymbol.isSortVariable()) {
            Sort sort3 = this.getRealSort();
            if (sort3.mSymbol != sort.mSymbol) {
                return false;
            }
            int n = 0;
            while (n < sort3.mArgs.length) {
                if (!sort3.mArgs[n].unifySort(hashMap, sort.mArgs[n])) {
                    return false;
                }
                ++n;
            }
        }
        hashMap.put(this, sort);
        return true;
    }

    public Sort mapSort(Sort[] sortArray) {
        if (this.mSymbol.isSortVariable()) {
            return sortArray[this.mSymbol.mNumParams];
        }
        if (this.mArgs.length == 0) {
            return this;
        }
        if (this.mArgs.length == 1) {
            Sort sort = this.mArgs[0].mapSort(sortArray);
            return this.mSymbol.getSort(this.mIndices, sort);
        }
        HashMap<Sort, Sort> hashMap = new HashMap<Sort, Sort>();
        return this.mapSort(sortArray, hashMap);
    }

    Sort mapSort(Sort[] sortArray, HashMap<Sort, Sort> hashMap) {
        if (this.mSymbol.isSortVariable()) {
            return sortArray[this.mSymbol.mNumParams];
        }
        Sort sort = hashMap.get(this);
        if (sort != null) {
            return sort;
        }
        if (this.mArgs.length == 0) {
            sort = this;
        } else {
            Sort[] sortArray2 = new Sort[this.mArgs.length];
            int n = 0;
            while (n < this.mArgs.length) {
                sortArray2[n] = this.mArgs[n].mapSort(sortArray, hashMap);
                ++n;
            }
            sort = this.mSymbol.getSort(this.mIndices, sortArray2);
        }
        hashMap.put(this, sort);
        return sort;
    }

    public boolean isSortVariable() {
        return this.mSymbol.isSortVariable();
    }

    public String toString() {
        if (this.mArgs.length == 0) {
            return this.getIndexedName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        new PrintTerm().append((Appendable)stringBuilder, this);
        return stringBuilder.toString();
    }

    void toStringHelper(ArrayDeque<Object> arrayDeque) {
        String string = this.getIndexedName();
        Sort[] sortArray = this.getArguments();
        if (sortArray.length == 0) {
            arrayDeque.addLast(string);
        } else {
            arrayDeque.addLast(")");
            int n = sortArray.length - 1;
            while (n >= 0) {
                arrayDeque.addLast(sortArray[n]);
                arrayDeque.addLast(" ");
                --n;
            }
            arrayDeque.addLast(string);
            arrayDeque.addLast("(");
        }
    }

    public Theory getTheory() {
        return this.mSymbol.mTheory;
    }

    public boolean isArraySort() {
        return this.getRealSort().mSymbol.isArray();
    }

    public boolean isBitVecSort() {
        return this.getName().equals("BitVec");
    }

    public boolean isNumericSort() {
        return this.getRealSort().mSymbol.isNumeric();
    }

    public boolean isInternal() {
        return this.mSymbol.isIntern();
    }

    public int hashCode() {
        return this.mHash;
    }
}

