/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.translator;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;

public class CDDTranslator {
    public Expression toBoogie(CDD cDD, BoogieLocation boogieLocation) {
        if (cDD == CDD.TRUE) {
            return new BooleanLiteral((ILocation)boogieLocation, true);
        }
        if (cDD == CDD.FALSE) {
            return new BooleanLiteral((ILocation)boogieLocation, false);
        }
        CDD cDD2 = cDD.getDecision().simplify(cDD.getChilds());
        if (cDD2 == CDD.TRUE) {
            return new BooleanLiteral((ILocation)boogieLocation, true);
        }
        if (cDD2 == CDD.FALSE) {
            return new BooleanLiteral((ILocation)boogieLocation, false);
        }
        CDD[] cDDArray = cDD2.getChilds();
        Decision decision = cDD2.getDecision();
        Object object = null;
        int n = 0;
        while (n < cDDArray.length) {
            if (cDDArray[n] != CDD.FALSE) {
                Object object2 = this.toBoogie(cDDArray[n], boogieLocation);
                if (!cDD2.childDominates(n)) {
                    Expression expression;
                    if (decision instanceof RangeDecision) {
                        expression = CDDTranslator.toExpressionForRange(n, decision.getVar(), ((RangeDecision)decision).getLimits(), boogieLocation);
                    } else if (decision instanceof BoogieBooleanExpressionDecision) {
                        expression = ((BoogieBooleanExpressionDecision)decision).getExpression();
                    } else if (decision instanceof BooleanDecision) {
                        expression = new IdentifierExpression((ILocation)boogieLocation, ((BooleanDecision)decision).getVar());
                    } else if (decision instanceof EventDecision) {
                        expression = new IdentifierExpression((ILocation)boogieLocation, ((EventDecision)decision).getVar());
                    } else {
                        throw new UnsupportedOperationException("Unknown decision type: " + String.valueOf(decision.getClass()));
                    }
                    if (n == 1 && !(decision instanceof RangeDecision)) {
                        expression = new UnaryExpression((ILocation)boogieLocation, UnaryExpression.Operator.LOGICNEG, expression);
                    }
                    object2 = object2 instanceof BooleanLiteral && ((BooleanLiteral)object2).getValue() ? expression : new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.LOGICAND, expression, object2);
                }
                object = object == null ? object2 : new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.LOGICOR, object2, object);
            }
            ++n;
        }
        if (object == null) {
            return new BooleanLiteral((ILocation)boogieLocation, false);
        }
        return object;
    }

    public static Expression toExpressionForRange(int n, String string, int[] nArray, BoogieLocation boogieLocation) {
        if (n == 0) {
            IdentifierExpression identifierExpression = new IdentifierExpression((ILocation)boogieLocation, string);
            RealLiteral realLiteral = new RealLiteral((ILocation)boogieLocation, Double.toString(nArray[0] / 2));
            if ((nArray[0] & 1) == 0) {
                return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLT, (Expression)identifierExpression, (Expression)realLiteral);
            }
            return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLEQ, (Expression)identifierExpression, (Expression)realLiteral);
        }
        if (n == nArray.length) {
            IdentifierExpression identifierExpression = new IdentifierExpression((ILocation)boogieLocation, string);
            RealLiteral realLiteral = new RealLiteral((ILocation)boogieLocation, Double.toString(nArray[nArray.length - 1] / 2));
            if ((nArray[nArray.length - 1] & 1) == 1) {
                return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPGT, (Expression)identifierExpression, (Expression)realLiteral);
            }
            return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPGEQ, (Expression)identifierExpression, (Expression)realLiteral);
        }
        if (nArray[n - 1] / 2 == nArray[n] / 2) {
            IdentifierExpression identifierExpression = new IdentifierExpression((ILocation)boogieLocation, string);
            RealLiteral realLiteral = new RealLiteral((ILocation)boogieLocation, Double.toString(nArray[n] / 2));
            return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)realLiteral);
        }
        RealLiteral realLiteral = new RealLiteral((ILocation)boogieLocation, Double.toString(nArray[n - 1] / 2));
        RealLiteral realLiteral2 = new RealLiteral((ILocation)boogieLocation, Double.toString(nArray[n] / 2));
        IdentifierExpression identifierExpression = new IdentifierExpression((ILocation)boogieLocation, string);
        BinaryExpression binaryExpression = (nArray[n - 1] & 1) == 1 ? new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLT, (Expression)realLiteral, (Expression)identifierExpression) : new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLEQ, (Expression)realLiteral, (Expression)identifierExpression);
        BinaryExpression binaryExpression2 = (nArray[n] & 1) == 0 ? new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLT, (Expression)identifierExpression, (Expression)realLiteral2) : new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.COMPLEQ, (Expression)identifierExpression, (Expression)realLiteral2);
        return new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.LOGICAND, (Expression)binaryExpression, (Expression)binaryExpression2);
    }
}

