/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.DagInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResourceCache;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResources;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;
import java.util.HashMap;
import java.util.Map;

public class TopInputCallSummarizer
implements ICallSummarizer {
    private final SifaStats mStats;
    private final SymbolicTools mTools;
    private final ProcedureResourceCache mProcResCache;
    private final DagInterpreter mDagIpreter;
    private final Map<String, IPredicate> mProcToSummary = new HashMap<String, IPredicate>();

    public TopInputCallSummarizer(SifaStats sifaStats, SymbolicTools symbolicTools, ProcedureResourceCache procedureResourceCache, DagInterpreter dagInterpreter) {
        this.mStats = sifaStats;
        this.mTools = symbolicTools;
        this.mProcResCache = procedureResourceCache;
        this.mDagIpreter = dagInterpreter;
    }

    @Override
    public IPredicate summarize(String string, IPredicate iPredicate) {
        this.mStats.start(SifaStats.Key.CALL_SUMMARIZER_OVERALL_TIME);
        this.mStats.increment(SifaStats.Key.CALL_SUMMARIZER_APPLICATIONS);
        IPredicate iPredicate2 = this.mProcToSummary.get(string);
        if (iPredicate2 == null) {
            iPredicate2 = this.computeTopSummary(string);
            IPredicate iPredicate3 = this.mProcToSummary.put(string, iPredicate2);
            assert (iPredicate3 == null || iPredicate2 == iPredicate3);
        }
        this.mStats.stop(SifaStats.Key.CALL_SUMMARIZER_OVERALL_TIME);
        return iPredicate2;
    }

    private IPredicate computeTopSummary(String string) {
        this.mStats.start(SifaStats.Key.CALL_SUMMARIZER_NEW_COMPUTATION_TIME);
        this.mStats.increment(SifaStats.Key.CALL_SUMMARIZER_CACHE_MISSES);
        ProcedureResources procedureResources = this.mProcResCache.resourcesOf(string);
        IPredicate iPredicate = this.mDagIpreter.interpretForSingleMarker(procedureResources.getRegexDag(), procedureResources.getDagOverlayPathToReturn(), this.mTools.top());
        this.mStats.stop(SifaStats.Key.CALL_SUMMARIZER_NEW_COMPUTATION_TIME);
        return iPredicate;
    }
}

