/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.graph;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.witnessparser.Activator;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;

public class WitnessEdgeAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = Activator.PLUGIN_ID + "_Edge";
    @Visualizable
    private final Boolean mCondition;
    @Visualizable
    private final String mEnterFrom;
    @Visualizable
    private final String mReturnFrom;
    @Visualizable
    private final String mTokens;
    @Visualizable
    private final String mAssumption;
    @Visualizable
    private final Boolean mEnterLoopHead;

    public WitnessEdgeAnnotation(String string, String string2, String string3, String string4, String string5, String string6) {
        this(WitnessEdgeAnnotation.convertOrFail(string), WitnessEdgeAnnotation.convertOrFail(string2), string3, string4, string5, string6);
    }

    public WitnessEdgeAnnotation(Boolean bl, Boolean bl2, String string, String string2, String string3, String string4) {
        this.mCondition = bl;
        this.mEnterFrom = string;
        this.mEnterLoopHead = bl2;
        this.mReturnFrom = string2;
        this.mTokens = string3;
        this.mAssumption = string4;
    }

    public Boolean getCondition() {
        return this.mCondition;
    }

    public String getEnterFrom() {
        return this.mEnterFrom;
    }

    public String getReturnFrom() {
        return this.mReturnFrom;
    }

    public String getTokens() {
        return this.mTokens;
    }

    public String getAssumption() {
        return this.mAssumption;
    }

    public Boolean getEnterLoopHead() {
        return this.mEnterLoopHead;
    }

    public boolean isEmpty() {
        return this.getCondition() == null && this.getEnterFrom() == null && this.getReturnFrom() == null && this.getTokens() == null && this.getAssumption() == null && this.getEnterLoopHead() == null;
    }

    public void annotate(IElement iElement) {
        if (iElement instanceof WitnessEdge) {
            this.annotate((WitnessEdge)iElement);
        }
    }

    public void annotate(WitnessEdge witnessEdge) {
        witnessEdge.getPayload().getAnnotations().put(KEY, this);
    }

    public static WitnessEdgeAnnotation getAnnotation(IElement iElement) {
        return (WitnessEdgeAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (WitnessEdgeAnnotation)((Object)iAnnotations));
    }

    private static Boolean convertOrFail(String string) {
        if (string == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("A boolean attribute has to be true or false");
    }
}

