/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.SMTSolver;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

class SupportingInvariantSimplifier
implements AutoCloseable {
    private final boolean mAnnotateTerms;
    private Script mScript;
    private final IUltimateServiceProvider mServices;

    public SupportingInvariantSimplifier(ILassoRankerPreferences iLassoRankerPreferences, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        this.mServices = iUltimateServiceProvider;
        this.mAnnotateTerms = iLassoRankerPreferences.isAnnotateTerms();
        this.mScript = SMTSolver.newScript(iLassoRankerPreferences, "SimplifySIs", iUltimateServiceProvider);
        this.mScript.setLogic(Logics.QF_LRA);
    }

    @Override
    public void close() {
        if (this.mScript != null) {
            this.mScript.exit();
            this.mScript = null;
        }
    }

    private static LinearInequality SI2LI(SupportingInvariant supportingInvariant) {
        LinearInequality linearInequality = new LinearInequality();
        linearInequality.add(new AffineTerm(supportingInvariant.mConstant));
        for (Map.Entry entry : supportingInvariant.mCoefficients.entrySet()) {
            linearInequality.add(ReplacementVarUtils.getDefinition((IProgramVar)((IProgramVar)entry.getKey())), new AffineTerm((BigInteger)entry.getValue()));
        }
        linearInequality.setStrict(supportingInvariant.strict);
        return linearInequality;
    }

    public Collection<SupportingInvariant> simplify(Collection<SupportingInvariant> collection) {
        HashSet<SupportingInvariant> hashSet = new HashSet<SupportingInvariant>(collection);
        for (SupportingInvariant supportingInvariant : collection) {
            this.mScript.push(1);
            MotzkinTransformation motzkinTransformation = new MotzkinTransformation(this.mServices, this.mScript, AnalysisType.LINEAR, this.mAnnotateTerms);
            LinearInequality linearInequality = SupportingInvariantSimplifier.SI2LI(supportingInvariant);
            linearInequality.negate();
            motzkinTransformation.addInequality(linearInequality);
            for (SupportingInvariant supportingInvariant2 : hashSet) {
                if (supportingInvariant2 == supportingInvariant) continue;
                LinearInequality linearInequality2 = SupportingInvariantSimplifier.SI2LI(supportingInvariant2);
                motzkinTransformation.addInequality(linearInequality2);
            }
            motzkinTransformation.mAnnotation = "Simplifying supporting invariant";
            this.mScript.assertTerm(motzkinTransformation.transform(new Rational[0]));
            linearInequality.negate();
            if (this.mScript.checkSat().equals((Object)Script.LBool.SAT)) {
                hashSet.remove(supportingInvariant);
            }
            this.mScript.pop(1);
        }
        return hashSet;
    }
}

