/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.dataflow;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataflowState<ACTION extends IAction>
implements IAbstractState<DataflowState<ACTION>> {
    private static int sId;
    private final int mId;
    private final ImmutableSet<IProgramVarOrConst> mVars;
    private final Map<IProgramVarOrConst, Set<ACTION>> mDef;
    private final Map<IProgramVarOrConst, Set<ACTION>> mUse;
    private final Map<IProgramVarOrConst, Set<ACTION>> mReachDef;
    private final Map<IProgramVarOrConst, Set<IcfgLocation>> mNoWrite;

    DataflowState() {
        this((ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty(), new HashMap<IProgramVarOrConst, Set<ACTION>>(), new HashMap<IProgramVarOrConst, Set<ACTION>>(), new HashMap<IProgramVarOrConst, Set<ACTION>>(), new HashMap<IProgramVarOrConst, Set<IcfgLocation>>());
    }

    DataflowState(ImmutableSet<IProgramVarOrConst> immutableSet, Map<IProgramVarOrConst, Set<ACTION>> map, Map<IProgramVarOrConst, Set<ACTION>> map2, Map<IProgramVarOrConst, Set<ACTION>> map3, Map<IProgramVarOrConst, Set<IcfgLocation>> map4) {
        assert (immutableSet != null);
        assert (map != null);
        assert (map2 != null);
        assert (map3 != null);
        this.mVars = immutableSet;
        this.mDef = map;
        this.mUse = map2;
        this.mReachDef = map3;
        this.mId = DataflowState.getFreshId();
        this.mNoWrite = map4;
    }

    public DataflowState<ACTION> addVariable(IProgramVarOrConst iProgramVarOrConst) {
        if (this.mVars.contains((Object)iProgramVarOrConst)) {
            return this;
        }
        Set set = DataStructureUtils.getFreshSet(this.mVars, (int)(this.mVars.size() + 1));
        set.add(iProgramVarOrConst);
        return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set), this.mDef, this.mUse, this.mReachDef, this.mNoWrite);
    }

    public DataflowState<ACTION> removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        if (!this.mVars.contains((Object)iProgramVarOrConst)) {
            return this;
        }
        Set set = DataStructureUtils.getFreshSet(this.mVars);
        set.remove(iProgramVarOrConst);
        Map<IProgramVarOrConst, Set<ACTION>> map = AbsIntUtil.getFreshMap(this.mDef);
        map.remove(iProgramVarOrConst);
        Map<IProgramVarOrConst, Set<ACTION>> map2 = AbsIntUtil.getFreshMap(this.mUse);
        map2.remove(iProgramVarOrConst);
        Map<IProgramVarOrConst, Set<ACTION>> map3 = AbsIntUtil.getFreshMap(this.mReachDef);
        map2.remove(iProgramVarOrConst);
        Map<IProgramVarOrConst, Set<IcfgLocation>> map4 = AbsIntUtil.getFreshMap(this.mNoWrite);
        map2.remove(iProgramVarOrConst);
        return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set), map, map2, map3, map4);
    }

    public DataflowState<ACTION> addVariables(Collection<IProgramVarOrConst> collection) {
        if (collection == null || collection.isEmpty()) {
            return this;
        }
        Set set = DataStructureUtils.getFreshSet(this.mVars, (int)(this.mVars.size() + collection.size()));
        set.addAll(collection);
        return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set), this.mDef, this.mUse, this.mReachDef, this.mNoWrite);
    }

    public DataflowState<ACTION> removeVariables(Collection<IProgramVarOrConst> collection) {
        if (collection == null || collection.isEmpty()) {
            return this;
        }
        Set set = DataStructureUtils.getFreshSet(this.mVars);
        Map map = AbsIntUtil.getFreshMap(this.mDef);
        Map map2 = AbsIntUtil.getFreshMap(this.mUse);
        Map map3 = AbsIntUtil.getFreshMap(this.mReachDef);
        Map<IProgramVarOrConst, Set<IcfgLocation>> map4 = AbsIntUtil.getFreshMap(this.mNoWrite);
        collection.stream().forEach(iProgramVarOrConst -> {
            set.remove(iProgramVarOrConst);
            map.remove(iProgramVarOrConst);
            map2.remove(iProgramVarOrConst);
            map3.remove(iProgramVarOrConst);
            map4.remove(iProgramVarOrConst);
        });
        return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set), map, map2, map3, map4);
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mVars.contains((Object)iProgramVarOrConst);
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mVars;
    }

    public DataflowState<ACTION> patch(DataflowState<ACTION> dataflowState) {
        return null;
    }

    public boolean isEmpty() {
        return this.mVars.isEmpty();
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isEqualTo(DataflowState<ACTION> dataflowState) {
        if (dataflowState == null) {
            return false;
        }
        if (!dataflowState.mVars.equals(this.mVars)) {
            return false;
        }
        if (!dataflowState.mDef.equals(this.mDef)) {
            return false;
        }
        if (!dataflowState.mUse.equals(this.mUse)) {
            return false;
        }
        if (!dataflowState.mReachDef.equals(this.mReachDef)) {
            return false;
        }
        return dataflowState.mNoWrite.equals(this.mNoWrite);
    }

    public IAbstractState.SubsetResult isSubsetOf(DataflowState<ACTION> dataflowState) {
        if (this.isEqualTo(dataflowState)) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        return IAbstractState.SubsetResult.NONE;
    }

    public Term getTerm(Script script) {
        return script.term("true", new Term[0]);
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (Map.Entry<IProgramVarOrConst, Set<ACTION>> entry : this.mReachDef.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            stringBuilder.append(entry.getKey().getGloballyUniqueId());
            stringBuilder.append("->");
            if (entry.getValue().size() == 1) {
                stringBuilder.append(((IAction)entry.getValue().iterator().next()).hashCode());
            } else {
                stringBuilder.append('{');
                for (IAction iAction : entry.getValue()) {
                    stringBuilder.append(iAction.hashCode());
                    stringBuilder.append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                stringBuilder.append('}');
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataflowState dataflowState = (DataflowState)object;
        if (!this.isEqualTo(dataflowState)) {
            return false;
        }
        return dataflowState.mId == this.mId;
    }

    Map<IProgramVarOrConst, Set<ACTION>> getDef() {
        return Collections.unmodifiableMap(this.mDef);
    }

    Map<IProgramVarOrConst, Set<ACTION>> getUse() {
        return Collections.unmodifiableMap(this.mUse);
    }

    Map<IProgramVarOrConst, Set<ACTION>> getReachingDefinitions() {
        return Collections.unmodifiableMap(this.mReachDef);
    }

    Map<IProgramVarOrConst, Set<IcfgLocation>> getNoWrite() {
        return Collections.unmodifiableMap(this.mNoWrite);
    }

    public DataflowState<ACTION> union(DataflowState<ACTION> dataflowState) {
        HashSet<ACTION> hashSet;
        Set<Object> set;
        if (dataflowState == null || dataflowState == this || dataflowState.isEqualTo(this)) {
            return this;
        }
        if (!this.mVars.equals(dataflowState.mVars)) {
            throw new UnsupportedOperationException("Cannot create union of two incompatible dataflow states");
        }
        Set set2 = DataStructureUtils.getFreshSet(this.mVars);
        Map<IProgramVarOrConst, Set<ACTION>> map = AbsIntUtil.getFreshMap(this.mDef);
        Map<IProgramVarOrConst, Set<ACTION>> map2 = AbsIntUtil.getFreshMap(this.mUse);
        Map<IProgramVarOrConst, Set<ACTION>> map3 = AbsIntUtil.getFreshMap(this.mReachDef);
        Map<IProgramVarOrConst, Set<IcfgLocation>> map4 = AbsIntUtil.getFreshMap(this.mNoWrite);
        for (Map.Entry<IProgramVarOrConst, Set<ACTION>> entry : dataflowState.mReachDef.entrySet()) {
            set = map3.get(entry.getKey());
            if (set == null) {
                map3.put(entry.getKey(), new HashSet(entry.getValue()));
                continue;
            }
            hashSet = new HashSet<ACTION>((Collection)entry.getValue());
            hashSet.addAll(set);
            map3.put(entry.getKey(), hashSet);
        }
        for (Map.Entry<IProgramVarOrConst, Set<Object>> entry : dataflowState.mNoWrite.entrySet()) {
            set = map4.get(entry.getKey());
            if (set == null) {
                map4.put(entry.getKey(), new HashSet(entry.getValue()));
                continue;
            }
            hashSet = new HashSet(entry.getValue());
            hashSet.addAll(set);
            map4.put(entry.getKey(), hashSet);
        }
        return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set2), map, map2, map3, map4);
    }

    public DataflowState<ACTION> intersect(DataflowState<ACTION> dataflowState) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static int getFreshId() {
        return ++sId;
    }

    public Set<IcfgLocation> getNowriteLocations(IProgramVar iProgramVar) {
        return this.mNoWrite.get(iProgramVar);
    }

    public Set<ACTION> getReachingDefinitions(IProgramVar iProgramVar) {
        return this.mReachDef.get(iProgramVar);
    }

    public DataflowState<ACTION> compact() {
        return this;
    }

    public DataflowState<ACTION> renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        Set set = DataStructureUtils.getFreshSet(this.mVars);
        Map<IProgramVarOrConst, Set<ACTION>> map2 = AbsIntUtil.getFreshMap(this.mDef);
        Map<IProgramVarOrConst, Set<ACTION>> map3 = AbsIntUtil.getFreshMap(this.mUse);
        Map<IProgramVarOrConst, Set<ACTION>> map4 = AbsIntUtil.getFreshMap(this.mReachDef);
        Map<IProgramVarOrConst, Set<IcfgLocation>> map5 = AbsIntUtil.getFreshMap(this.mNoWrite);
        Map[] mapArray = new Map[]{map2, map3, map4, map5};
        boolean bl = false;
        for (Map.Entry<IProgramVarOrConst, IProgramVarOrConst> entry : map.entrySet()) {
            IProgramVarOrConst iProgramVarOrConst = entry.getKey();
            IProgramVarOrConst iProgramVarOrConst2 = entry.getValue();
            if (iProgramVarOrConst2 == null) {
                throw new IllegalArgumentException("Cannot rename " + String.valueOf(iProgramVarOrConst) + " to null");
            }
            if (iProgramVarOrConst == iProgramVarOrConst2 || !set.remove(iProgramVarOrConst)) continue;
            bl = true;
            set.add(iProgramVarOrConst2);
            Map[] mapArray2 = mapArray;
            int n = mapArray.length;
            int n2 = 0;
            while (n2 < n) {
                Map map6 = mapArray2[n2];
                if (map6.containsKey(iProgramVarOrConst)) {
                    Object v = map6.remove(iProgramVarOrConst);
                    map6.put(iProgramVarOrConst2, v);
                }
                ++n2;
            }
        }
        if (bl) {
            return new DataflowState<ACTION>((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set), map2, map3, map4, map5);
        }
        return this;
    }
}

