/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.LiteralCollection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.function.Consumer;

public class IntervalLiteralWideningOperator
implements IAbstractStateBinaryOperator<IntervalDomainState> {
    private final LiteralCollection mLiteralCollection;

    public IntervalLiteralWideningOperator(LiteralCollection literalCollection) {
        this.mLiteralCollection = literalCollection;
    }

    public IntervalDomainState apply(IntervalDomainState intervalDomainState, IntervalDomainState intervalDomainState2) {
        IProgramVarOrConst[] iProgramVarOrConstArray2;
        assert (intervalDomainState.hasSameVariables(intervalDomainState2));
        assert (!intervalDomainState.isBottom() && !intervalDomainState2.isBottom());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        Consumer<IProgramVarOrConst> consumer = iProgramVarOrConst -> {
            IntervalDomainValue intervalDomainValue = (IntervalDomainValue)intervalDomainState.getValue((IProgramVarOrConst)iProgramVarOrConst);
            IntervalDomainValue intervalDomainValue2 = (IntervalDomainValue)intervalDomainState2.getValue((IProgramVarOrConst)iProgramVarOrConst);
            if (intervalDomainValue2.isContainedIn(intervalDomainValue)) {
                arrayList3.add(iProgramVarOrConst);
                arrayList4.add(intervalDomainValue);
            } else if (!intervalDomainValue.isAbstractionEqual(intervalDomainValue2)) {
                arrayList3.add(iProgramVarOrConst);
                arrayList4.add(this.determineNextValue(intervalDomainValue, intervalDomainValue2));
            }
        };
        Consumer<IProgramVarOrConst> consumer2 = iProgramVarOrConst -> {
            BooleanValue booleanValue;
            BooleanValue booleanValue2 = intervalDomainState.getBooleanValue((IProgramVarOrConst)iProgramVarOrConst);
            if (!booleanValue2.isEqualTo(booleanValue = intervalDomainState2.getBooleanValue((IProgramVarOrConst)iProgramVarOrConst))) {
                arrayList.add(iProgramVarOrConst);
                arrayList2.add(BooleanValue.TOP);
            }
        };
        for (IProgramVarOrConst[] iProgramVarOrConstArray2 : intervalDomainState.getVariables()) {
            TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVarOrConstArray2);
        }
        iProgramVarOrConstArray2 = arrayList3.toArray(new IProgramVarOrConst[arrayList3.size()]);
        INonrelationalValue[] iNonrelationalValueArray = arrayList4.toArray(new IntervalDomainValue[arrayList4.size()]);
        IProgramVarOrConst[] iProgramVarOrConstArray3 = arrayList.toArray(new IProgramVarOrConst[arrayList.size()]);
        BooleanValue[] booleanValueArray = arrayList2.toArray(new BooleanValue[arrayList2.size()]);
        IProgramVarOrConst[] iProgramVarOrConstArray4 = arrayList5.toArray(new IProgramVarOrConst[arrayList5.size()]);
        INonrelationalValue[] iNonrelationalValueArray2 = arrayList6.toArray(new IntervalDomainValue[arrayList6.size()]);
        return (IntervalDomainState)intervalDomainState.setMixedValues(iProgramVarOrConstArray2, iNonrelationalValueArray, iProgramVarOrConstArray3, booleanValueArray, iProgramVarOrConstArray4, iNonrelationalValueArray2);
    }

    private IntervalDomainValue determineNextValue(IntervalDomainValue intervalDomainValue, IntervalDomainValue intervalDomainValue2) {
        if (intervalDomainValue.isAbstractionEqual(intervalDomainValue2)) {
            return intervalDomainValue;
        }
        IntervalValue intervalValue = intervalDomainValue.getLower();
        IntervalValue intervalValue2 = intervalDomainValue.getUpper();
        IntervalValue intervalValue3 = intervalDomainValue2.getLower();
        IntervalValue intervalValue4 = intervalDomainValue2.getUpper();
        if (intervalValue.isInfinity() || !intervalValue.isInfinity() && !intervalValue3.isInfinity() && intervalValue.compareTo(intervalValue3) <= 0) {
            return new IntervalDomainValue(intervalValue, this.widenUpper(intervalValue2, intervalValue4));
        }
        if (intervalValue2.isInfinity() || !intervalValue2.isInfinity() && intervalValue2.compareTo(intervalValue4) >= 0) {
            return new IntervalDomainValue(this.widenLower(intervalValue, intervalValue3), intervalValue2);
        }
        return new IntervalDomainValue(this.widenLower(intervalValue, intervalValue3), this.widenUpper(intervalValue2, intervalValue4));
    }

    private IntervalValue widenLower(IntervalValue intervalValue, IntervalValue intervalValue2) {
        if (intervalValue.isInfinity() || intervalValue2.isInfinity()) {
            return new IntervalValue();
        }
        int n = intervalValue.compareTo(intervalValue2);
        BigDecimal bigDecimal = n < 0 ? this.mLiteralCollection.getNextRealNegative(intervalValue.getValue()) : (n > 0 ? this.mLiteralCollection.getNextRealNegative(intervalValue2.getValue()) : intervalValue.getValue());
        if (bigDecimal == null) {
            return new IntervalValue();
        }
        if (n != 0) {
            bigDecimal = bigDecimal.setScale(0, RoundingMode.FLOOR);
        }
        return new IntervalValue(bigDecimal);
    }

    private IntervalValue widenUpper(IntervalValue intervalValue, IntervalValue intervalValue2) {
        if (intervalValue.isInfinity() || intervalValue2.isInfinity()) {
            return new IntervalValue();
        }
        int n = intervalValue.compareTo(intervalValue2);
        BigDecimal bigDecimal = n > 0 ? this.mLiteralCollection.getNextRealPositive(intervalValue.getValue()) : (n < 0 ? this.mLiteralCollection.getNextRealPositive(intervalValue2.getValue()) : intervalValue.getValue());
        if (bigDecimal == null) {
            return new IntervalValue();
        }
        if (n != 0) {
            bigDecimal = bigDecimal.setScale(0, RoundingMode.CEILING);
        }
        return new IntervalValue(bigDecimal);
    }
}

