/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.INaryTermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluatorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.TermExpressionEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class NonrelationalTermProcessor<VALUE extends INonrelationalValue<VALUE>, STATE extends NonrelationalState<STATE, VALUE>>
extends NonRecursive {
    protected final ILogger mLogger;
    private final ITermEvaluatorFactory<VALUE, STATE> mEvaluatorFactory;
    private final Supplier<STATE> mBottomStateSupplier;
    private TermExpressionEvaluator<VALUE, STATE> mExpressionEvaluator;

    public NonrelationalTermProcessor(ILogger iLogger, int n, Supplier<STATE> supplier) {
        this.mLogger = iLogger;
        this.mEvaluatorFactory = this.createEvaluatorFactory(n);
        this.mBottomStateSupplier = supplier;
    }

    protected abstract ITermEvaluatorFactory<VALUE, STATE> createEvaluatorFactory(int var1);

    protected abstract INonrelationalValueFactory<VALUE> getNonrelationalValueFactory();

    protected List<STATE> process(Term term, STATE STATE) {
        this.mLogger.debug((Object)("Term processor is analyzing term: " + String.valueOf(term)));
        this.mExpressionEvaluator = new TermExpressionEvaluator();
        this.run((NonRecursive.Walker)new NonrelationalTermWalker(term, this.mLogger));
        if (!this.mExpressionEvaluator.isFinished()) {
            throw new IllegalStateException("Invalid state: the expression evaluator is not finished.");
        }
        List<IEvaluationResult<VALUE>> list = this.mExpressionEvaluator.getRootEvaluator().evaluate(STATE);
        assert (list != null);
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (IEvaluationResult<VALUE> iEvaluationResult : list) {
            arrayList.addAll(this.mExpressionEvaluator.getRootEvaluator().inverseEvaluate(iEvaluationResult, STATE));
        }
        return arrayList;
    }

    private final class NonrelationalTermWalker
    extends NonRecursive.TermWalker {
        private final ILogger mLogger;

        public NonrelationalTermWalker(Term term, ILogger iLogger) {
            super(term);
            this.mLogger = iLogger;
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
            this.mLogger.debug((Object)("Constant Term: " + String.valueOf(constantTerm)));
            this.mLogger.debug((Object)("Type of value: " + constantTerm.getValue().getClass().getSimpleName()));
            ITermEvaluator iTermEvaluator = NonrelationalTermProcessor.this.mEvaluatorFactory.createConstantValueEvaluator(constantTerm.getValue());
            NonrelationalTermProcessor.this.mExpressionEvaluator.addEvaluator(iTermEvaluator);
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            this.mLogger.debug((Object)("Annotated Term: " + String.valueOf(annotatedTerm)));
            throw new UnsupportedOperationException("Not implemented!");
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            this.mLogger.debug((Object)("Application Term: " + String.valueOf(applicationTerm)));
            String string = applicationTerm.getFunction().getName();
            INaryTermEvaluator iNaryTermEvaluator = NonrelationalTermProcessor.this.mEvaluatorFactory.createApplicationTerm(applicationTerm.getParameters().length, string, NonrelationalTermProcessor.this.getNonrelationalValueFactory(), NonrelationalTermProcessor.this.mBottomStateSupplier);
            NonrelationalTermProcessor.this.mExpressionEvaluator.addEvaluator(iNaryTermEvaluator);
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                NonrelationalTermProcessor.this.run((NonRecursive.Walker)new NonrelationalTermWalker(term, this.mLogger));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            this.mLogger.debug((Object)("Let Term: " + String.valueOf(letTerm)));
            throw new UnsupportedOperationException("Not implemented!");
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            this.mLogger.debug((Object)("Quantified Formula: " + String.valueOf(quantifiedFormula)));
            throw new UnsupportedOperationException("Not implemented!");
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            this.mLogger.debug((Object)("Term Variable: " + String.valueOf(termVariable)));
            ITermEvaluator iTermEvaluator = NonrelationalTermProcessor.this.mEvaluatorFactory.createVariableTermEvaluator(termVariable.getName(), termVariable.getSort());
            NonrelationalTermProcessor.this.mExpressionEvaluator.addEvaluator(iTermEvaluator);
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

