/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ReachDefBoogieAnnotator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace.ReachDefTracePredecessorGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.util.Util;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.List;

public class ReachDefTraceVisitor
extends RCFGEdgeVisitor {
    private final ILogger mLogger;
    private final CodeBlock mPredecessor;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mStatementProvider;
    private final IAnnotationProvider<ReachDefEdgeAnnotation> mEdgeProvider;
    private final ScopedBoogieVarBuilder mBuilder;
    private final int mKey;

    public ReachDefTraceVisitor(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, IAnnotationProvider<ReachDefEdgeAnnotation> iAnnotationProvider2, CodeBlock codeBlock, ILogger iLogger, ScopedBoogieVarBuilder scopedBoogieVarBuilder, int n) {
        this.mLogger = iLogger;
        this.mPredecessor = codeBlock;
        this.mStatementProvider = iAnnotationProvider;
        this.mEdgeProvider = iAnnotationProvider2;
        this.mBuilder = scopedBoogieVarBuilder;
        this.mKey = n;
    }

    public void process(CodeBlock codeBlock) {
        String string = String.valueOf(this.mKey);
        ReachDefEdgeAnnotation reachDefEdgeAnnotation = this.mEdgeProvider.getAnnotation((IElement)codeBlock, string);
        if (reachDefEdgeAnnotation == null) {
            reachDefEdgeAnnotation = new ReachDefEdgeAnnotation((IcfgEdge)codeBlock, this.mStatementProvider, string);
            this.mEdgeProvider.annotate((IElement)codeBlock, reachDefEdgeAnnotation, string);
        }
        this.visit(codeBlock);
    }

    protected void visit(SequentialComposition sequentialComposition) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (IActionWithBranchEncoders iActionWithBranchEncoders : sequentialComposition.getCodeBlocks()) {
            if (iActionWithBranchEncoders instanceof StatementSequence) {
                arrayList.addAll(((StatementSequence)iActionWithBranchEncoders).getStatements());
                continue;
            }
            throw new UnsupportedOperationException("Cannot unwrap SequentialComposition because I dont know " + iActionWithBranchEncoders.getClass().getSimpleName());
        }
        this.processEdge((CodeBlock)sequentialComposition, arrayList);
        super.visit(sequentialComposition);
    }

    protected void visit(StatementSequence statementSequence) {
        this.processEdge((CodeBlock)statementSequence, statementSequence.getStatements());
        super.visit(statementSequence);
    }

    private void processEdge(CodeBlock codeBlock, List<Statement> list) {
        String string = String.valueOf(this.mKey);
        for (Statement statement : list) {
            ReachDefStatementAnnotation reachDefStatementAnnotation = this.mStatementProvider.getAnnotation((IElement)statement, string);
            if (reachDefStatementAnnotation == null) {
                reachDefStatementAnnotation = new ReachDefStatementAnnotation();
                this.mStatementProvider.annotate((IElement)statement, reachDefStatementAnnotation, string);
            }
            ReachDefBoogieAnnotator reachDefBoogieAnnotator = this.createBoogieAnnotator(list, statement, reachDefStatementAnnotation);
            try {
                reachDefBoogieAnnotator.annotate(statement, codeBlock.getTransformula());
                if (!this.mLogger.isDebugEnabled()) continue;
                String string2 = "            " + codeBlock.hashCode() + " " + BoogiePrettyPrinter.print((Statement)statement);
                this.mLogger.debug((Object)(string2 + Util.repeat(40 - string2.length(), " ") + " New Use: " + reachDefStatementAnnotation.getUseAsString()));
                this.mLogger.debug((Object)(string2 + Util.repeat(40 - string2.length(), " ") + " New Def: " + reachDefStatementAnnotation.getDefAsString()));
            }
            catch (Throwable throwable) {
                this.mLogger.fatal((Object)"Fatal error occured", throwable);
                return;
            }
        }
    }

    private ReachDefBoogieAnnotator createBoogieAnnotator(List<Statement> list, Statement statement, ReachDefStatementAnnotation reachDefStatementAnnotation) {
        int n = list.indexOf(statement);
        List<ReachDefStatementAnnotation> list2 = new ArrayList<ReachDefStatementAnnotation>();
        if (n != 0) {
            String string = String.valueOf(this.mKey);
            ReachDefStatementAnnotation reachDefStatementAnnotation2 = this.mStatementProvider.getAnnotation((IElement)list.get(n - 1), string);
            list2.add(reachDefStatementAnnotation2);
        } else if (this.mPredecessor != null) {
            String string = String.valueOf(this.mKey - 1);
            ReachDefTracePredecessorGenerator reachDefTracePredecessorGenerator = new ReachDefTracePredecessorGenerator(this.mStatementProvider, string);
            list2 = reachDefTracePredecessorGenerator.process(this.mPredecessor);
        }
        assert (list2.size() < 2);
        return new ReachDefBoogieAnnotator(list2, reachDefStatementAnnotation, this.mLogger, this.mBuilder, String.valueOf(this.mKey));
    }
}

