/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.util;

import java.util.AbstractSet;
import java.util.Iterator;

public class SimpleSet<T>
extends AbstractSet<T>
implements Cloneable {
    T[] elementObjects;
    int count = 0;

    public SimpleSet() {
        this(2);
    }

    public SimpleSet(int n) {
        this.elementObjects = new Object[n];
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.count) {
            if (t.equals(this.elementObjects[n])) {
                return false;
            }
            ++n;
        }
        if (this.count == this.elementObjects.length) {
            Object[] objectArray = new Object[(this.count + 1) * 3 / 2];
            System.arraycopy(this.elementObjects, 0, objectArray, 0, this.count);
            this.elementObjects = objectArray;
        }
        this.elementObjects[this.count++] = t;
        return true;
    }

    public Object clone() {
        try {
            SimpleSet simpleSet = (SimpleSet)super.clone();
            simpleSet.elementObjects = (Object[])this.elementObjects.clone();
            return simpleSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone?");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < SimpleSet.this.count;
            }

            @Override
            public T next() {
                return SimpleSet.this.elementObjects[this.pos++];
            }

            @Override
            public void remove() {
                if (this.pos < SimpleSet.this.count) {
                    System.arraycopy(SimpleSet.this.elementObjects, this.pos, SimpleSet.this.elementObjects, this.pos - 1, SimpleSet.this.count - this.pos);
                }
                --SimpleSet.this.count;
                --this.pos;
            }
        };
    }
}

