/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnifyHash<E>
extends AbstractCollection<E> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient ReferenceQueue<E> mQueue = new ReferenceQueue();
    private transient Bucket<E>[] mBuckets;
    transient int mModCount = 0;
    int mSize = 0;
    int mThreshold;
    float mLoadFactor;

    public UnifyHash(int n, float f) {
        this.mLoadFactor = f;
        this.mBuckets = new Bucket[n];
        this.mThreshold = (int)(f * (float)n);
    }

    public UnifyHash(int n) {
        this(n, 0.75f);
    }

    public UnifyHash() {
        this(11, 0.75f);
    }

    private void grow() {
        Bucket<E>[] bucketArray = this.mBuckets;
        int n = this.mBuckets.length * 2 + 1;
        this.mThreshold = (int)(this.mLoadFactor * (float)n);
        this.mBuckets = new Bucket[n];
        int n2 = 0;
        while (n2 < bucketArray.length) {
            Bucket<E> bucket = bucketArray[n2];
            while (bucket != null) {
                if (n2 != Math.abs(bucket.mHash % bucketArray.length)) {
                    throw new RuntimeException(n2 + ", hash: " + bucket.mHash + ", oldlength: " + bucketArray.length);
                }
                int n3 = Math.abs(bucket.mHash % n);
                Bucket bucket2 = bucket.mNext;
                bucket.mNext = this.mBuckets[n3];
                this.mBuckets[n3] = bucket;
                bucket = bucket2;
            }
            ++n2;
        }
    }

    public final void cleanUp() {
        Bucket bucket;
        while ((bucket = (Bucket)this.mQueue.poll()) != null) {
            int n = Math.abs(bucket.mHash % this.mBuckets.length);
            if (this.mBuckets[n] == bucket) {
                this.mBuckets[n] = bucket.mNext;
            } else {
                Bucket<E> bucket2 = this.mBuckets[n];
                while (bucket2.mNext != bucket) {
                    bucket2 = bucket2.mNext;
                }
                bucket2.mNext = bucket.mNext;
            }
            --this.mSize;
        }
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Iterator<E> iterator() {
        this.cleanUp();
        return new Iterator<E>(){
            private int mBucket = 0;
            private final int mKnown;
            private Bucket<E> mNextBucket;
            private E mNextVal;
            {
                this.mKnown = UnifyHash.this.mModCount;
                this.internalNext();
            }

            private void internalNext() {
                while (true) {
                    if (this.mNextBucket == null) {
                        if (this.mBucket == UnifyHash.this.mBuckets.length) {
                            return;
                        }
                        this.mNextBucket = UnifyHash.this.mBuckets[this.mBucket++];
                        continue;
                    }
                    this.mNextVal = this.mNextBucket.get();
                    if (this.mNextVal != null) {
                        return;
                    }
                    this.mNextBucket = this.mNextBucket.mNext;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mNextBucket != null;
            }

            @Override
            public E next() {
                if (this.mKnown != UnifyHash.this.mModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.mNextBucket == null) {
                    throw new NoSuchElementException();
                }
                Object e = this.mNextVal;
                this.mNextBucket = this.mNextBucket.mNext;
                this.internalNext();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<E> iterateHashCode(final int n) {
        this.cleanUp();
        return () -> new Iterator<E>(){
            private int mKnown;
            private boolean mRemoveOk;
            private Bucket<E> mRemoveBucket;
            private Bucket<E> mPrevBucket;
            private Bucket<E> mNextBucket;
            private E mNextVal;
            {
                this.mKnown = UnifyHash.this.mModCount;
                this.mRemoveOk = false;
                this.mRemoveBucket = null;
                this.mPrevBucket = null;
                this.mNextBucket = UnifyHash.this.mBuckets[Math.abs(n2 % UnifyHash.this.mBuckets.length)];
                this.internalNext();
            }

            private void internalNext() {
                while (this.mNextBucket != null) {
                    if (this.mNextBucket.mHash == n) {
                        this.mNextVal = this.mNextBucket.get();
                        if (this.mNextVal != null) {
                            return;
                        }
                    }
                    this.mPrevBucket = this.mNextBucket;
                    this.mNextBucket = this.mNextBucket.mNext;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mNextBucket != null;
            }

            @Override
            public E next() {
                if (this.mKnown != UnifyHash.this.mModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.mNextBucket == null) {
                    throw new NoSuchElementException();
                }
                Object e = this.mNextVal;
                this.mRemoveBucket = this.mPrevBucket;
                this.mRemoveOk = true;
                this.mPrevBucket = this.mNextBucket;
                this.mNextBucket = this.mNextBucket.mNext;
                this.internalNext();
                return e;
            }

            @Override
            public void remove() {
                if (this.mKnown != UnifyHash.this.mModCount) {
                    throw new ConcurrentModificationException();
                }
                if (!this.mRemoveOk) {
                    throw new IllegalStateException();
                }
                if (this.mRemoveBucket == null) {
                    UnifyHash.this.mBuckets[Math.abs((int)(n % UnifyHash.this.mBuckets.length))] = UnifyHash.this.mBuckets[Math.abs((int)(n % UnifyHash.this.mBuckets.length))].mNext;
                } else {
                    this.mRemoveBucket.mNext = this.mRemoveBucket.mNext.mNext;
                }
                this.mKnown = ++UnifyHash.this.mModCount;
                --UnifyHash.this.mSize;
            }
        };
    }

    public void put(int n, E e) {
        if (this.mSize++ > this.mThreshold) {
            this.grow();
        }
        ++this.mModCount;
        int n2 = Math.abs(n % this.mBuckets.length);
        Bucket<E> bucket = new Bucket<E>(e, this.mQueue);
        bucket.mHash = n;
        bucket.mNext = this.mBuckets[n2];
        this.mBuckets[n2] = bucket;
    }

    public boolean remove(int n, E e) {
        Iterator<E> iterator = this.iterateHashCode(n).iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != e) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public E unify(E e, int n, Comparator<E> comparator) {
        this.cleanUp();
        int n2 = Math.abs(n % this.mBuckets.length);
        Bucket<E> bucket = this.mBuckets[n2];
        while (bucket != null) {
            Object t;
            if (bucket.mHash == n && (t = bucket.get()) != null && comparator.compare(e, t) == 0) {
                return (E)t;
            }
            bucket = bucket.mNext;
        }
        this.put(n, e);
        return e;
    }

    public E unify(E e) {
        this.cleanUp();
        int n = e.hashCode();
        int n2 = Math.abs(n % this.mBuckets.length);
        Bucket<E> bucket = this.mBuckets[n2];
        while (bucket != null) {
            Object t;
            if (bucket.mHash == n && (t = bucket.get()) != null && e.equals(t)) {
                return (E)t;
            }
            bucket = bucket.mNext;
        }
        this.put(n, e);
        return e;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.mBuckets.length);
        Bucket<E>[] bucketArray = this.mBuckets;
        int n = this.mBuckets.length;
        int n2 = 0;
        while (n2 < n) {
            Bucket<E> bucket = bucketArray[n2];
            while (bucket != null) {
                Object t = bucket.get();
                if (t != null) {
                    objectOutputStream.writeInt(bucket.mHash);
                    objectOutputStream.writeObject(t);
                }
                bucket = bucket.mNext;
            }
            ++n2;
        }
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mQueue = new ReferenceQueue();
        this.mModCount = 0;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.mBuckets = new Bucket[n];
        while (true) {
            int n2 = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            if (object == null) break;
            this.put(n2, object);
        }
    }

    static class Bucket<E>
    extends WeakReference<E> {
        int mHash;
        Bucket<E> mNext;

        public Bucket(E e, ReferenceQueue<E> referenceQueue) {
            super(e, referenceQueue);
        }
    }
}

