/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SetConstraintManager<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final NestedMap2<Set<ELEM>, Set<ELEM>, SetConstraint<ELEM>> mLiteralsToNonLiteralsToSetConstraint = new NestedMap2();
    private final SetConstraint<ELEM> mInconsistentSetConstraint = new SetConstraint(true);
    private final IPartialComparator<SetConstraint<ELEM>> mSetConstraintComparator = new SetConstraintComparator(this);
    private final CcManager<ELEM> mCcManager;

    public SetConstraintManager(CcManager<ELEM> ccManager) {
        this.mCcManager = ccManager;
    }

    public SetConstraint<ELEM> buildSetConstraint(Set<ELEM> set, Set<ELEM> set2) {
        assert (set.stream().allMatch(ICongruenceClosureElement::isLiteral));
        assert (!set2.stream().anyMatch(ICongruenceClosureElement::isLiteral));
        if (set.isEmpty() && set2.isEmpty()) {
            return this.getInconsistentSetConstraint();
        }
        SetConstraint<ELEM> setConstraint = this.mLiteralsToNonLiteralsToSetConstraint.get(set, set2);
        if (setConstraint == null) {
            setConstraint = new SetConstraint<ELEM>(new HashSet<ELEM>(set), new HashSet<ELEM>(set2));
            this.mLiteralsToNonLiteralsToSetConstraint.put(set, set2, setConstraint);
        }
        return setConstraint;
    }

    private SetConstraint<ELEM> getInconsistentSetConstraint() {
        return this.mInconsistentSetConstraint;
    }

    public SetConstraint<ELEM> buildSetConstraint(Collection<ELEM> collection) {
        HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
        HashSet<ICongruenceClosureElement> hashSet2 = new HashSet<ICongruenceClosureElement>();
        for (ICongruenceClosureElement iCongruenceClosureElement : collection) {
            if (iCongruenceClosureElement.isLiteral()) {
                hashSet.add(iCongruenceClosureElement);
                continue;
            }
            hashSet2.add(iCongruenceClosureElement);
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> setConstraint, ELEM ELEM, ELEM ELEM2, ELEM ELEM3) {
        Set<ELEM> set = setConstraint.getElementSet();
        if (!set.contains(ELEM) && !set.contains(ELEM2)) {
            return setConstraint;
        }
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ELEM> hashSet2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        if (ELEM.isLiteral()) {
            hashSet.remove(ELEM);
        } else {
            hashSet2.remove(ELEM);
        }
        if (ELEM2.isLiteral()) {
            hashSet.remove(ELEM2);
        } else {
            hashSet2.remove(ELEM2);
        }
        if (ELEM3.isLiteral()) {
            hashSet.add(ELEM3);
        } else {
            hashSet2.add(ELEM3);
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> setConstraint, ELEM ELEM, ELEM ELEM2) {
        Set<ELEM> set = setConstraint.getElementSet();
        if (!set.contains(ELEM)) {
            return setConstraint;
        }
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ELEM> hashSet2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        if (ELEM.isLiteral()) {
            hashSet.remove(ELEM);
        } else {
            hashSet2.remove(ELEM);
        }
        if (ELEM2.isLiteral()) {
            hashSet.add(ELEM2);
        } else {
            hashSet2.add(ELEM2);
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> updateOnChangedRepresentative(SetConstraint<ELEM> setConstraint, CongruenceClosure<ELEM> congruenceClosure) {
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ICongruenceClosureElement> hashSet2 = new HashSet<ICongruenceClosureElement>();
        boolean bl = false;
        for (ICongruenceClosureElement iCongruenceClosureElement : setConstraint.getNonLiterals()) {
            ICongruenceClosureElement iCongruenceClosureElement2;
            bl |= iCongruenceClosureElement != (iCongruenceClosureElement2 = congruenceClosure.getRepresentativeElement(iCongruenceClosureElement));
            if (iCongruenceClosureElement2.isLiteral()) {
                hashSet.add(iCongruenceClosureElement2);
                continue;
            }
            hashSet2.add(iCongruenceClosureElement2);
        }
        if (!bl) {
            return setConstraint;
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> filterWithDisequality(SetConstraint<ELEM> setConstraint, ELEM ELEM) {
        if (!setConstraint.getLiterals().contains(ELEM) && !setConstraint.getNonLiterals().contains(ELEM)) {
            return setConstraint;
        }
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ELEM> hashSet2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        hashSet.remove(ELEM);
        hashSet2.remove(ELEM);
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> transformElements(SetConstraint<ELEM> setConstraint, Function<ELEM, ELEM> function) {
        HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
        HashSet<ICongruenceClosureElement> hashSet2 = new HashSet<ICongruenceClosureElement>();
        for (ICongruenceClosureElement iCongruenceClosureElement : setConstraint.getElementSet()) {
            ICongruenceClosureElement iCongruenceClosureElement2 = (ICongruenceClosureElement)function.apply(iCongruenceClosureElement);
            if (iCongruenceClosureElement2.isLiteral()) {
                hashSet.add(iCongruenceClosureElement2);
                continue;
            }
            hashSet2.add(iCongruenceClosureElement2);
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> filterWithDisequalities(SetConstraint<ELEM> setConstraint, ELEM ELEM, CongruenceClosure<ELEM> congruenceClosure) {
        Object object2;
        boolean bl = false;
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        for (Object object2 : setConstraint.getLiterals()) {
            if (congruenceClosure.getEqualityStatus(ELEM, object2) != EqualityStatus.NOT_EQUAL) continue;
            bl |= hashSet.remove(object2);
        }
        object2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        for (Object object3 : setConstraint.getNonLiterals()) {
            if (congruenceClosure.getEqualityStatus(ELEM, object3) != EqualityStatus.NOT_EQUAL) continue;
            bl |= object2.remove(object3);
        }
        if (!bl) {
            return setConstraint;
        }
        return this.buildSetConstraint((Set<ELEM>)hashSet, (Set<ELEM>)object2);
    }

    public boolean isStrongerThan(SetConstraint<ELEM> setConstraint, SetConstraint<ELEM> setConstraint2) {
        if (!setConstraint2.getLiterals().containsAll(setConstraint.getLiterals())) {
            return false;
        }
        return setConstraint2.getNonLiterals().containsAll(setConstraint.getNonLiterals());
    }

    public SetConstraint<ELEM> meet(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, Collection<SetConstraint<ELEM>> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<SetConstraint<ELEM>> iterator = collection.iterator();
        SetConstraint<ELEM> setConstraint = iterator.next();
        HashSet<Object> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ELEM> hashSet2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        while (iterator.hasNext()) {
            SetConstraint<ELEM> setConstraint2 = iterator.next();
            HashSet<ICongruenceClosureElement> hashSet3 = new HashSet<ICongruenceClosureElement>();
            for (ICongruenceClosureElement iCongruenceClosureElement : hashSet) {
                if (!setConstraint2.getLiterals().contains(iCongruenceClosureElement)) continue;
                hashSet3.add(iCongruenceClosureElement);
            }
            hashSet = hashSet3;
            hashSet2.addAll(setConstraint2.getNonLiterals());
        }
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public SetConstraint<ELEM> join(SetConstraint<ELEM> setConstraint, SetConstraint<ELEM> setConstraint2) {
        return this.buildSetConstraint(DataStructureUtils.union(setConstraint.getLiterals(), setConstraint2.getLiterals()), DataStructureUtils.union(setConstraint.getNonLiterals(), setConstraint2.getNonLiterals()));
    }

    public SetConstraint<ELEM> expandNonLiteral(SetConstraint<ELEM> setConstraint, ELEM ELEM, Set<ELEM> set) {
        assert (setConstraint.getNonLiterals().contains(ELEM));
        HashSet<ELEM> hashSet = new HashSet<ELEM>(setConstraint.getLiterals());
        HashSet<ELEM> hashSet2 = new HashSet<ELEM>(setConstraint.getNonLiterals());
        hashSet.addAll(set);
        hashSet2.remove(ELEM);
        return this.buildSetConstraint(hashSet, hashSet2);
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> set, ELEM ELEM, ELEM ELEM2) {
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : set) {
            hashSet.add(this.updateOnChangedRepresentative(setConstraint, ELEM, ELEM2));
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> set, ELEM ELEM, ELEM ELEM2, ELEM ELEM3) {
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        boolean bl = false;
        for (SetConstraint<ELEM> setConstraint : set) {
            SetConstraint<ELEM> setConstraint2 = this.updateOnChangedRepresentative(setConstraint, ELEM, ELEM2, ELEM3);
            bl |= setConstraint2 != setConstraint;
            hashSet.add(setConstraint2);
        }
        if (!bl) {
            return set;
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> transformElements(Set<SetConstraint<ELEM>> set, Function<ELEM, ELEM> function) {
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : set) {
            hashSet.add(this.transformElements(setConstraint, function));
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> meet(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, Set<SetConstraint<ELEM>> set, Set<SetConstraint<ELEM>> set2) {
        if (SetConstraintManager.isTautological(set)) {
            return set2;
        }
        if (SetConstraintManager.isTautological(set2)) {
            return set;
        }
        if (this.isInconsistent(set)) {
            return this.getInconsistentSetConstraintConjunction();
        }
        if (this.isInconsistent(set2)) {
            return this.getInconsistentSetConstraintConjunction();
        }
        Set<SetConstraint<ELEM>> set3 = DataStructureUtils.union(set, set2);
        return cCLiteralSetConstraints.getCongruenceClosure().getManager().normalizeSetConstraintConjunction(cCLiteralSetConstraints, set3);
    }

    public boolean meetIsInconsistent(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, Set<SetConstraint<ELEM>> set, Set<SetConstraint<ELEM>> set2) {
        SetConstraint<ELEM> setConstraint3;
        this.mCcManager.bmStart(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
        SetConstraint<ELEM> setConstraint2 = null;
        for (SetConstraint<ELEM> setConstraint3 : set) {
            if (!setConstraint3.hasOnlyLiterals()) continue;
            setConstraint2 = setConstraint3;
            break;
        }
        if (setConstraint2 == null) {
            this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
            return false;
        }
        setConstraint3 = null;
        for (SetConstraint<ELEM> setConstraint4 : set2) {
            if (!setConstraint4.hasOnlyLiterals()) continue;
            setConstraint3 = setConstraint4;
            break;
        }
        if (setConstraint3 == null) {
            this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
            return false;
        }
        boolean bl = !DataStructureUtils.haveNonEmptyIntersection(setConstraint2.getLiterals(), setConstraint3.getLiterals());
        this.mCcManager.bmEnd(CcManager.CcBmNames.MEET_IS_INCONSISTENT);
        return bl;
    }

    public boolean isStrongerThan(Set<SetConstraint<ELEM>> set, Set<SetConstraint<ELEM>> set2) {
        if (SetConstraintManager.isTautological(set)) {
            return true;
        }
        if (SetConstraintManager.isTautological(set2)) {
            return false;
        }
        if (this.isInconsistent(set)) {
            return true;
        }
        if (this.isInconsistent(set2)) {
            return false;
        }
        for (SetConstraint<ELEM> setConstraint : set2) {
            boolean bl = false;
            for (SetConstraint<ELEM> setConstraint2 : set) {
                if (this.isStrongerThan(setConstraint2, setConstraint)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public Set<SetConstraint<ELEM>> getInconsistentSetConstraintConjunction() {
        return Collections.singleton(SetConstraint.getInconsistentSetConstraint());
    }

    public Set<SetConstraint<ELEM>> getTautologicalSetConstraintConjunction() {
        return Collections.emptySet();
    }

    public Set<SetConstraint<ELEM>> join(Set<SetConstraint<ELEM>> set, Set<SetConstraint<ELEM>> set2) {
        if (SetConstraintManager.isTautological(set)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (SetConstraintManager.isTautological(set2)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (this.isInconsistent(set)) {
            return set2;
        }
        if (this.isInconsistent(set2)) {
            return set;
        }
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        for (SetConstraint<ELEM> setConstraint : set) {
            for (SetConstraint<ELEM> setConstraint2 : set2) {
                hashSet.add(this.join(setConstraint, setConstraint2));
            }
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> widen(Set<SetConstraint<ELEM>> set, Set<SetConstraint<ELEM>> set2) {
        if (SetConstraintManager.isTautological(set)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (SetConstraintManager.isTautological(set2)) {
            return this.getTautologicalSetConstraintConjunction();
        }
        if (this.isInconsistent(set)) {
            return set2;
        }
        if (this.isInconsistent(set2)) {
            return set;
        }
        return DataStructureUtils.intersection(set, set2);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(Set<SetConstraint<ELEM>> set) {
        if (set == null) {
            return true;
        }
        return set.isEmpty();
    }

    public boolean isInconsistent(Collection<SetConstraint<ELEM>> collection) {
        if (collection == null) {
            return false;
        }
        for (SetConstraint<ELEM> setConstraint : collection) {
            if (!setConstraint.isInconsistent()) continue;
            return true;
        }
        return false;
    }

    public Set<ELEM> getSingletonValues(Set<SetConstraint<ELEM>> set) {
        HashSet<ELEM> hashSet = new HashSet<ELEM>();
        for (SetConstraint<ELEM> setConstraint : set) {
            if (!setConstraint.isSingleton()) continue;
            hashSet.add(setConstraint.getSingletonValue());
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> filterWithDisequalities(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, Set<SetConstraint<ELEM>> set) {
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        boolean bl = false;
        for (SetConstraint<ELEM> setConstraint : set) {
            SetConstraint<ELEM> setConstraint2 = this.filterWithDisequalities(setConstraint, ELEM, congruenceClosure);
            bl |= setConstraint2 != setConstraint;
            hashSet.add(setConstraint2);
        }
        if (!bl) {
            return set;
        }
        return hashSet;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(SetConstraintConjunction<ELEM> setConstraintConjunction) {
        if (setConstraintConjunction == null) {
            return true;
        }
        return setConstraintConjunction.isTautological();
    }

    public Set<SetConstraint<ELEM>> filterWithDisequality(Set<SetConstraint<ELEM>> set, ELEM ELEM) {
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        boolean bl = false;
        for (SetConstraint<ELEM> setConstraint : set) {
            SetConstraint<ELEM> setConstraint2 = this.filterWithDisequality(setConstraint, ELEM);
            bl |= setConstraint2 != setConstraint;
            hashSet.add(setConstraint2);
        }
        if (!bl) {
            return set;
        }
        return hashSet;
    }

    public Set<SetConstraint<ELEM>> updateOnChangedRepresentative(Set<SetConstraint<ELEM>> set, CongruenceClosure<ELEM> congruenceClosure) {
        if (set == null) {
            return null;
        }
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>();
        boolean bl = false;
        for (SetConstraint<ELEM> setConstraint : set) {
            SetConstraint<ELEM> setConstraint2 = this.updateOnChangedRepresentative(setConstraint, congruenceClosure);
            bl |= setConstraint2 != setConstraint;
            hashSet.add(setConstraint2);
        }
        if (!bl) {
            return set;
        }
        return hashSet;
    }

    public IPartialComparator<SetConstraint<ELEM>> getSetConstraintComparator() {
        return this.mSetConstraintComparator;
    }

    public Set<ELEM> getLiteralSet(Set<SetConstraint<ELEM>> set) {
        assert (set.stream().filter(SetConstraint::hasOnlyLiterals).collect(Collectors.toList()).size() <= 1) : "not normalized?";
        for (SetConstraint<ELEM> setConstraint : set) {
            if (!setConstraint.hasOnlyLiterals()) continue;
            return setConstraint.getLiterals();
        }
        return null;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautologicalWrtElement(ELEM ELEM, Set<SetConstraint<ELEM>> set) {
        if (SetConstraintManager.isTautological(set)) {
            return true;
        }
        for (SetConstraint<ELEM> setConstraint : set) {
            if (setConstraint.containsElement(ELEM)) continue;
            return false;
        }
        return true;
    }
}

