/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DisjointSets<T> {
    private final Map<T, T> mRepresentative = new HashMap<T, T>();
    private final Map<T, Set<T>> mSubsets = new HashMap<T, Set<T>>();

    public DisjointSets(Set<T> set) {
        for (T t : set) {
            this.mRepresentative.put(t, t);
            HashSet<T> hashSet = new HashSet<T>();
            hashSet.add(t);
            this.mSubsets.put(t, hashSet);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Rep:");
        for (Map.Entry<T, T> entry : this.mRepresentative.entrySet()) {
            stringBuilder.append(" " + String.valueOf(entry.getKey()) + "in" + String.valueOf(entry.getValue()));
        }
        stringBuilder.append("\nPart:");
        for (Map.Entry<T, Object> entry : this.mSubsets.entrySet()) {
            stringBuilder.append(" " + String.valueOf(entry.getKey()) + " in " + String.valueOf(this.getPartition(entry.getKey())));
        }
        return stringBuilder.toString();
    }

    public int size() {
        int n = 0;
        for (Set<T> set : this.mSubsets.values()) {
            if (set.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    private T changeRepresentative(T t, T t2) {
        T t3 = this.mRepresentative.get(t);
        if (t3 == t2) {
            return t2;
        }
        this.mRepresentative.put(t, t2);
        if (this.mSubsets.containsKey(t3)) {
            this.mSubsets.get(t3).remove(t);
        }
        this.mSubsets.get(t2).add(t);
        return t2;
    }

    public void union(T t, T t2) {
        this.changeRepresentative(this.find(t2), this.find(t));
    }

    public T find(T t) {
        T t2 = this.mRepresentative.get(t);
        if (t2 == t) {
            return t2;
        }
        return this.changeRepresentative(t, this.find(t2));
    }

    public boolean equiv(T t, T t2) {
        return this.find(t) == this.find(t2);
    }

    public Set<T> getPartition(T t) {
        return this.mSubsets.get(this.find(t));
    }

    private void findAll(T t) {
        for (T t2 : this.mSubsets.get(t)) {
            if (t2 == t) continue;
            this.findAll(t2);
        }
        this.find(t);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DisjointSets disjointSets = (DisjointSets)object;
        if (!disjointSets.mRepresentative.keySet().equals(this.mRepresentative.keySet())) {
            return false;
        }
        for (T t : disjointSets.mRepresentative.keySet()) {
            if (disjointSets.mSubsets.get(disjointSets.mRepresentative.get(t)).equals(this.mSubsets.get(this.mRepresentative.get(t)))) continue;
            return false;
        }
        return true;
    }

    public Iterator<Set<T>> getParitionsIterator() {
        final Iterator<T> iterator = this.mSubsets.keySet().iterator();
        return new Iterator<Set<T>>(){
            T mCur = null;

            public boolean keepMoving() {
                if (!iterator.hasNext()) {
                    this.mCur = null;
                    return false;
                }
                do {
                    this.mCur = iterator.next();
                    DisjointSets.this.findAll(this.mCur);
                } while (iterator.hasNext() && DisjointSets.this.mSubsets.get(this.mCur).isEmpty());
                if (DisjointSets.this.mSubsets.get(this.mCur).isEmpty()) {
                    this.mCur = null;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                if (this.mCur == null) {
                    return this.keepMoving();
                }
                return true;
            }

            @Override
            public Set<T> next() {
                if (this.hasNext()) {
                    Set set = DisjointSets.this.mSubsets.get(this.mCur);
                    this.keepMoving();
                    return set;
                }
                throw new NoSuchElementException("No more elments to iterate.");
            }
        };
    }
}

