/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class IdentifierExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(IdentifierExpression.class);
    String identifier;

    public IdentifierExpression(String string) {
        this.identifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IdentifierExpression: " + String.valueOf(this);
    }

    public IdentifierExpression(ACSLType aCSLType, String string) {
        super(aCSLType);
        this.identifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IdentifierExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IdentifierExpression").append('[');
        stringBuffer.append(this.identifier);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.type != null) {
            this.type.accept(aCSLVisitor);
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.type != aCSLType) {
            return new IdentifierExpression(aCSLType, this.identifier);
        }
        return this;
    }
}

