/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.BuildStoreInfos;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityAllowStores;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ComputeStoreInfosAndArrayGroups<LOC extends IcfgLocation> {
    private final Map<IProgramVarOrConst, ArrayGroup> mArrayToArrayGroup = new HashMap<IProgramVarOrConst, ArrayGroup>();
    private final NestedMap2<EdgeInfo, Term, ArrayGroup> mEdgeToTermToArrayGroup = new NestedMap2();
    private int mStoreInfoCounter;
    private final MemlocArrayManager mLocArrayManager;
    private final ManagedScript mMgdScript;
    private final NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> mEdgeToPositionToLocUpdateInfo = new NestedMap2();
    private final HashRelation<EdgeInfo, TermVariable> mEdgeToUnconstrainedVariables = new HashRelation();
    private final Map<HeapSepProgramConst, StoreInfo> mLocLitToStoreInfo = new HashMap<HeapSepProgramConst, StoreInfo>();
    private boolean mFrozen;
    private final Map<Term, HeapSepProgramConst> mLocLitTermToLocLitPvoc = new HashMap<Term, HeapSepProgramConst>();
    private final NestedMap2<EdgeInfo, SubtreePosition, StoreInfo> mEdgeToPositionToStoreInfo = new NestedMap2();
    private final List<IProgramVarOrConst> mHeapArrays;

    public ComputeStoreInfosAndArrayGroups(IIcfg<LOC> iIcfg, List<IProgramVarOrConst> list, ManagedScript managedScript) {
        this.mMgdScript = managedScript;
        this.mLocArrayManager = new MemlocArrayManager(managedScript, this);
        this.mHeapArrays = list;
        this.run(iIcfg, list);
    }

    private void run(IIcfg<LOC> iIcfg, List<IProgramVarOrConst> list) throws AssertionError {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        UnionFind unionFind = new UnionFind();
        list.forEach(arg_0 -> ((UnionFind)unionFind).findAndConstructEquivalenceClassIfNeeded(arg_0));
        Map<EdgeInfo, UnionFind<Term>> map = this.computeEdgeLevelArrayGroups(iIcfg, (UnionFind<IProgramVarOrConst>)unionFind);
        this.computeProgramLevelArrayGroups(list, (UnionFind<IProgramVarOrConst>)unionFind, map);
        IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator(iIcfg);
        while (icfgEdgeIterator.hasNext()) {
            IcfgEdge icfgEdge = icfgEdgeIterator.next();
            EdgeInfo edgeInfo = new EdgeInfo(icfgEdge);
            Map map2 = this.mEdgeToTermToArrayGroup.get((Object)edgeInfo);
            BuildStoreInfos buildStoreInfos = new BuildStoreInfos(edgeInfo, map2, this.mMgdScript, this.mLocArrayManager, this.mStoreInfoCounter, this.collectDefinitelyUnconstrainedVariables(edgeInfo));
            buildStoreInfos.buildStoreInfos();
            for (Map.Entry<SubtreePosition, ArrayEqualityLocUpdateInfo> entry : buildStoreInfos.getLocArrayUpdateInfos().entrySet()) {
                this.mEdgeToPositionToLocUpdateInfo.put((Object)edgeInfo, (Object)entry.getKey(), (Object)entry.getValue());
            }
            this.mLocLitToStoreInfo.putAll(buildStoreInfos.getLocLitToStoreInfo());
            buildStoreInfos.getLocLitToStoreInfo().keySet().forEach(heapSepProgramConst -> {
                HeapSepProgramConst heapSepProgramConst2 = this.mLocLitTermToLocLitPvoc.put(heapSepProgramConst.getTerm(), (HeapSepProgramConst)heapSepProgramConst);
            });
            buildStoreInfos.getLocLitToStoreInfo().values().forEach(storeInfo -> {
                Object object = this.mEdgeToPositionToStoreInfo.put((Object)edgeInfo, (Object)storeInfo.getPosition(), storeInfo);
            });
            this.mStoreInfoCounter = buildStoreInfos.getStoreInfoCounter();
        }
        this.mFrozen = true;
    }

    private Set<IProgramVar> collectDefinitelyUnconstrainedVariables(EdgeInfo edgeInfo) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar : edgeInfo.getInVars().keySet()) {
            if (!this.isDefinitelyUnconstrained(iProgramVar, edgeInfo)) continue;
            hashSet.add(iProgramVar);
        }
        return hashSet;
    }

    private boolean isDefinitelyUnconstrained(IProgramVar iProgramVar, EdgeInfo edgeInfo) {
        IcfgEdge icfgEdge = edgeInfo.getEdge();
        do {
            List list;
            if ((list = ((IcfgLocation)icfgEdge.getSource()).getIncomingEdges()).size() != 1) {
                return false;
            }
            icfgEdge = (IcfgEdge)list.get(0);
            if (!icfgEdge.getTransformula().getAssignedVars().contains(iProgramVar)) continue;
            return !icfgEdge.getTransformula().getInVars().containsKey(iProgramVar) && SmtUtils.isTrueLiteral((Term)icfgEdge.getTransformula().getFormula());
        } while (!icfgEdge.getTransformula().getOutVars().containsKey(iProgramVar));
        return false;
    }

    private void computeProgramLevelArrayGroups(List<IProgramVarOrConst> list, UnionFind<IProgramVarOrConst> unionFind, Map<EdgeInfo, UnionFind<Term>> map) throws AssertionError {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashSet<ArrayGroup> object5 = new HashSet<ArrayGroup>();
        for (Object object : unionFind.getAllEquivalenceClasses()) {
            object5.add(new ArrayGroup((Set<IProgramVarOrConst>)object));
        }
        for (Object object : object5) {
            if (DataStructureUtils.intersection(new HashSet<IProgramVarOrConst>(list), ((ArrayGroup)object).getArrays()).isEmpty()) continue;
            for (IProgramVarOrConst iProgramVarOrConst2 : ((ArrayGroup)object).getArrays()) {
                this.mArrayToArrayGroup.put(iProgramVarOrConst2, (ArrayGroup)object);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            EdgeInfo edgeInfo = (EdgeInfo)entry.getKey();
            for (Set set : ((UnionFind)entry.getValue()).getAllEquivalenceClasses()) {
                Optional<IProgramVarOrConst> optional = set.stream().map(term -> edgeInfo.getProgramVarOrConstForTerm((Term)term)).filter(iProgramVarOrConst -> iProgramVarOrConst != null).findAny();
                if (!optional.isPresent()) {
                    throw new AssertionError((Object)"see comment");
                }
                ArrayGroup arrayGroup = this.mArrayToArrayGroup.get(optional.get());
                for (Term term2 : set) {
                    this.mEdgeToTermToArrayGroup.put((Object)edgeInfo, (Object)term2, (Object)arrayGroup);
                }
            }
        }
    }

    private Map<EdgeInfo, UnionFind<Term>> computeEdgeLevelArrayGroups(IIcfg<LOC> iIcfg, UnionFind<IProgramVarOrConst> unionFind) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashMap<EdgeInfo, UnionFind<Term>> hashMap = new HashMap<EdgeInfo, UnionFind<Term>>();
        IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator(iIcfg);
        while (icfgEdgeIterator.hasNext()) {
            Object object;
            IcfgEdge icfgEdge = icfgEdgeIterator.next();
            UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
            EdgeInfo edgeInfo = new EdgeInfo(icfgEdge);
            UnionFind unionFind2 = new UnionFind();
            Set set2 = SubTermFinder.find((Term)unmodifiableTransFormula.getFormula(), SmtUtils::isBasicArrayTerm, (boolean)false);
            set2.forEach(arg_0 -> ((UnionFind)unionFind2).findAndConstructEquivalenceClassIfNeeded(arg_0));
            List<ArrayEqualityAllowStores> list = ArrayEqualityAllowStores.extractArrayEqualityAllowStores(unmodifiableTransFormula.getFormula());
            for (ArrayEqualityAllowStores arrayEqualityAllowStores : list) {
                object = SmtUtils.getBasicArrayTerm((Term)arrayEqualityAllowStores.getLhsArray());
                Term term2 = SmtUtils.getBasicArrayTerm((Term)arrayEqualityAllowStores.getRhsArray());
                unionFind2.union(object, (Object)term2);
            }
            hashMap.put(edgeInfo, (UnionFind<Term>)unionFind2);
            for (Set set : unionFind2.getAllEquivalenceClasses()) {
                object = set.stream().map(term -> TransFormulaUtils.getProgramVarOrConstForTerm((TransFormula)unmodifiableTransFormula, (Term)term)).filter(iProgramVarOrConst -> iProgramVarOrConst != null).collect(Collectors.toSet());
                object.forEach(arg_0 -> unionFind.findAndConstructEquivalenceClassIfNeeded(arg_0));
                unionFind.union((Collection)object);
            }
            Set<TermVariable> set3 = this.computeUnconstrainedVariables(unmodifiableTransFormula, list);
            this.mEdgeToUnconstrainedVariables.addAllPairs((Object)edgeInfo, set3);
        }
        return hashMap;
    }

    private Set<TermVariable> computeUnconstrainedVariables(UnmodifiableTransFormula unmodifiableTransFormula, List<ArrayEqualityAllowStores> list) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()));
        boolean bl = true;
        while (bl) {
            bl = false;
            for (ArrayEqualityAllowStores arrayEqualityAllowStores : list) {
                boolean bl2;
                Term term = SmtUtils.getBasicArrayTerm((Term)arrayEqualityAllowStores.getLhsArray());
                Term term2 = SmtUtils.getBasicArrayTerm((Term)arrayEqualityAllowStores.getRhsArray());
                TermVariable termVariable = term instanceof TermVariable ? (TermVariable)term : null;
                TermVariable termVariable2 = term2 instanceof TermVariable ? (TermVariable)term2 : null;
                boolean bl3 = term != arrayEqualityAllowStores.getLhsArray();
                boolean bl4 = term2 != arrayEqualityAllowStores.getRhsArray();
                boolean bl5 = bl2 = !bl3 && !bl4;
                if (termVariable == null && termVariable2 != null) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable2);
                }
                if (termVariable2 == null && termVariable != null) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable);
                }
                if (unmodifiableTransFormula.getInVars().containsValue(termVariable)) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable);
                }
                if (unmodifiableTransFormula.getInVars().containsValue(termVariable2)) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable2);
                }
                if (bl2 && hashSet.contains(termVariable) && termVariable2 != null) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable2);
                }
                if (bl2 && hashSet.contains(termVariable2) && termVariable != null) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable);
                }
                if (bl3 && termVariable2 != null && hashSet2.contains(termVariable2)) {
                    bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable2);
                }
                if (!bl4 || termVariable == null || !hashSet2.contains(termVariable)) continue;
                bl |= this.markAsConstrainedIfNecessary(hashSet, hashSet2, termVariable);
            }
        }
        return hashSet2;
    }

    private boolean markAsConstrainedIfNecessary(Set<TermVariable> set, Set<TermVariable> set2, TermVariable termVariable) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        if (set.contains(termVariable)) {
            assert (!set2.contains(termVariable));
            return false;
        }
        set2.remove(termVariable);
        set.add(termVariable);
        return true;
    }

    public MemlocArrayManager getLocArrayManager() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mLocArrayManager;
    }

    public NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> getEdgeToPositionToLocUpdateInfo() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mEdgeToPositionToLocUpdateInfo;
    }

    public Map<HeapSepProgramConst, StoreInfo> getLocLitToStoreInfo() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableMap(this.mLocLitToStoreInfo);
    }

    public Set<HeapSepProgramConst> getLocLiterals() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableSet(this.mLocLitToStoreInfo.keySet());
    }

    public HashRelation<EdgeInfo, TermVariable> getEdgeToUnconstrainedVariables() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mEdgeToUnconstrainedVariables;
    }

    public StoreInfo getStoreInfoForLocLitTerm(Term term) {
        HeapSepProgramConst heapSepProgramConst = this.getLocLitPvocForLocLitTerm(term);
        if (this.mLocArrayManager.isInitLocPvoc(heapSepProgramConst)) {
            return this.mLocArrayManager.getNoStoreInfo(heapSepProgramConst);
        }
        assert (heapSepProgramConst != null);
        return this.mLocLitToStoreInfo.get(heapSepProgramConst);
    }

    private HeapSepProgramConst getLocLitPvocForLocLitTerm(Term term) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        HeapSepProgramConst heapSepProgramConst = this.mLocArrayManager.getInitLocLitPvocForLocLitTerm(term);
        if (heapSepProgramConst != null) {
            return heapSepProgramConst;
        }
        return this.mLocLitTermToLocLitPvoc.get(term);
    }

    public ArrayGroup getArrayGroupForTermInEdge(EdgeInfo edgeInfo, Term term) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup arrayGroup = (ArrayGroup)this.mEdgeToTermToArrayGroup.get((Object)edgeInfo, (Object)term);
        if (arrayGroup == null) {
            throw new AssertionError();
        }
        return arrayGroup;
    }

    public StoreInfo getStoreInfoForStoreTermAtPositionInEdge(EdgeInfo edgeInfo, SubtreePosition subtreePosition) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return (StoreInfo)this.mEdgeToPositionToStoreInfo.get((Object)edgeInfo, (Object)subtreePosition);
    }

    public boolean isArrayTermSubjectToSeparation(EdgeInfo edgeInfo, Term term) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup arrayGroup = (ArrayGroup)this.mEdgeToTermToArrayGroup.get((Object)edgeInfo, (Object)term);
        return this.mArrayToArrayGroup.containsValue(arrayGroup);
    }

    public ArrayGroup getArrayGroupForArrayPvoc(IProgramVarOrConst iProgramVarOrConst) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup arrayGroup = this.mArrayToArrayGroup.get(iProgramVarOrConst);
        assert (arrayGroup != null);
        return arrayGroup;
    }

    public Collection<ArrayGroup> getArrayGroups() {
        return Collections.unmodifiableCollection(this.mArrayToArrayGroup.values());
    }

    public List<StoreInfo> getStoreInfosForDimensionAndArrayGroup(int n, ArrayGroup arrayGroup) {
        return this.mLocLitToStoreInfo.values().stream().filter(storeInfo -> storeInfo.getDimension() == n && storeInfo.getArrayGroup().equals(arrayGroup)).collect(Collectors.toList());
    }
}

