/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli.options;

import de.uni_freiburg.informatik.ultimate.cli.options.CommandLineOptions;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.preferencejson.PreferenceUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class OptionBuilder {
    private static final int MIN_WIDTH = 80;
    private final ICore<RunDefinition> mCore;
    private final Map<String, Triple<String, String, UltimatePreferenceItem<?>>> mCliName2UltimatePreferences;
    private final Map<String, UltimatePreferenceItem.IUltimatePreferenceItemValidator<?>> mCliName2Validator;
    private final Options mUltimateOptions;
    private final Options mRcpOptions;
    private final Options mCliControllerOptions;

    public OptionBuilder(ICore<RunDefinition> iCore, boolean bl, boolean bl2) {
        this.mCore = iCore;
        this.mCliName2UltimatePreferences = new HashMap();
        this.mCliName2Validator = new HashMap();
        this.mUltimateOptions = this.createUltimateOptions();
        this.mRcpOptions = OptionBuilder.createRcpOptions();
        this.mCliControllerOptions = OptionBuilder.createCliOptions(bl, bl2);
    }

    public Triple<String, String, UltimatePreferenceItem<?>> getUltimatePreference(String string) {
        return this.mCliName2UltimatePreferences.get(string);
    }

    public UltimatePreferenceItem.IUltimatePreferenceItemValidator<Object> getValidator(String string) {
        return this.mCliName2Validator.get(string);
    }

    public Options getParserOptions(Predicate<String> predicate) {
        Options options = new Options();
        this.mCliControllerOptions.getOptions().stream().forEach(arg_0 -> ((Options)options).addOption(arg_0));
        this.mUltimateOptions.getOptions().stream().filter(option -> this.filterUltimateOption((Option)option, predicate)).forEach(arg_0 -> ((Options)options).addOption(arg_0));
        this.mRcpOptions.getOptions().stream().forEach(arg_0 -> ((Options)options).addOption(arg_0));
        return options;
    }

    public Options getHelpOptions(Predicate<String> predicate) {
        Options options = new Options();
        this.mCliControllerOptions.getOptions().stream().forEach(arg_0 -> ((Options)options).addOption(arg_0));
        this.mUltimateOptions.getOptions().stream().filter(option -> this.filterUltimateOption((Option)option, predicate)).forEach(arg_0 -> ((Options)options).addOption(arg_0));
        return options;
    }

    public static int calculateMaxWidth(Options options) {
        if (options == null) {
            return 0;
        }
        Collection collection = options.getOptions();
        if (collection.isEmpty()) {
            return 0;
        }
        Optional<Integer> optional = collection.stream().map(option -> option.getLongOpt().length()).max(Integer::compare);
        if (!optional.isPresent()) {
            throw new AssertionError((Object)"Java8 does not work");
        }
        int n = optional.get() + 8;
        return n > 80 ? n : 80;
    }

    public Options filterExperimentalOptions(Options options) {
        Options options2 = new Options();
        ((Stream)options.getOptions().stream().sequential()).filter(option -> !this.isExperimentalUltimateOption((Option)option)).forEach(arg_0 -> ((Options)options2).addOption(arg_0));
        return options2;
    }

    private boolean filterUltimateOption(Option option, Predicate<String> predicate) {
        Triple<String, String, UltimatePreferenceItem<?>> triple = this.mCliName2UltimatePreferences.get(option.getLongOpt());
        if (triple == null) {
            return false;
        }
        return predicate.test((String)triple.getFirst());
    }

    private boolean isExperimentalUltimateOption(Option option) {
        Triple<String, String, UltimatePreferenceItem<?>> triple = this.mCliName2UltimatePreferences.get(option.getLongOpt());
        if (triple == null) {
            return false;
        }
        return ((UltimatePreferenceItem)triple.getThird()).getLevel() == UltimatePreferenceItem.Level.EXPERIMENTAL;
    }

    private static Options createCliOptions(boolean bl, boolean bl2) {
        Options options = new Options();
        for (Option option : CommandLineOptions.createCliControllerOptions(bl, bl2)) {
            options.addOption(option);
        }
        return options;
    }

    private Options createUltimateOptions() {
        Options options = new Options();
        IUltimatePlugin[] iUltimatePluginArray = this.mCore.getRegisteredUltimatePlugins();
        int n = iUltimatePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUltimatePlugin iUltimatePlugin = iUltimatePluginArray[n2];
            IPreferenceInitializer iPreferenceInitializer = iUltimatePlugin.getPreferences();
            if (iPreferenceInitializer != null) {
                this.addPreferences(options, iPreferenceInitializer);
            }
            ++n2;
        }
        return options;
    }

    private static Options createRcpOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"product").hasArg().type(String.class).build());
        options.addOption(Option.builder((String)"application").hasArg().type(String.class).build());
        options.addOption(Option.builder().longOpt("console").type(Boolean.class).build());
        options.addOption(Option.builder().longOpt("launcher.suppressErrors").type(Boolean.class).build());
        options.addOption(Option.builder((String)"ultimatedata").type(String.class).build());
        return options;
    }

    private void addPreferences(Options options, IPreferenceInitializer iPreferenceInitializer) {
        String string = iPreferenceInitializer.getPluginID();
        for (UltimatePreferenceItem ultimatePreferenceItem : BaseUltimatePreferenceItem.constructFlattenedList((BaseUltimatePreferenceItem[])iPreferenceInitializer.getPreferenceItems())) {
            Option option = this.createOption(ultimatePreferenceItem, string);
            if (option == null) continue;
            options.addOption(option);
            this.addValidator(option.getLongOpt(), ultimatePreferenceItem);
        }
    }

    private void addValidator(String string, UltimatePreferenceItem<?> ultimatePreferenceItem) {
        UltimatePreferenceItem.IUltimatePreferenceItemValidator iUltimatePreferenceItemValidator = ultimatePreferenceItem.getPreferenceValidator();
        if (iUltimatePreferenceItemValidator == null) {
            return;
        }
        this.mCliName2Validator.put(string, iUltimatePreferenceItemValidator);
    }

    private Option createOption(UltimatePreferenceItem<?> ultimatePreferenceItem, String string) {
        switch (ultimatePreferenceItem.getType()) {
            case Label: 
            case SubItemContainer: {
                return null;
            }
        }
        Option.Builder builder = this.createBuilder(ultimatePreferenceItem, string);
        switch (ultimatePreferenceItem.getType()) {
            case Boolean: {
                return builder.hasArg(true).numberOfArgs(1).type(Boolean.class).build();
            }
            case Integer: {
                return builder.hasArg(true).numberOfArgs(1).type(Integer.class).build();
            }
            case Double: {
                return builder.hasArg(true).numberOfArgs(1).type(Double.class).build();
            }
            case Directory: 
            case String: 
            case Combo: 
            case Radio: 
            case Path: 
            case MultilineString: 
            case File: 
            case Color: 
            case KeyValue: {
                return builder.hasArg(true).numberOfArgs(1).type(String.class).build();
            }
        }
        throw new IllegalArgumentException("PreferenceItem type " + String.valueOf(ultimatePreferenceItem.getType()) + " is not supported yet");
    }

    private Option.Builder createBuilder(UltimatePreferenceItem<?> ultimatePreferenceItem, String string) {
        String string2 = this.convertLabelToLongName(string, ultimatePreferenceItem);
        String string3 = OptionBuilder.createDescription(ultimatePreferenceItem);
        Option.Builder builder = string3.length() > 0 ? Option.builder().longOpt(string2).desc(string3) : Option.builder().longOpt(string2);
        return builder;
    }

    private static String createDescription(UltimatePreferenceItem<?> ultimatePreferenceItem) {
        StringBuilder stringBuilder = new StringBuilder();
        if (ultimatePreferenceItem.getDescription() != null) {
            stringBuilder.append(ultimatePreferenceItem.getDescription());
            stringBuilder.append(" ");
        }
        switch (ultimatePreferenceItem.getType()) {
            case Boolean: {
                stringBuilder.append("This option can either be true or false. ");
                break;
            }
            case Color: {
                stringBuilder.append("<arg> is a string representing a color. ");
                stringBuilder.append("The string has to be of the form \"red,green,blue\", where 0 <= red,green,blue <= 255. ");
                break;
            }
            case Directory: {
                stringBuilder.append("<arg> is a string representing an absolute path to a single directory on the local file system. ");
                break;
            }
            case File: {
                stringBuilder.append("<arg> is a string representing an absolute path on the local file system to a single file. ");
                break;
            }
            case Path: {
                stringBuilder.append("<arg> is a string representing one or multiple paths to a file or directory on the system. ");
                stringBuilder.append("If multiple paths are specified by the user, they are separated by a semicolon. ");
                break;
            }
            case Integer: {
                stringBuilder.append("<arg> is a string representing an integer. ");
                break;
            }
            case KeyValue: {
                stringBuilder.append("<arg> is a string of the form <key>=<value> representing a key-value pair. ");
                stringBuilder.append("You can specify multiple key-value pairs by repeating this option. ");
                stringBuilder.append("All key-value pairs are collected in a map where every key has to be unique. ");
                stringBuilder.append("Keys and values may not contain the symbols \"=\" and \";\". ");
                break;
            }
            case String: 
            case MultilineString: {
                stringBuilder.append("<arg> is a single line of text. ");
                break;
            }
            case Combo: 
            case Radio: {
                stringBuilder.append("<arg> is a pre-defined value. ");
                break;
            }
            case Label: 
            case SubItemContainer: {
                return stringBuilder.toString();
            }
        }
        Object[] objectArray = ultimatePreferenceItem.getChoices();
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append("Valid choices for <arg> are ");
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                stringBuilder.append("\"");
                stringBuilder.append(object.toString());
                stringBuilder.append("\", ");
                ++n2;
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append(". ");
        }
        OptionBuilder.addDefaultValue(ultimatePreferenceItem, stringBuilder);
        return stringBuilder.toString();
    }

    private static void addDefaultValue(UltimatePreferenceItem<?> ultimatePreferenceItem, StringBuilder stringBuilder) {
        stringBuilder.append("The default value is " + String.valueOf(ultimatePreferenceItem.getDefaultValue()) + ". ");
    }

    private String convertLabelToLongName(String string, UltimatePreferenceItem<?> ultimatePreferenceItem) {
        String string2 = PreferenceUtil.convertLabelToLongName((String)string, ultimatePreferenceItem);
        this.mCliName2UltimatePreferences.put(string2, new Triple((Object)string, (Object)ultimatePreferenceItem.getLabel(), ultimatePreferenceItem));
        return string2;
    }
}

