/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser;

import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AutomataScriptParserRun;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AutomataScriptParser
implements ISource {
    protected String[] mFileTypes = new String[]{"ats"};
    protected List<String> mFileNames = new ArrayList<String>();
    private ILogger mLogger;
    private IUltimateServiceProvider mServices;

    private IElement parseFile(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        String string = file.getName();
        String string2 = file.getAbsolutePath();
        return new AutomataScriptParserRun(this.mServices, this.mLogger, fileReader, string, string2).getResult();
    }

    public String[] getFileTypes() {
        return this.mFileTypes;
    }

    public ModelType getOutputDefinition() {
        try {
            return new ModelType(this.getPluginID(), ModelType.Type.AST, this.mFileNames);
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)exception.getMessage());
            return null;
        }
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        if (fileArray.length != 1) {
            throw new UnsupportedOperationException("AutomataScriptParser can not parse more than one file.");
        }
        File file = fileArray[0];
        this.mFileNames.add(fileArray[0].getName());
        this.mLogger.info((Object)("Parsing '" + file.getAbsolutePath() + "'"));
        return this.parseFile(file);
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    private boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getPluginName() {
        return "AutomataScriptParser";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public void init() {
    }

    public IPreferenceInitializer getPreferences() {
        return null;
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void finish() {
    }
}

