/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;

public class DTReverseTrigger
extends ReverseTrigger {
    final CCTerm mArg;
    int mArgPos;
    final FunctionSymbol mFunctionSymbol;
    final Clausifier mClausifier;
    final DataTypeTheory mDTTheory;

    public DTReverseTrigger(DataTypeTheory dataTypeTheory, Clausifier clausifier, FunctionSymbol functionSymbol, CCTerm cCTerm) {
        this.mDTTheory = dataTypeTheory;
        this.mClausifier = clausifier;
        this.mFunctionSymbol = functionSymbol;
        this.mArg = cCTerm;
    }

    @Override
    public CCTerm getArgument() {
        return this.mArg;
    }

    @Override
    public int getArgPosition() {
        return 0;
    }

    @Override
    public FunctionSymbol getFunctionSymbol() {
        return this.mFunctionSymbol;
    }

    @Override
    public void activate(CCAppTerm cCAppTerm, boolean bl) {
        this.mClausifier.getLogger().debug("DTReverseTrigger: %s on %s", cCAppTerm, this.mArg);
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mArg.mFlatTerm;
        SymmetricPair[] symmetricPairArray = cCAppTerm.getArg() != this.mArg ? new SymmetricPair[]{new SymmetricPair<CCTerm>(cCAppTerm.getArg(), this.mArg)} : new SymmetricPair[]{};
        if (this.mFunctionSymbol.getName() == "is") {
            FunctionSymbol functionSymbol = ((CCBaseTerm)cCAppTerm.mFunc).getFunctionSymbol();
            ApplicationTerm applicationTerm2 = functionSymbol.getIndices()[0].equals(applicationTerm.getFunction().getName()) ? this.mClausifier.getTheory().mTrue : this.mClausifier.getTheory().mFalse;
            SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCAppTerm, this.mClausifier.getCCTerm((Term)applicationTerm2));
            DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_TESTER, symmetricPair, symmetricPairArray, this.mArg);
            this.mDTTheory.addPendingLemma(dataTypeLemma);
            if (bl) {
                this.mDTTheory.addRecheckOnBacktrack(cCAppTerm);
            }
        } else {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            DataType dataType = (DataType)functionSymbol.getReturnSort().getSortSymbol();
            DataType.Constructor constructor = dataType.getConstructor(applicationTerm.getFunction().getName());
            int n = 0;
            while (n < constructor.getSelectors().length) {
                if (this.mFunctionSymbol.getName() == constructor.getSelectors()[n]) {
                    SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCAppTerm, this.mClausifier.getCCTerm(applicationTerm.getParameters()[n]));
                    DataTypeLemma dataTypeLemma = new DataTypeLemma(CCAnnotation.RuleKind.DT_PROJECT, symmetricPair, symmetricPairArray, this.mArg);
                    this.mDTTheory.addPendingLemma(dataTypeLemma);
                    if (bl) {
                        this.mDTTheory.addRecheckOnBacktrack(cCAppTerm);
                    }
                    return;
                }
                ++n;
            }
            throw new AssertionError((Object)"selector function not part of constructor");
        }
    }
}

