/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import java.util.Map;

public class FloydHoareMapping<S>
implements IFloydHoareAnnotation<S> {
    private final PrePostConditionSpecification<S> mSpecification;
    private final Map<S, IPredicate> mAnnotation;
    private final IPredicate mDefaultPredicate;

    public FloydHoareMapping(PrePostConditionSpecification<S> prePostConditionSpecification, Map<S, IPredicate> map) {
        this(prePostConditionSpecification, map, null);
    }

    public FloydHoareMapping(PrePostConditionSpecification<S> prePostConditionSpecification, Map<S, IPredicate> map, IPredicate iPredicate) {
        this.mAnnotation = map;
        this.mDefaultPredicate = iPredicate;
        this.mSpecification = prePostConditionSpecification;
    }

    @Override
    public PrePostConditionSpecification<S> getSpecification() {
        return this.mSpecification;
    }

    @Override
    public IPredicate getAnnotation(S s) {
        return this.mAnnotation.getOrDefault(s, this.mDefaultPredicate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FloydHoareMapping\n----------------------------------------\n");
        int n = this.mAnnotation.keySet().stream().map(Object::toString).mapToInt(String::length).max().orElse(0);
        if (this.mDefaultPredicate != null) {
            n = Integer.max(n, "all other states".length());
        }
        String string = "%" + n + "s  ::  %s\n";
        for (Map.Entry<S, IPredicate> entry : this.mAnnotation.entrySet()) {
            stringBuilder.append(String.format(string, entry.getKey(), entry.getValue()));
        }
        if (this.mDefaultPredicate != null) {
            stringBuilder.append('\n');
            stringBuilder.append(String.format(string, "all other states", this.mDefaultPredicate));
        }
        stringBuilder.append("----------------------------------------");
        return stringBuilder.toString();
    }
}

