/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DangerInvariantResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.dangerinvariants.DangerInvariantUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProof;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.ProofAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareMapping;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareUtils;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IcfgFloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.invariantsynthesis.preferences.InvariantSynthesisPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InvariantSynthesisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AggressiveTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.CFGInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ConjunctsPriorizedTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ConservativeTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DangerInvariantGuesser;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DefaultTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DisjunctsWithBoundTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ExponentialConjunctsTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.InvariantSynthesisStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.KindOfInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.MediumTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InvariantSynthesisStarter<L extends IIcfgTransition<?>> {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IElement mRootOfNewModel;
    private AbstractCegarLoop.Result mOverallResult;
    private IElement mArtifact;

    public InvariantSynthesisStarter(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg) {
        Collection collection2;
        FloydHoareMapping floydHoareMapping;
        IncrementalPlicationChecker.Validity validity;
        IPredicate iPredicate;
        IPredicate iPredicate2;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        SmtUtils.SimplificationTechnique simplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, managedScript, iIcfg.getCfgSmtToolkit().getSymbolTable());
        PredicateUnifier predicateUnifier = new PredicateUnifier(this.mLogger, this.mServices, managedScript, (BasicPredicateFactory)predicateFactory, iIcfg.getCfgSmtToolkit().getSymbolTable(), simplificationTechnique, new IPredicate[0]);
        InvariantSynthesisSettings invariantSynthesisSettings = this.constructSettings(iIcfg.getIdentifier());
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        KindOfInvariant kindOfInvariant = (KindOfInvariant)iPreferenceProvider.getEnum("Kind of invariant", KindOfInvariant.class);
        if (kindOfInvariant == KindOfInvariant.DANGER) {
            iPredicate2 = predicateUnifier.getFalsePredicate();
            iPredicate = predicateUnifier.getTruePredicate();
        } else {
            assert (kindOfInvariant == KindOfInvariant.SAFETY);
            iPredicate2 = predicateUnifier.getTruePredicate();
            iPredicate = predicateUnifier.getFalsePredicate();
        }
        boolean bl = iPreferenceProvider.getBoolean("Guess danger invariant");
        if (kindOfInvariant == KindOfInvariant.DANGER && bl) {
            DangerInvariantGuesser dangerInvariantGuesser = new DangerInvariantGuesser(iIcfg, iUltimateServiceProvider, iPredicate2, predicateFactory, (IPredicateUnifier)predicateUnifier, iIcfg.getCfgSmtToolkit());
            this.mLogger.info((Object)"Constructed danger invariant candidate");
            if (dangerInvariantGuesser.isDangerInvariant()) {
                this.mLogger.info((Object)"Candidate is a valid danger invariant");
                this.mOverallResult = AbstractCegarLoop.Result.UNSAFE;
                this.reportDangerResults(dangerInvariantGuesser.getCandidateInvariant(), IcfgUtils.getErrorLocations(iIcfg), this.mServices.getBacktranslationService());
            } else {
                this.mLogger.info((Object)"Candidate is not a danger invariant");
                this.mOverallResult = AbstractCegarLoop.Result.UNKNOWN;
                this.reportResult((IResult)new GenericResult(Activator.PLUGIN_ID, "Did not find a danger invariant", "Did not find a danger invariant", IResultWithSeverity.Severity.WARNING));
            }
            this.mRootOfNewModel = null;
            return;
        }
        CFGInvariantsGenerator cFGInvariantsGenerator = new CFGInvariantsGenerator(iIcfg, iUltimateServiceProvider, iPredicate2, iPredicate, predicateFactory, (IPredicateUnifier)predicateUnifier, invariantSynthesisSettings, iIcfg.getCfgSmtToolkit(), kindOfInvariant);
        Map map = cFGInvariantsGenerator.synthesizeInvariants();
        InvariantSynthesisStatisticsGenerator invariantSynthesisStatisticsGenerator = cFGInvariantsGenerator.getInvariantSynthesisStatistics();
        if (map != null) {
            if (kindOfInvariant == KindOfInvariant.DANGER) {
                validity = DangerInvariantUtils.checkDangerInvariant((Map)map, iIcfg, (ManagedScript)managedScript, (IUltimateServiceProvider)this.mServices, (BasicPredicateFactory)predicateFactory, (ILogger)this.mLogger);
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    this.mOverallResult = AbstractCegarLoop.Result.UNSAFE;
                } else {
                    this.mLogger.warn((Object)("Danger invariant could not be confirmed to be correct: " + String.valueOf(validity)));
                    this.mLogger.debug((Object)map);
                    this.mOverallResult = AbstractCegarLoop.Result.UNKNOWN;
                }
                floydHoareMapping = null;
            } else {
                assert (kindOfInvariant == KindOfInvariant.SAFETY);
                validity = iIcfg.getInitialNodes().stream().collect(Collectors.toMap(Function.identity(), icfgLocation -> iPredicate2));
                floydHoareMapping = new FloydHoareMapping(PrePostConditionSpecification.forIcfg(iIcfg, validity, (IPredicate)iPredicate), map);
                FloydHoareUtils.writeHoareAnnotationToLogger(iIcfg, (IFloydHoareAnnotation)floydHoareMapping, (ILogger)this.mLogger, (boolean)true);
                ProofAnnotation.addProof(iIcfg, (IProof)floydHoareMapping);
                this.mOverallResult = AbstractCegarLoop.Result.SAFE;
            }
        } else {
            this.mOverallResult = AbstractCegarLoop.Result.UNKNOWN;
            floydHoareMapping = null;
        }
        validity = iIcfg.getProcedureErrorNodes();
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        for (Collection collection2 : validity.values()) {
            arrayList.addAll(collection2);
        }
        if (this.mOverallResult == AbstractCegarLoop.Result.SAFE) {
            collection2 = AllSpecificationsHoldResult.createAllSpecificationsHoldResult((String)"InvariantSynthesis", (int)arrayList.size());
            this.reportResult((IResult)collection2);
        }
        this.mLogger.debug((Object)("Overall result: " + String.valueOf(this.mOverallResult)));
        this.mLogger.debug((Object)("Continue processing: " + this.mServices.getProgressMonitorService().continueProcessing()));
        if (this.mOverallResult == AbstractCegarLoop.Result.SAFE) {
            assert (floydHoareMapping != null);
            assert (new IcfgFloydHoareValidityCheck(iUltimateServiceProvider, iIcfg, (IFloydHoareAnnotation)floydHoareMapping, true).getResult()) : "incorrect Hoare annotation";
            collection2 = this.mServices.getBacktranslationService();
            FloydHoareUtils.createInvariantResults((String)"InvariantSynthesis", iIcfg, (IFloydHoareAnnotation)floydHoareMapping, (IBacktranslationService)collection2, this::reportResult);
            FloydHoareUtils.createProcedureContractResults((IUltimateServiceProvider)this.mServices, (String)"InvariantSynthesis", iIcfg, (IFloydHoareAnnotation)floydHoareMapping, (IBacktranslationService)collection2, this::reportResult);
        }
        collection2 = new StatisticsData();
        collection2.aggregateBenchmarkData((IStatisticsDataProvider)invariantSynthesisStatisticsGenerator);
        StatisticsResult statisticsResult = new StatisticsResult(Activator.PLUGIN_ID, "InvariantSynthesisStatistics", (ICsvProviderProvider)collection2);
        this.reportResult((IResult)statisticsResult);
        switch (this.mOverallResult) {
            case SAFE: {
                this.reportPositiveResults(arrayList);
                break;
            }
            case UNSAFE: {
                this.reportDangerResults(map, IcfgUtils.getErrorLocations(iIcfg), this.mServices.getBacktranslationService());
                break;
            }
            case TIMEOUT: {
                throw new AssertionError();
            }
            case UNKNOWN: {
                this.mLogger.warn((Object)"Unable to infer correctness proof.");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown overall result " + String.valueOf(this.mOverallResult));
            }
        }
        this.mRootOfNewModel = this.mArtifact;
    }

    private InvariantSynthesisSettings constructSettings(String string) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        boolean bl = iPreferenceProvider.getBoolean("Nonlinear constraints");
        boolean bl2 = iPreferenceProvider.getBoolean("Use external solver (z3)");
        long l = iPreferenceProvider.getInt("Solver timeout (sec)") * 1000;
        String string2 = bl ? "Nonlinear_" + string : "Linear_" + string;
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseFakeIncrementalScript(false).setSmtInterpolTimeout(l).setDumpSmtScriptToFile(false, "dump/", string2, false);
        if (bl2) {
            long l2 = l;
            solverSettings = solverSettings.setUseExternalSolver(SolverBuilder.ExternalSolver.Z3, l2);
        }
        boolean bl3 = iPreferenceProvider.getBoolean("Use unsat cores");
        boolean bl4 = iPreferenceProvider.getBoolean("Large-Block-Encoding");
        boolean bl5 = iPreferenceProvider.getBoolean("Use abstract interpretation");
        Object object = null;
        InvariantSynthesisPreferenceInitializer.IncreasingStrategy increasingStrategy = (InvariantSynthesisPreferenceInitializer.IncreasingStrategy)iPreferenceProvider.getEnum("Increasing strategy", (Enum)InvariantSynthesisPreferenceInitializer.DEF_INCR_STRATEGY, InvariantSynthesisPreferenceInitializer.IncreasingStrategy.class);
        object = increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.Conservative ? new ConservativeTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : (increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.Medium ? new MediumTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : (increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.IncrOnlyConjunctsAfterMaxDisjuncts ? new DisjunctsWithBoundTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : (increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.Aggressive ? new AggressiveTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : (increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.ExponentialConjuncts ? new ExponentialConjunctsTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : (increasingStrategy == InvariantSynthesisPreferenceInitializer.IncreasingStrategy.ConjunctsPriorized ? new ConjunctsPriorizedTemplateIncreasingDimensionsStrategy(1, 3, 1, 1) : new DefaultTemplateIncreasingDimensionsStrategy(1, 3, 1, 1))))));
        return new InvariantSynthesisSettings(solverSettings, (AbstractTemplateIncreasingDimensionsStrategy)object, bl, bl3, bl5, false, bl4);
    }

    private void reportDangerResults(Map<IcfgLocation, IPredicate> map, Set<IcfgLocation> set, IBacktranslationService iBacktranslationService) {
        HashMap<IcfgLocation, Term> hashMap = new HashMap<IcfgLocation, Term>();
        for (Map.Entry<IcfgLocation, IPredicate> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getFormula());
        }
        this.reportResult((IResult)new DangerInvariantResult("InvariantSynthesis", hashMap, set, iBacktranslationService));
    }

    private void reportPositiveResults(Collection<IcfgLocation> collection) {
        for (IcfgLocation icfgLocation : collection) {
            PositiveResult positiveResult = new PositiveResult("InvariantSynthesis", (IElement)icfgLocation, this.mServices.getBacktranslationService());
            this.reportResult((IResult)positiveResult);
        }
    }

    private void reportUnproveableResult(IcfgProgramExecution<L> icfgProgramExecution, List<UnprovabilityReason> list) {
        IcfgLocation icfgLocation = InvariantSynthesisStarter.getErrorPP(icfgProgramExecution);
        this.reportResult((IResult)new UnprovableResult("InvariantSynthesis", (IElement)icfgLocation, this.mServices.getBacktranslationService(), icfgProgramExecution, list));
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }

    public IElement getRootOfNewModel() {
        return this.mRootOfNewModel;
    }

    public static <L extends IIcfgTransition<?>> IcfgLocation getErrorPP(IcfgProgramExecution<L> icfgProgramExecution) {
        int n = icfgProgramExecution.getLength() - 1;
        IIcfgTransition iIcfgTransition = (IIcfgTransition)icfgProgramExecution.getTraceElement(n).getTraceElement();
        return iIcfgTransition.getTarget();
    }
}

