/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnsupportedSyntaxResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.DefaultOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Statements2TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Boogie2SMT {
    private final BoogieDeclarations mBoogieDeclarations;
    private final ManagedScript mScript;
    private final TypeSortTranslator mTypeSortTranslator;
    private final IOperationTranslator mOperationTranslator;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Expression2Term mExpression2Term;
    private final Term2Expression mTerm2Expression;
    private final Statements2TransFormula mStatements2TransFormula;
    private final SmtFunctionsAndAxioms mSmtFunctionsAndAxioms;
    private final IUltimateServiceProvider mServices;

    public Boogie2SMT(ManagedScript managedScript, BoogieDeclarations boogieDeclarations, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mBoogieDeclarations = boogieDeclarations;
        this.mScript = managedScript;
        Script script = this.mScript.getScript();
        this.mTypeSortTranslator = new TypeSortTranslator(boogieDeclarations.getTypeDeclarations(), script, this.mServices);
        this.mBoogie2SmtSymbolTable = new Boogie2SmtSymbolTable(boogieDeclarations, this.mScript, this.mTypeSortTranslator);
        this.mOperationTranslator = new DefaultOperationTranslator(this.mBoogie2SmtSymbolTable, script);
        this.mExpression2Term = new Expression2Term(this.mServices, script, this.mTypeSortTranslator, this.mBoogie2SmtSymbolTable, this.mOperationTranslator, this.mScript);
        List<Term> list = Boogie2SMT.declareAxioms(boogieDeclarations, script, this.mExpression2Term, this.mBoogie2SmtSymbolTable);
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns(SmtUtils.and((Script)script, list), this.mScript, this.mBoogie2SmtSymbolTable);
        assert (termVarsFuns.getVars().isEmpty()) : "axioms must not have variables";
        if (!(script instanceof HistoryRecordingScript)) {
            throw new AssertionError((Object)"need HistoryRecordingScript");
        }
        this.mSmtFunctionsAndAxioms = new SmtFunctionsAndAxioms(termVarsFuns.getClosedFormula(), termVarsFuns.getFuns(), this.mScript);
        this.mStatements2TransFormula = new Statements2TransFormula(this, this.mServices, this.mExpression2Term, bl);
        this.mTerm2Expression = new Term2Expression(this.mTypeSortTranslator, this.mBoogie2SmtSymbolTable, this.mScript);
    }

    private static List<Term> declareAxioms(BoogieDeclarations boogieDeclarations, Script script, Expression2Term expression2Term, Boogie2SmtSymbolTable boogie2SmtSymbolTable) {
        ArrayList<Term> arrayList = new ArrayList<Term>(boogieDeclarations.getAxioms().size());
        script.echo(new QuotedObject("Start declaration of axioms"));
        for (Axiom axiom : boogieDeclarations.getAxioms()) {
            ConstOnlyIdentifierTranslator constOnlyIdentifierTranslator = new ConstOnlyIdentifierTranslator(boogie2SmtSymbolTable);
            Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = new Expression2Term.IIdentifierTranslator[]{constOnlyIdentifierTranslator};
            Term term = expression2Term.translateToTerm(iIdentifierTranslatorArray, axiom.getFormula()).term();
            script.assertTerm(term);
            Term term2 = term;
            arrayList.add(term2);
        }
        script.echo(new QuotedObject("Finished declaration of axioms"));
        return arrayList;
    }

    public Script getScript() {
        return this.mScript.getScript();
    }

    public ManagedScript getManagedScript() {
        return this.mScript;
    }

    public Term2Expression getTerm2Expression() {
        return this.mTerm2Expression;
    }

    public Expression2Term getExpression2Term() {
        return this.mExpression2Term;
    }

    static String quoteId(String string) {
        return string;
    }

    public Boogie2SmtSymbolTable getBoogie2SmtSymbolTable() {
        return this.mBoogie2SmtSymbolTable;
    }

    public Statements2TransFormula getStatements2TransFormula() {
        return this.mStatements2TransFormula;
    }

    public BoogieDeclarations getBoogieDeclarations() {
        return this.mBoogieDeclarations;
    }

    public TypeSortTranslator getTypeSortTranslator() {
        return this.mTypeSortTranslator;
    }

    public SmtFunctionsAndAxioms getSmtFunctionsAndAxioms() {
        return this.mSmtFunctionsAndAxioms;
    }

    public ConstOnlyIdentifierTranslator createConstOnlyIdentifierTranslator() {
        return new ConstOnlyIdentifierTranslator(this.mBoogie2SmtSymbolTable);
    }

    public static void reportUnsupportedSyntax(BoogieASTNode boogieASTNode, String string, IUltimateServiceProvider iUltimateServiceProvider) {
        UnsupportedSyntaxResult unsupportedSyntaxResult = new UnsupportedSyntaxResult((IElement)boogieASTNode, ModelCheckerUtils.PLUGIN_ID, iUltimateServiceProvider.getBacktranslationService(), string);
        iUltimateServiceProvider.getResultService().reportResult(ModelCheckerUtils.PLUGIN_ID, (IResult)unsupportedSyntaxResult);
        iUltimateServiceProvider.getProgressMonitorService().cancelToolchain();
    }

    public static final class ConstOnlyIdentifierTranslator
    implements Expression2Term.IIdentifierTranslator {
        private final Set<ProgramConst> mNonTheoryConsts = new HashSet<ProgramConst>();
        private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;

        public ConstOnlyIdentifierTranslator(Boogie2SmtSymbolTable boogie2SmtSymbolTable) {
            this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        }

        @Override
        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            if (declarationInformation.getStorageClass() != DeclarationInformation.StorageClass.GLOBAL) {
                throw new AssertionError();
            }
            ProgramConst programConst = this.mBoogie2SmtSymbolTable.getBoogieConst(string);
            if (!programConst.belongsToSmtTheory()) {
                this.mNonTheoryConsts.add(programConst);
            }
            return programConst.getDefaultConstant();
        }

        public Set<ProgramConst> getNonTheoryConsts() {
            return this.mNonTheoryConsts;
        }
    }

    public class LocalVarAndGlobalVarTranslator
    implements Expression2Term.IIdentifierTranslator {
        @Override
        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            IProgramVar iProgramVar = Boogie2SMT.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, bl);
            if (iProgramVar == null) {
                return null;
            }
            return iProgramVar.getTermVariable();
        }
    }
}

