/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.Set;

public class ModifiableGlobalsTable {
    private final HashRelation<String, IProgramNonOldVar> mProc2Globals = new HashRelation();

    public ModifiableGlobalsTable(HashRelation<String, IProgramNonOldVar> hashRelation) {
        this.mProc2Globals.addAll(hashRelation);
    }

    public Set<IProgramNonOldVar> getModifiedBoogieVars(String string) {
        return Collections.unmodifiableSet(this.mProc2Globals.getImage((Object)string));
    }

    public boolean isModifiable(IProgramOldVar iProgramOldVar, String string) {
        IProgramNonOldVar iProgramNonOldVar = iProgramOldVar.getNonOldVar();
        return this.mProc2Globals.containsPair((Object)string, (Object)iProgramNonOldVar);
    }

    public boolean isModifiable(IProgramNonOldVar iProgramNonOldVar, String string) {
        return this.mProc2Globals.containsPair((Object)string, (Object)iProgramNonOldVar);
    }

    public boolean containsNonModifiableOldVars(IPredicate iPredicate, String string) {
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            boolean bl;
            if (!(iProgramVar instanceof IProgramOldVar) || (bl = this.isModifiable((IProgramOldVar)iProgramVar, string))) continue;
            return true;
        }
        return false;
    }

    public static Term constructConstantOldVarEquality(IProgramNonOldVar iProgramNonOldVar, boolean bl, Script script) {
        IProgramOldVar iProgramOldVar = iProgramNonOldVar.getOldVar();
        ApplicationTerm applicationTerm = bl ? iProgramNonOldVar.getPrimedConstant() : iProgramNonOldVar.getDefaultConstant();
        ApplicationTerm applicationTerm2 = bl ? iProgramOldVar.getPrimedConstant() : iProgramOldVar.getDefaultConstant();
        return SmtUtils.binaryEquality((Script)script, (Term)applicationTerm2, (Term)applicationTerm);
    }

    public HashRelation<String, IProgramNonOldVar> getProcToGlobals() {
        return new HashRelation(this.mProc2Globals);
    }
}

