/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IterableIntersection;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap4;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CachingHoareTripleChecker
implements IHoareTripleChecker {
    protected static final boolean UNKNOWN_IF_SOME_EXTENDED_CHECK_IS_UNKNOWN = false;
    private static final String UNKNOWN_CASE = "unknown case";
    private static final String CASE_MUST_NOT_OCCUR = "case must not occur";
    protected final ILogger mLogger;
    protected final IHoareTripleChecker mComputingHoareTripleChecker;
    protected final IPredicateUnifier mPredicateUnifier;
    private final InCaReCounter mResultFromSolver = new InCaReCounter();
    private final InCaReCounter mResultFromCache = new InCaReCounter();
    private final InCaReCounter mResultFromExtendedCacheCheck = new InCaReCounter();
    private final HoareTripleCheckerCache mCache;

    public CachingHoareTripleChecker(IUltimateServiceProvider iUltimateServiceProvider, IHoareTripleChecker iHoareTripleChecker, IPredicateUnifier iPredicateUnifier) {
        this(iUltimateServiceProvider, iHoareTripleChecker, iPredicateUnifier, new HoareTripleCheckerCache());
    }

    public CachingHoareTripleChecker(IUltimateServiceProvider iUltimateServiceProvider, IHoareTripleChecker iHoareTripleChecker, IPredicateUnifier iPredicateUnifier, HoareTripleCheckerCache hoareTripleCheckerCache) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mComputingHoareTripleChecker = Objects.requireNonNull(iHoareTripleChecker);
        this.mPredicateUnifier = Objects.requireNonNull(iPredicateUnifier);
        this.mCache = Objects.requireNonNull(hoareTripleCheckerCache);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        IncrementalPlicationChecker.Validity validity = this.mCache.getInternal(iPredicate, iInternalAction, iPredicate2);
        if (validity == null) {
            validity = this.extendedBinaryCacheCheck(iPredicate, iInternalAction, iPredicate2, this.mCache.getInternalCache());
            if (validity == null) {
                validity = this.mComputingHoareTripleChecker.checkInternal(iPredicate, iInternalAction, iPredicate2);
                this.mResultFromSolver.incIn();
            } else {
                this.mResultFromExtendedCacheCheck.incIn();
            }
            this.mCache.putInternal(iPredicate, iInternalAction, iPredicate2, validity);
        } else {
            this.mResultFromCache.incIn();
        }
        return validity;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        IncrementalPlicationChecker.Validity validity = this.mCache.getCall(iPredicate, iCallAction, iPredicate2);
        if (validity == null) {
            validity = this.extendedBinaryCacheCheck(iPredicate, iCallAction, iPredicate2, this.mCache.getCallCache());
            if (validity == null) {
                validity = this.mComputingHoareTripleChecker.checkCall(iPredicate, iCallAction, iPredicate2);
                this.mResultFromSolver.incCa();
            } else {
                this.mResultFromExtendedCacheCheck.incCa();
            }
            this.mCache.putCall(iPredicate, iCallAction, iPredicate2, validity);
        } else {
            this.mResultFromCache.incCa();
        }
        return validity;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        IncrementalPlicationChecker.Validity validity = this.mCache.getReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        if (validity == null) {
            validity = this.extendedReturnCacheCheck(iPredicate, iPredicate2, iReturnAction, iPredicate3, this.mCache.getReturnCache());
            if (validity == null) {
                validity = this.mComputingHoareTripleChecker.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
                this.mResultFromSolver.incRe();
            } else {
                this.mResultFromExtendedCacheCheck.incRe();
            }
            this.mCache.putReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3, validity);
        } else {
            this.mResultFromCache.incRe();
        }
        return validity;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mComputingHoareTripleChecker.getStatistics();
    }

    public IHoareTripleChecker getProtectedHoareTripleChecker() {
        return this.mComputingHoareTripleChecker;
    }

    public void releaseLock() {
        this.mComputingHoareTripleChecker.releaseLock();
    }

    public String toString() {
        return this.mComputingHoareTripleChecker.toString();
    }

    public HoareTripleCheckerCache getCache() {
        return this.mCache;
    }

    private IncrementalPlicationChecker.Validity extendedBinaryCacheCheck(IPredicate iPredicate, IAction iAction, IPredicate iPredicate2, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> nestedMap3) {
        IncrementalPlicationChecker.Validity validity;
        IterableIntersection iterableIntersection;
        Map map;
        NestedMap2 nestedMap2 = nestedMap3.get((Object)iAction);
        if (nestedMap2 == null) {
            return null;
        }
        boolean bl = false;
        Set<IPredicate> set = this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate);
        Set<IPredicate> set2 = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate2);
        IterableIntersection iterableIntersection2 = new IterableIntersection(nestedMap2.keySet(), set);
        for (IPredicate iPredicate3 : iterableIntersection2) {
            map = nestedMap2.get((Object)iPredicate3);
            iterableIntersection = new IterableIntersection(map.keySet(), set2);
            for (IPredicate iPredicate4 : iterableIntersection) {
                validity = CachingHoareTripleChecker.evaluateResultStrongerThanPreAndWeakerThanSucc((IncrementalPlicationChecker.Validity)map.get(iPredicate4));
                if (validity == null) continue;
                switch (validity) {
                    case INVALID: {
                        return IncrementalPlicationChecker.Validity.INVALID;
                    }
                    case UNKNOWN: {
                        bl = true;
                        break;
                    }
                    case VALID: 
                    case NOT_CHECKED: {
                        throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                    }
                    default: {
                        throw new AssertionError((Object)UNKNOWN_CASE);
                    }
                }
            }
        }
        set = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate);
        set2 = this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate2);
        iterableIntersection2 = new IterableIntersection(nestedMap2.keySet(), set);
        for (IPredicate iPredicate3 : iterableIntersection2) {
            map = nestedMap2.get((Object)iPredicate3);
            iterableIntersection = new IterableIntersection(map.keySet(), set2);
            for (IPredicate iPredicate4 : iterableIntersection) {
                validity = CachingHoareTripleChecker.evaluateResultWeakerThanPreAndStrongerThanSucc((IncrementalPlicationChecker.Validity)map.get(iPredicate4));
                if (validity == null) continue;
                switch (validity) {
                    case VALID: {
                        return IncrementalPlicationChecker.Validity.VALID;
                    }
                    case UNKNOWN: {
                        bl = true;
                        break;
                    }
                    case INVALID: 
                    case NOT_CHECKED: {
                        throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                    }
                    default: {
                        throw new AssertionError((Object)UNKNOWN_CASE);
                    }
                }
            }
        }
        return null;
    }

    protected IncrementalPlicationChecker.Validity extendedReturnCacheCheck(IPredicate iPredicate, IPredicate iPredicate2, IAction iAction, IPredicate iPredicate3, NestedMap4<IAction, IPredicate, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> nestedMap4) {
        IncrementalPlicationChecker.Validity validity;
        IterableIntersection iterableIntersection;
        Map map;
        IterableIntersection iterableIntersection2;
        NestedMap2 nestedMap2;
        NestedMap3 nestedMap3 = nestedMap4.get((Object)iAction);
        if (nestedMap3 == null) {
            return null;
        }
        boolean bl = false;
        Set<IPredicate> set = this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate2);
        Set<IPredicate> set2 = this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate);
        Set<IPredicate> set3 = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate3);
        IterableIntersection iterableIntersection3 = new IterableIntersection(nestedMap3.keySet(), set);
        for (IPredicate iPredicate4 : iterableIntersection3) {
            nestedMap2 = nestedMap3.get((Object)iPredicate4);
            iterableIntersection2 = new IterableIntersection(nestedMap2.keySet(), set2);
            for (IPredicate iPredicate5 : iterableIntersection2) {
                map = nestedMap2.get((Object)iPredicate5);
                iterableIntersection = new IterableIntersection(map.keySet(), set3);
                for (IPredicate iPredicate6 : iterableIntersection) {
                    validity = CachingHoareTripleChecker.evaluateResultStrongerThanPreAndWeakerThanSucc((IncrementalPlicationChecker.Validity)map.get(iPredicate6));
                    if (validity == null) continue;
                    switch (validity) {
                        case INVALID: {
                            return IncrementalPlicationChecker.Validity.INVALID;
                        }
                        case UNKNOWN: {
                            bl = true;
                            break;
                        }
                        case VALID: 
                        case NOT_CHECKED: {
                            throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                        }
                        default: {
                            throw new AssertionError((Object)UNKNOWN_CASE);
                        }
                    }
                }
            }
        }
        set = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate2);
        set2 = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate);
        set3 = this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates(iPredicate3);
        iterableIntersection3 = new IterableIntersection(nestedMap3.keySet(), set);
        for (IPredicate iPredicate4 : iterableIntersection3) {
            nestedMap2 = nestedMap3.get((Object)iPredicate4);
            iterableIntersection2 = new IterableIntersection(nestedMap2.keySet(), set2);
            for (IPredicate iPredicate5 : iterableIntersection2) {
                map = nestedMap2.get((Object)iPredicate5);
                iterableIntersection = new IterableIntersection(map.keySet(), set3);
                for (IPredicate iPredicate6 : iterableIntersection) {
                    validity = CachingHoareTripleChecker.evaluateResultWeakerThanPreAndStrongerThanSucc((IncrementalPlicationChecker.Validity)map.get(iPredicate6));
                    if (validity == null) continue;
                    switch (validity) {
                        case VALID: {
                            return IncrementalPlicationChecker.Validity.VALID;
                        }
                        case UNKNOWN: {
                            bl = true;
                            break;
                        }
                        case INVALID: 
                        case NOT_CHECKED: {
                            throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                        }
                        default: {
                            throw new AssertionError((Object)UNKNOWN_CASE);
                        }
                    }
                }
            }
        }
        return null;
    }

    private static IncrementalPlicationChecker.Validity evaluateResultWeakerThanPreAndStrongerThanSucc(IncrementalPlicationChecker.Validity validity) {
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.VALID -> validity;
            case IncrementalPlicationChecker.Validity.UNKNOWN -> validity;
            case IncrementalPlicationChecker.Validity.INVALID, IncrementalPlicationChecker.Validity.NOT_CHECKED -> null;
            default -> throw new MatchException(null, null);
        };
    }

    private static IncrementalPlicationChecker.Validity evaluateResultStrongerThanPreAndWeakerThanSucc(IncrementalPlicationChecker.Validity validity) {
        return switch (validity) {
            case IncrementalPlicationChecker.Validity.VALID, IncrementalPlicationChecker.Validity.NOT_CHECKED -> null;
            case IncrementalPlicationChecker.Validity.UNKNOWN -> validity;
            case IncrementalPlicationChecker.Validity.INVALID -> validity;
            default -> throw new MatchException(null, null);
        };
    }
}

