/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SmtParserUtils {
    private SmtParserUtils() {
    }

    public static Term parseWithVariables(String string, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        return SmtParserUtils.parseWithVariables(string, iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
    }

    public static Term parseWithVariables(String string, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        Set<TermVariable> set = Stream.concat(iIcfgSymbolTable.getGlobals().stream(), iIcfgSymbolTable.getGlobals().stream().map(IProgramNonOldVar::getOldVar)).map(IProgramVar::getTermVariable).collect(Collectors.toSet());
        return SmtParserUtils.parseWithVariables(string, iUltimateServiceProvider, managedScript, set);
    }

    public static Term parseWithVariables(String string, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Set<TermVariable> set) {
        if (set.isEmpty()) {
            return SmtParserUtils.parse(string, iUltimateServiceProvider, managedScript);
        }
        String string2 = set.stream().map(termVariable -> String.format("(|%1$s| %2$s)", termVariable.getName(), termVariable.getSort())).collect(Collectors.joining(" "));
        String string3 = "(forall (" + string2 + ") " + string + ")";
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)TermParseUtils.parseTerm((Script)managedScript.getScript(), (String)string3);
        return SmtParserUtils.normalize(quantifiedFormula.getSubformula(), iUltimateServiceProvider, managedScript);
    }

    public static Term parse(String string, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        Term term = TermParseUtils.parseTerm((Script)managedScript.getScript(), (String)string);
        return SmtParserUtils.normalize(term, iUltimateServiceProvider, managedScript);
    }

    private static Term normalize(Term term, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        Term term2 = new FormulaUnLet().transform(term);
        Term term3 = SmtSortUtils.isBoolSort((Sort)term2.getSort()) ? new IteRemover(managedScript).transform(term2) : term2;
        return new CommuhashNormalForm(iUltimateServiceProvider, managedScript.getScript()).transform(term3);
    }
}

