/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import java.util.List;
import java.util.Set;

public class IndexAnalysisResult
extends EqualityAnalysisResult {
    private final Set<Doubleton<Term>> mIgnoredDoubletons;

    public IndexAnalysisResult(Set<Doubleton<Term>> set, Set<Doubleton<Term>> set2, Set<Doubleton<Term>> set3, Set<Doubleton<Term>> set4) {
        super(set, set2, set3);
        this.mIgnoredDoubletons = set4;
    }

    public EqualityStatus isEqual(List<Term> list, List<Term> list2) {
        assert (list.size() == list2.size());
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) != list2.get(n)) {
                if (this.isDistinctDoubleton(list.get(n), list2.get(n))) {
                    return EqualityStatus.NOT_EQUAL;
                }
                if (this.isUnknownDoubleton(list.get(n), list2.get(n))) {
                    bl = true;
                } else if (this.isIgnoredDoubleton(list.get(n), list2.get(n))) {
                    bl = true;
                } else assert (this.isEqualDoubleton(list.get(n), list2.get(n)));
            }
            ++n;
        }
        if (bl) {
            return EqualityStatus.UNKNOWN;
        }
        return EqualityStatus.EQUAL;
    }

    public boolean isEqualDoubleton(Term term, Term term2) {
        return this.getEqualDoubletons().contains(new Doubleton((Object)term, (Object)term2));
    }

    public boolean isDistinctDoubleton(Term term, Term term2) {
        return this.getDistinctDoubletons().contains(new Doubleton((Object)term, (Object)term2));
    }

    public boolean isUnknownDoubleton(Term term, Term term2) {
        return this.getUnknownDoubletons().contains(new Doubleton((Object)term, (Object)term2));
    }

    public boolean isIgnoredDoubleton(Term term, Term term2) {
        return this.mIgnoredDoubletons.contains(new Doubleton((Object)term, (Object)term2));
    }
}

