/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.DebugPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.UnknownState;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;

public class SmtFreePredicateFactory {
    protected int mSerialNumberCounter = 1;
    protected final Term mDontCareTerm = new AuxiliaryTerm("don't care");
    protected final Term mEmptyStackTerm = new AuxiliaryTerm("emptyStack");

    protected final Term getDontCareTerm() {
        return this.mDontCareTerm;
    }

    protected final int constructFreshSerialNumber() {
        return this.mSerialNumberCounter++;
    }

    public final boolean isDontCare(IPredicate iPredicate) {
        return iPredicate.getFormula() == this.mDontCareTerm;
    }

    public final boolean isDontCare(Term term) {
        return term == this.mDontCareTerm;
    }

    public final DebugPredicate newDebugPredicate(String string) {
        return new DebugPredicate(string, this.constructFreshSerialNumber(), this.mDontCareTerm);
    }

    public UnknownState newDontCarePredicate(IcfgLocation icfgLocation) {
        UnknownState unknownState = new UnknownState(icfgLocation, this.constructFreshSerialNumber(), this.mDontCareTerm);
        return unknownState;
    }

    public <T extends IPredicate> T construct(PredicateConstructorFunction<T> predicateConstructorFunction) {
        return predicateConstructorFunction.construct(this.constructFreshSerialNumber());
    }

    private static final class AuxiliaryTerm
    extends Term {
        private final String mName;

        private AuxiliaryTerm(String string) {
            super(0);
            this.mName = string;
        }

        public Sort getSort() {
            throw new UnsupportedOperationException("Auxiliary term has no sort");
        }

        public void toStringHelper(ArrayDeque<Object> arrayDeque) {
            throw new UnsupportedOperationException("Auxiliary term must not be subterm of other terms");
        }

        public TermVariable[] getFreeVars() {
            throw new UnsupportedOperationException("Auxiliary term has no vars");
        }

        public Theory getTheory() {
            throw new UnsupportedOperationException("Auxiliary term has no theory");
        }

        public String toString() {
            return this.mName;
        }

        public String toStringDirect() {
            return this.mName;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("Auxiliary term must not be contained in any collection");
        }
    }

    public static interface PredicateConstructorFunction<T extends IPredicate> {
        public T construct(int var1);
    }
}

