/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.cdt.parser.MultiparseSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class FlatSymbolTable {
    private static final boolean DEBUG_ENABLE_STORE_LOGGING = false;
    private final Map<String, SymbolTableValue> mGlobalScope;
    private final Map<IASTNode, Map<String, SymbolTableValue>> mCTable;
    private final MultiparseSymbolTable mMultiparseInformation;
    private int mScopeCounter;
    private final Map<IASTNode, Integer> mCScopeIDs;
    private final Function<IASTNode, IASTNode> mCHookSkip;
    private final Map<String, String> mBoogieIdToCId;
    private final Map<CDeclaration, Declaration> mCDeclToBoogieDecl;
    private final ILogger mLogger;

    public FlatSymbolTable(ILogger iLogger, MultiparseSymbolTable multiparseSymbolTable) {
        this.mLogger = iLogger;
        this.mGlobalScope = new LinkedHashMap<String, SymbolTableValue>();
        this.mCTable = new LinkedHashMap<IASTNode, Map<String, SymbolTableValue>>();
        this.mCScopeIDs = new HashMap<IASTNode, Integer>();
        this.mBoogieIdToCId = new HashMap<String, String>();
        this.mCDeclToBoogieDecl = new HashMap<CDeclaration, Declaration>();
        this.mMultiparseInformation = multiparseSymbolTable;
        this.mScopeCounter = 1;
        this.mCHookSkip = iASTNode -> {
            if (iASTNode instanceof IASTExpression && iASTNode.getParent() instanceof IASTSwitchStatement && ((IASTSwitchStatement)iASTNode.getParent()).getControllerExpression() == iASTNode) {
                return iASTNode.getParent().getParent();
            }
            return iASTNode;
        };
    }

    public Map<String, SymbolTableValue> getGlobalScope() {
        return Collections.unmodifiableMap(this.mGlobalScope);
    }

    private SymbolTableValue tableFind(IASTNode iASTNode, String string, boolean bl) {
        IASTNode iASTNode2 = this.mCHookSkip.apply(iASTNode);
        while (iASTNode2 != null) {
            Map<String, SymbolTableValue> map = iASTNode2 instanceof IASTTranslationUnit ? this.mGlobalScope : this.mCTable.get(iASTNode2);
            if (map != null) {
                SymbolTableValue symbolTableValue = map.get(string);
                if (symbolTableValue != null) {
                    return symbolTableValue;
                }
                if (bl) {
                    return null;
                }
            }
            iASTNode2 = iASTNode2.getParent();
            iASTNode2 = this.mCHookSkip.apply(iASTNode2);
        }
        return null;
    }

    public IASTNode tableFindCursor(IASTNode iASTNode, String string, SymbolTableValue symbolTableValue) {
        IASTNode iASTNode2 = this.mCHookSkip.apply(iASTNode);
        while (iASTNode2 != null) {
            SymbolTableValue symbolTableValue2;
            Map<String, SymbolTableValue> map = iASTNode2 instanceof IASTTranslationUnit ? this.mGlobalScope : this.mCTable.get(iASTNode2);
            if (map != null && (symbolTableValue2 = map.get(string)) != null && symbolTableValue == symbolTableValue2) {
                return iASTNode2;
            }
            iASTNode2 = iASTNode2.getParent();
            iASTNode2 = this.mCHookSkip.apply(iASTNode2);
        }
        return null;
    }

    public SymbolTableValue findCSymbol(IASTNode iASTNode, String string) {
        return this.tableFind(iASTNode, string, false);
    }

    public boolean containsCSymbol(IASTNode iASTNode, String string) {
        return this.findCSymbol(iASTNode, string) != null;
    }

    public SymbolTableValue findCSymbolInInnermostScope(IASTNode iASTNode, String string) {
        return this.tableFind(iASTNode, string, true);
    }

    public int getCScopeId(IASTNode iASTNode) {
        IASTNode iASTNode2 = this.mCHookSkip.apply(iASTNode);
        while (iASTNode2 != null) {
            boolean bl;
            if (iASTNode2 instanceof IASTTranslationUnit) {
                return 1;
            }
            boolean bl2 = iASTNode2 instanceof IASTFunctionDefinition || iASTNode2 instanceof IASTForStatement;
            boolean bl3 = bl = iASTNode2 instanceof IASTCompoundStatement && !(iASTNode2.getParent() instanceof IASTFunctionDefinition) && !(iASTNode2.getParent() instanceof IASTForStatement);
            if (bl2 || bl) {
                Integer n = this.mCScopeIDs.get(iASTNode2);
                if (n != null) {
                    return n;
                }
                ++this.mScopeCounter;
                this.mCScopeIDs.put(iASTNode2, this.mScopeCounter);
                return this.mScopeCounter;
            }
            iASTNode2 = iASTNode2.getParent();
            iASTNode2 = this.mCHookSkip.apply(iASTNode2);
        }
        return 0;
    }

    private void tableStore(IASTNode iASTNode, String string, SymbolTableValue symbolTableValue) {
        IASTNode iASTNode2 = this.mCHookSkip.apply(iASTNode);
        while (iASTNode2 != null) {
            if (iASTNode2 instanceof IASTTranslationUnit) {
                if (symbolTableValue == null) {
                    this.mGlobalScope.remove(string);
                    break;
                }
                this.mGlobalScope.put(string, symbolTableValue);
                break;
            }
            if (iASTNode2 instanceof IASTCompositeTypeSpecifier) break;
            if (FlatSymbolTable.hasOwnScope(iASTNode2)) {
                Map<String, SymbolTableValue> map = this.mCTable.get(iASTNode2);
                if (map == null) {
                    map = new LinkedHashMap<String, SymbolTableValue>();
                    this.mCTable.put(iASTNode2, map);
                }
                if (symbolTableValue == null) {
                    map.remove(string);
                    break;
                }
                map.put(string, symbolTableValue);
                break;
            }
            iASTNode2 = iASTNode2.getParent();
            iASTNode2 = this.mCHookSkip.apply(iASTNode2);
        }
        if (iASTNode2 == null) {
            throw new IllegalStateException("Found no possible scope holder");
        }
    }

    public void storeCSymbol(IASTNode iASTNode, String string, SymbolTableValue symbolTableValue) {
        this.tableStore(iASTNode, string, symbolTableValue);
        this.mBoogieIdToCId.put(symbolTableValue.getBoogieName(), string);
        this.mCDeclToBoogieDecl.put(symbolTableValue.getCDecl(), symbolTableValue.getBoogieDecl());
    }

    public void removeCSymbol(IASTNode iASTNode, String string) {
        this.tableStore(iASTNode, string, null);
    }

    public void updateCSymbolFromOccurence(IASTNode iASTNode, String string, SymbolTableValue symbolTableValue, SymbolTableValue symbolTableValue2) {
        IASTNode iASTNode2 = this.tableFindCursor(iASTNode, string, symbolTableValue);
        this.updateCSymbolFromCursor(iASTNode2, string, symbolTableValue, symbolTableValue2);
    }

    public void updateCSymbolFromCursor(IASTNode iASTNode, String string, SymbolTableValue symbolTableValue, SymbolTableValue symbolTableValue2) {
        Map<String, SymbolTableValue> map;
        if (iASTNode != null && (map = iASTNode instanceof IASTTranslationUnit ? this.mGlobalScope : this.mCTable.get(iASTNode)) != null) {
            map.put(string, symbolTableValue2);
            this.mBoogieIdToCId.remove(symbolTableValue.getBoogieName());
            this.mBoogieIdToCId.put(symbolTableValue2.getBoogieName(), string);
            this.mCDeclToBoogieDecl.remove(symbolTableValue.getCDecl());
            this.mCDeclToBoogieDecl.put(symbolTableValue2.getCDecl(), symbolTableValue2.getBoogieDecl());
            return;
        }
        throw new IllegalArgumentException("The old symbol table value could not be found in the table with the given cursor: " + String.valueOf(iASTNode));
    }

    public Iterable<SymbolTableValue> getInnermostCScopeValues(IASTNode iASTNode) {
        IASTNode iASTNode2 = this.mCHookSkip.apply(iASTNode);
        while (iASTNode2 != null) {
            Map<String, SymbolTableValue> map = this.mCTable.get(iASTNode2);
            if (map != null) {
                return Collections.unmodifiableCollection(map.values());
            }
            if (FlatSymbolTable.hasOwnScope(iASTNode2)) {
                return Collections.emptyList();
            }
            iASTNode2 = iASTNode2.getParent();
            iASTNode2 = this.mCHookSkip.apply(iASTNode2);
        }
        return Collections.emptyList();
    }

    public String applyMultiparseRenaming(String string, String string2) {
        return this.mMultiparseInformation.getNameMappingIfExists(string, string2);
    }

    public String getCIdForBoogieId(String string) {
        return this.mBoogieIdToCId.get(string);
    }

    public Declaration getBoogieDeclForCDecl(CDeclaration cDeclaration) {
        return this.mCDeclToBoogieDecl.get(cDeclaration);
    }

    public boolean containsBoogieSymbol(String string) {
        return this.mBoogieIdToCId.containsKey(string);
    }

    public void addBoogieCIdPair(String string, String string2, ILocation iLocation) {
        String string3 = this.mBoogieIdToCId.put(string, string2);
        if (string3 != null && !string3.equals(string2)) {
            String string4 = "Variable with this name was already declared before:" + string2;
            throw new IncorrectSyntaxException(iLocation, string4);
        }
    }

    public Map<String, String> getBoogieCIdentifierMapping() {
        return Collections.unmodifiableMap(this.mBoogieIdToCId);
    }

    private static boolean hasOwnScope(IASTNode iASTNode) {
        boolean bl;
        boolean bl2 = iASTNode instanceof IASTFunctionDefinition || iASTNode instanceof IASTForStatement || iASTNode instanceof IASTFunctionDeclarator;
        boolean bl3 = bl = iASTNode instanceof IASTCompoundStatement && !(iASTNode.getParent() instanceof IASTFunctionDefinition);
        return bl2 || bl;
    }

    public boolean isInsideStructDeclaration(IASTDeclarator iASTDeclarator) {
        IASTDeclarator iASTDeclarator2 = iASTDeclarator;
        while (iASTDeclarator2 != null) {
            if (iASTDeclarator2 instanceof IASTCompositeTypeSpecifier) {
                return true;
            }
            iASTDeclarator2 = iASTDeclarator2.getParent();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Global: ").append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append(this.mGlobalScope.entrySet().stream().map(entry -> (String)entry.getKey() + " " + String.valueOf(entry.getValue())).collect(Collectors.joining(",")));
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        for (Map.Entry<IASTNode, Map<String, SymbolTableValue>> entry2 : this.mCTable.entrySet()) {
            stringBuilder.append(entry2.getKey().getClass().getSimpleName()).append(" ");
            stringBuilder.append(entry2.getKey().getFileLocation().getStartingLineNumber()).append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append(entry2.getValue().entrySet().stream().map(entry -> (String)entry.getKey() + " " + String.valueOf(entry.getValue())).collect(Collectors.joining(",")));
        }
        return stringBuilder.toString();
    }
}

