/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureBase;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MemoryStructureUnbounded
extends MemoryStructureBase {
    private final HeapDataArray mIntegerArray;
    private final HeapDataArray mFloatingArray;

    public MemoryStructureUnbounded(TypeSizes typeSizes, ITypeHandler iTypeHandler) {
        super(typeSizes, iTypeHandler);
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ASTType aSTType = iTypeHandler.cType2AstType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.INT));
        ASTType aSTType2 = iTypeHandler.cType2AstType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.FLOAT));
        BoogieType boogieType = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType);
        BoogieType boogieType2 = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType2);
        this.mIntegerArray = new HeapDataArray("int", aSTType, boogieType, this.mTypeHandler.getBoogiePointerType(), 0);
        this.mFloatingArray = new HeapDataArray("real", aSTType2, boogieType2, this.mTypeHandler.getBoogiePointerType(), 0);
    }

    @Override
    public String getProcedureSuffix(CPrimitive.CPrimitives cPrimitives) {
        return this.getDataHeapArray(cPrimitives).getName();
    }

    @Override
    public HeapDataArray getDataHeapArray(CPrimitive.CPrimitives cPrimitives) {
        if (cPrimitives.isIntegertype()) {
            return this.mIntegerArray;
        }
        if (cPrimitives.isFloatingtype()) {
            return this.mFloatingArray;
        }
        throw new AssertionError();
    }

    @Override
    public List<MemoryStructureBase.ReadWriteDefinition> getReadWriteDefinitionForNonPointerHeapDataArray(HeapDataArray heapDataArray, RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        HashRelation hashRelation = new HashRelation();
        for (CPrimitive.CPrimitives object2 : requiredMemoryModelFeatures.getDataOnHeapRequired()) {
            if (this.getDataHeapArray(object2) != heapDataArray) continue;
            hashRelation.addPair((Object)0, (Object)object2);
        }
        ArrayList<MemoryStructureBase.ReadWriteDefinition> arrayList = new ArrayList<MemoryStructureBase.ReadWriteDefinition>();
        for (Object object3 : hashRelation.getDomain()) {
            Set set = hashRelation.getImage(object3);
            CPrimitive.CPrimitives cPrimitives = (CPrimitive.CPrimitives)((Object)set.iterator().next());
            String string = this.getProcedureSuffix(cPrimitives);
            ASTType aSTType = this.mTypeHandler.cType2AstType(LocationFactory.createIgnoreCLocation(), new CPrimitive(cPrimitives));
            boolean bl = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getUncheckedWriteRequired(), (Set)set);
            boolean bl2 = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getInitWriteRequired(), (Set)set);
            arrayList.add(new MemoryStructureBase.ReadWriteDefinition(string, (Integer)object3, aSTType, new CPrimitive(cPrimitives), bl, bl2));
        }
        return arrayList;
    }

    @Override
    protected int bytesizeOfStoredPointerComponents() {
        return 0;
    }
}

