/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.acsl.parser.ACSLSyntaxErrorException;
import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedWitnessDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class ExtractedGhostVariable
implements IExtractedWitnessDeclaration {
    private final String mVariable;
    private final IASTNode mMatchedAstNode;
    private final String mExpression;
    private final String mType;

    public ExtractedGhostVariable(String string, String string2, String string3, IASTNode iASTNode) {
        this.mVariable = string;
        this.mExpression = string2;
        this.mType = string3;
        this.mMatchedAstNode = iASTNode;
    }

    public String toString() {
        return "ghost_variable " + this.mVariable + " = " + this.mExpression;
    }

    @Override
    public VariableDeclaration getDeclaration(FlatSymbolTable flatSymbolTable) {
        SymbolTableValue symbolTableValue = flatSymbolTable.findCSymbol(this.mMatchedAstNode, this.mVariable);
        if (symbolTableValue == null) {
            throw new AssertionError((Object)("No declaration was created for the ghost variable " + this.mVariable));
        }
        return (VariableDeclaration)symbolTableValue.getBoogieDecl();
    }

    @Override
    public ExpressionResult getInitializationResult(IDispatcher iDispatcher) {
        ACSLNode aCSLNode = null;
        try {
            aCSLNode = Parser.parseComment((String)String.format("lstart\n ghost %s %s = %s;", this.mType, this.mVariable, this.mExpression), (int)1, (int)1);
        }
        catch (ACSLSyntaxErrorException aCSLSyntaxErrorException) {
            throw new UnsupportedSyntaxException(LocationFactory.createIgnoreCLocation(this.mMatchedAstNode), aCSLSyntaxErrorException.getMessageText());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        return (ExpressionResult)iDispatcher.dispatch(aCSLNode, this.mMatchedAstNode);
    }
}

