/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Update;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CaWriter<LETTER, STATE>
extends GeneralAutomatonPrinter {
    private final CountingAutomaton<LETTER, STATE> mCa;
    private final Map<STATE, String> mStateMapping;
    private final Map<LETTER, String> mAlphabetMapping;

    public CaWriter(PrintWriter printWriter, String string, CountingAutomaton<LETTER, STATE> countingAutomaton) {
        super(printWriter);
        this.mCa = countingAutomaton;
        this.mStateMapping = this.getStateMapping(this.mCa.getStates());
        this.mAlphabetMapping = this.getAlphabetMapping(this.mCa.getAlphabet());
        this.print("CountingAutomaton ");
        this.print(string);
        this.printAutomatonPrefix();
        this.printAlphabet();
        this.printCounter();
        this.printStates();
        this.printInitialConditions();
        this.printFinalConditions();
        this.printTransitions();
        this.printLastTransitionLineSeparator();
        this.printAutomatonSuffix();
        this.finish();
    }

    protected Map<STATE, String> getStateMapping(Collection<STATE> collection) {
        HashMap<STATE, String> hashMap = new HashMap<STATE, String>();
        for (STATE STATE : collection) {
            hashMap.put(STATE, CaWriter.quoteAndReplaceBackslashes(STATE));
        }
        return hashMap;
    }

    protected Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
        HashMap<LETTER, String> hashMap = new HashMap<LETTER, String>();
        for (LETTER LETTER : collection) {
            hashMap.put(LETTER, CaWriter.quoteAndReplaceBackslashes(LETTER));
        }
        return hashMap;
    }

    private void printAlphabet() {
        this.printCollectionPrefix("alphabet");
        this.printValues(this.mAlphabetMapping);
        this.printCollectionSuffix();
    }

    private void printCounter() {
        this.printCollectionPrefix("counter");
        for (Counter counter : this.mCa.getCounter()) {
            this.printElement(counter.getCounterName());
        }
        this.printCollectionSuffix();
    }

    private void printStates() {
        this.printCollectionPrefix("states");
        this.printValues(this.mStateMapping);
        this.printCollectionSuffix();
    }

    private void printGuard(Guard guard) {
        switch (guard.getTermType()) {
            case TRUE: {
                this.print("true");
                break;
            }
            case FALSE: {
                this.print("false");
                break;
            }
            case CONSTANT: {
                this.print('(');
                this.print(guard.getRelationSymbol().toString());
                this.print(' ');
                this.print(guard.getCounterLeft().getCounterName());
                this.print(' ');
                this.print(guard.getConstant().toString());
                this.print(')');
                break;
            }
            case COUNTER: {
                this.print('(');
                this.print(guard.getRelationSymbol().toString());
                this.print(' ');
                this.print(guard.getCounterLeft().getCounterName());
                this.print(' ');
                this.print(guard.getCounterRight().getCounterName());
                this.print(')');
                break;
            }
            case SUM: {
                this.print('(');
                this.print(guard.getRelationSymbol().toString());
                this.print(' ');
                this.print(guard.getCounterLeft().getCounterName());
                this.print(" (+ ");
                this.print(guard.getCounterRight().getCounterName());
                this.print(' ');
                this.print(guard.getConstant().toString());
                this.print("))");
            }
        }
    }

    private void printSublist(ArrayList<Guard> arrayList) {
        if (arrayList.size() > 1) {
            this.print(" (and");
            for (Guard guard : arrayList) {
                this.print(' ');
                this.printGuard(guard);
            }
            this.print(')');
        } else {
            for (Guard guard : arrayList) {
                this.print(' ');
                this.printGuard(guard);
            }
        }
    }

    private void printInitialConditions() {
        this.printCollectionPrefix("initialConditions");
        this.print('\n');
        for (STATE STATE : this.mCa.getStates()) {
            this.printOneTransitionPrefix();
            this.print(this.mStateMapping.get(STATE));
            this.print(' ');
            this.print('\"');
            ArrayList<ArrayList<Guard>> arrayList = this.mCa.getInitialConditions().get(STATE).getCondition();
            if (arrayList.size() > 1) {
                this.print("(or");
                for (ArrayList<Guard> arrayList2 : arrayList) {
                    this.printSublist(arrayList2);
                }
                this.print(')');
            } else {
                for (ArrayList<Guard> arrayList2 : arrayList) {
                    this.printSublist(arrayList2);
                }
            }
            this.print('\"');
            this.printOneTransitionSuffix();
        }
        this.printCollectionSuffix();
    }

    private void printFinalConditions() {
        this.printCollectionPrefix("finalConditions");
        this.print('\n');
        for (STATE STATE : this.mCa.getStates()) {
            this.printOneTransitionPrefix();
            this.print(this.mStateMapping.get(STATE));
            this.print(' ');
            this.print('\"');
            ArrayList<ArrayList<Guard>> arrayList = this.mCa.getFinalConditions().get(STATE).getCondition();
            if (arrayList.size() > 1) {
                this.print("(or");
                for (ArrayList<Guard> arrayList2 : arrayList) {
                    this.printSublist(arrayList2);
                }
                this.print(')');
            } else {
                for (ArrayList<Guard> arrayList2 : arrayList) {
                    this.printSublist(arrayList2);
                }
            }
            this.print('\"');
            this.printOneTransitionSuffix();
        }
        this.printCollectionSuffix();
    }

    private void printTransitions() {
        this.printCollectionPrefix("transitions");
        this.print('\n');
        for (STATE STATE : this.mCa.getStates()) {
            for (Transition<LETTER, STATE> transition : this.mCa.getTransitions().get(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mAlphabetMapping.get(transition.getLetter()));
                this.print(' ');
                this.print('\"');
                ArrayList<ArrayList<Guard>> arrayList = transition.getGuards();
                if (arrayList.size() > 1) {
                    this.print("(or");
                    for (ArrayList<Guard> arrayList2 : arrayList) {
                        this.printSublist(arrayList2);
                    }
                    this.print(')');
                } else {
                    for (ArrayList<Guard> arrayList3 : arrayList) {
                        this.printSublist(arrayList3);
                    }
                }
                this.print('\"');
                this.print(' ');
                this.print('{');
                for (Update update : transition.getUpdates()) {
                    this.print(' ');
                    switch (update.getTermType()) {
                        case TRUE: {
                            this.print("true");
                            break;
                        }
                        case FALSE: {
                            this.print("false");
                            break;
                        }
                        case CONSTANT: {
                            this.print(update.getCounterLeft().getCounterName());
                            this.print(" := \"");
                            this.print(update.getConstant().toString());
                            this.print('\"');
                            break;
                        }
                        case COUNTER: {
                            this.print(update.getCounterLeft().getCounterName());
                            this.print(" := \"");
                            this.print(update.getCounterRight().getCounterName());
                            this.print('\"');
                            break;
                        }
                        case SUM: {
                            this.print(update.getCounterLeft().getCounterName());
                            this.print(" := \"");
                            this.print("(+ ");
                            this.print(update.getCounterRight().getCounterName());
                            this.print(' ');
                            this.print(update.getConstant().toString());
                            this.print(")\"");
                        }
                    }
                    if (transition.getUpdates().indexOf(update) >= transition.getUpdates().size() - 1) continue;
                    this.print(',');
                }
                this.print(' ');
                this.print('}');
                this.print(' ');
                this.print(this.mStateMapping.get(transition.getSucState()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }
}

