/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.CTrans;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Hist;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.ITrans;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.NwaWithArrays;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Partition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.RTrans;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class Converter<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final IMergeStateFactory<STATE> mFactory;
    private final INestedWordAutomaton<LETTER, STATE> mAutomaton;
    private final Set<LETTER> mIAlphabet;
    private final Set<LETTER> mCAlphabet;
    private final Set<LETTER> mRAlphabet;
    private final HashMap<LETTER, Integer> mISymIndex;
    private final HashMap<LETTER, Integer> mCSymIndex;
    private final HashMap<LETTER, Integer> mRSymIndex;
    private final ArrayList<LETTER> mISym;
    private final ArrayList<LETTER> mCSym;
    private final ArrayList<LETTER> mRSym;
    private final Set<STATE> mOldStates;
    private final Set<STATE> mOldInitialStates;
    private final Collection<STATE> mOldFinalStates;
    private final HashMap<STATE, Integer> mOldStateIndex;
    private final ArrayList<STATE> mOldState;
    private final NwaWithArrays mConverted;

    Converter(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        int n;
        this.mServices = automataLibraryServices;
        this.mFactory = iMergeStateFactory;
        this.mAutomaton = iNestedWordAutomaton;
        this.mOldStates = iNestedWordAutomaton.getStates();
        this.mOldInitialStates = iNestedWordAutomaton.getInitialStates();
        this.mOldFinalStates = iNestedWordAutomaton.getFinalStates();
        this.mIAlphabet = iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet();
        this.mCAlphabet = iNestedWordAutomaton.getVpAlphabet().getCallAlphabet();
        this.mRAlphabet = iNestedWordAutomaton.getVpAlphabet().getReturnAlphabet();
        this.mOldStateIndex = new HashMap();
        this.mOldState = new ArrayList();
        this.mISymIndex = new HashMap();
        this.mCSymIndex = new HashMap();
        this.mRSymIndex = new HashMap();
        this.mISym = new ArrayList();
        this.mCSym = new ArrayList();
        this.mRSym = new ArrayList();
        for (Object object : this.mOldStates) {
            assert (!this.mOldStateIndex.containsKey(object));
            n = this.mOldState.size();
            this.mOldStateIndex.put(object, n);
            this.mOldState.add(object);
        }
        for (Object object : this.mIAlphabet) {
            assert (!this.mISymIndex.containsKey(object));
            n = this.mISym.size();
            this.mISymIndex.put(object, n);
            this.mISym.add(object);
        }
        for (Object object : this.mCAlphabet) {
            assert (!this.mCSymIndex.containsKey(object));
            n = this.mCSym.size();
            this.mCSymIndex.put(object, n);
            this.mCSym.add(object);
        }
        for (Object object : this.mRAlphabet) {
            assert (!this.mRSymIndex.containsKey(object));
            n = this.mRSym.size();
            this.mRSymIndex.put(object, n);
            this.mRSym.add(object);
        }
        int n2 = this.mOldState.size();
        int n3 = this.mISym.size();
        n = this.mCSym.size();
        int n4 = this.mRSym.size();
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        int n5 = 0;
        while (n5 < n2) {
            blArray[n5] = this.mOldInitialStates.contains(this.mOldState.get(n5));
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            blArray2[n5] = this.mOldFinalStates.contains(this.mOldState.get(n5));
            ++n5;
        }
        ArrayList<ITrans> arrayList = new ArrayList<ITrans>();
        ArrayList<CTrans> arrayList2 = new ArrayList<CTrans>();
        ArrayList<RTrans> arrayList3 = new ArrayList<RTrans>();
        int n6 = 0;
        while (n6 < n2) {
            STATE STATE = this.mOldState.get(n6);
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(STATE)) {
                arrayList.add(new ITrans(n6, this.mISymIndex.get(outgoingInternalTransition.getLetter()), this.mOldStateIndex.get(outgoingInternalTransition.getSucc())));
            }
            for (OutgoingCallTransition outgoingCallTransition : iNestedWordAutomaton.callSuccessors(STATE)) {
                arrayList2.add(new CTrans(n6, this.mCSymIndex.get(outgoingCallTransition.getLetter()), this.mOldStateIndex.get(outgoingCallTransition.getSucc())));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : iNestedWordAutomaton.returnSuccessors(STATE)) {
                arrayList3.add(new RTrans(n6, this.mRSymIndex.get(outgoingReturnTransition.getLetter()), this.mOldStateIndex.get(outgoingReturnTransition.getHierPred()), this.mOldStateIndex.get(outgoingReturnTransition.getSucc())));
            }
            ++n6;
        }
        this.mConverted = new NwaWithArrays();
        this.mConverted.mNumStates = n2;
        this.mConverted.mNumISyms = n3;
        this.mConverted.mNumCSyms = n;
        this.mConverted.mNumRSyms = n4;
        this.mConverted.mIsInitial = blArray;
        this.mConverted.mIsFinal = blArray2;
        this.mConverted.mITrans = arrayList.toArray(new ITrans[arrayList.size()]);
        this.mConverted.mCTrans = arrayList2.toArray(new CTrans[arrayList2.size()]);
        this.mConverted.mRTrans = arrayList3.toArray(new RTrans[arrayList3.size()]);
    }

    NwaWithArrays getNwa() {
        return this.mConverted.clone();
    }

    INestedWordAutomaton<LETTER, STATE> constructMerged(Partition partition) {
        Object object;
        assert (partition.mClassOf.length == this.mOldState.size());
        int n = partition.mNumClasses;
        int[] nArray = partition.mClassOf;
        HashSet<ITrans> hashSet = new HashSet<ITrans>();
        HashSet<CTrans> hashSet2 = new HashSet<CTrans>();
        HashSet<RTrans> hashSet3 = new HashSet<RTrans>();
        Object object2 = this.mConverted.mITrans;
        int n2 = this.mConverted.mITrans.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            hashSet.add(new ITrans(nArray[((ITrans)object).mSrc], ((ITrans)object).mSym, nArray[((ITrans)object).mDst]));
            ++n3;
        }
        object2 = this.mConverted.mCTrans;
        n2 = this.mConverted.mCTrans.length;
        n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            hashSet2.add(new CTrans(nArray[((CTrans)object).mSrc], ((CTrans)object).mSym, nArray[((CTrans)object).mDst]));
            ++n3;
        }
        object2 = this.mConverted.mRTrans;
        n2 = this.mConverted.mRTrans.length;
        n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            hashSet3.add(new RTrans(nArray[((RTrans)object).mSrc], ((RTrans)object).mSym, nArray[((RTrans)object).mTop], nArray[((RTrans)object).mDst]));
            ++n3;
        }
        object = new ArrayList();
        n3 = 0;
        while (n3 < n) {
            ((ArrayList)object).add(new ArrayList());
            ++n3;
        }
        n3 = 0;
        while (n3 < this.mOldState.size()) {
            ((ArrayList)((ArrayList)object).get(nArray[n3])).add(this.mOldState.get(n3));
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            assert (!((ArrayList)((ArrayList)object).get(n3)).isEmpty());
            ++n3;
        }
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        HashSet<STATE> hashSet4 = new HashSet<STATE>();
        object2 = new HashSet();
        int n4 = 0;
        while (n4 < n) {
            STATE object3 = this.mFactory.merge((Collection)((ArrayList)object).get(n4));
            arrayList.add(object3);
            for (Iterator iterator : (ArrayList)((ArrayList)object).get(n4)) {
                if (this.mOldInitialStates.contains(iterator)) {
                    hashSet4.add(object3);
                }
                if (!this.mOldFinalStates.contains(iterator)) continue;
                ((HashSet)object2).add(object3);
            }
            ++n4;
        }
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, new VpAlphabet<LETTER>(this.mIAlphabet, this.mCAlphabet, this.mRAlphabet), this.mFactory);
        for (Object e : arrayList) {
            nestedWordAutomaton.addState(hashSet4.contains(e), ((HashSet)object2).contains(e), e);
        }
        for (ITrans iTrans : hashSet) {
            nestedWordAutomaton.addInternalTransition(arrayList.get(iTrans.mSrc), this.mISym.get(iTrans.mSym), arrayList.get(iTrans.mDst));
        }
        for (CTrans cTrans : hashSet2) {
            nestedWordAutomaton.addCallTransition(arrayList.get(cTrans.mSrc), this.mCSym.get(cTrans.mSym), arrayList.get(cTrans.mDst));
        }
        for (RTrans rTrans : hashSet3) {
            nestedWordAutomaton.addReturnTransition(arrayList.get(rTrans.mSrc), arrayList.get(rTrans.mTop), this.mRSym.get(rTrans.mSym), arrayList.get(rTrans.mDst));
        }
        return nestedWordAutomaton;
    }

    ArrayList<Hist> computeHistoryStates() {
        if (!(this.mAutomaton instanceof IDoubleDeckerAutomaton)) {
            throw new IllegalArgumentException("Operand must be an IDoubleDeckerAutomaton.");
        }
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = (IDoubleDeckerAutomaton)this.mAutomaton;
        Object STATE = this.mAutomaton.getEmptyStackState();
        ArrayList<Hist> arrayList = new ArrayList<Hist>();
        int n = 0;
        while (n < this.mOldState.size()) {
            if (iDoubleDeckerAutomaton.isDoubleDecker(this.mOldState.get(n), STATE)) {
                arrayList.add(new Hist(n, -1));
            }
            int n2 = 0;
            while (n2 < this.mOldState.size()) {
                if (iDoubleDeckerAutomaton.isDoubleDecker(this.mOldState.get(n), this.mOldState.get(n2))) {
                    arrayList.add(new Hist(n, n2));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }
}

