/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util;

import java.util.BitSet;

class EnumeratorBitSet
extends BitSet
implements Comparable<EnumeratorBitSet> {
    private static final long serialVersionUID = 1L;
    private final int size;

    public EnumeratorBitSet(int n) {
        super(n);
        assert (n > 0) : "valuation size should be positive number";
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EnumeratorBitSet enumeratorBitSet = (EnumeratorBitSet)object;
        return this.compareTo(enumeratorBitSet) == 0;
    }

    @Override
    public EnumeratorBitSet clone() {
        EnumeratorBitSet enumeratorBitSet = new EnumeratorBitSet(this.size());
        enumeratorBitSet.or(this);
        return enumeratorBitSet;
    }

    @Override
    public int compareTo(EnumeratorBitSet enumeratorBitSet) {
        if (enumeratorBitSet.size() > this.size()) {
            return -1;
        }
        if (enumeratorBitSet.size() < this.size()) {
            return 1;
        }
        int n = 0;
        while (n < this.size()) {
            if (this.get(n) && !enumeratorBitSet.get(n)) {
                return 1;
            }
            if (!this.get(n) && enumeratorBitSet.get(n)) {
                return -1;
            }
            ++n;
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    protected void nextBitSet() {
        int n = this.nextClearBit(0);
        this.clear(0, n);
        this.set(n);
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("EnumeratorBitSet doesnot support hashCode");
    }
}

