/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.util;

import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Iterator;
import java.util.Map;

public class HashRelationBackedSetOfPairs<E>
implements ISetOfPairs<E, HashRelation<E, E>> {
    private final HashRelation<E, E> mRelation = new HashRelation();

    @Override
    public Iterator<Pair<E, E>> iterator() {
        return new IteratorFromHashRelation<E>(this.mRelation);
    }

    @Override
    public void addPair(E e, E e2) {
        this.mRelation.addPair(e, e2);
    }

    @Override
    public boolean containsPair(E e, E e2) {
        return this.mRelation.containsPair(e, e2);
    }

    @Override
    public HashRelation<E, E> getRelation() {
        return this.mRelation;
    }

    public String toString() {
        return this.mRelation.toString();
    }

    private static final class IteratorFromHashRelation<E>
    implements Iterator<Pair<E, E>> {
        private final Iterator<Map.Entry<E, E>> mIt;

        public IteratorFromHashRelation(HashRelation<E, E> hashRelation) {
            this.mIt = hashRelation.getSetOfPairs().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIt.hasNext();
        }

        @Override
        public Pair<E, E> next() {
            Map.Entry<E, E> entry = this.mIt.next();
            return new Pair(entry.getKey(), entry.getValue());
        }
    }
}

