/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.AbstractCounterexample;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IResultReporter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RcfgResultReporter<STATE extends IAbstractState<STATE>, ACTION extends IcfgEdge, LOC extends IcfgLocation>
implements IResultReporter<STATE, ACTION, LOC> {
    protected final IUltimateServiceProvider mServices;
    private final IIcfg<LOC> mIcfg;
    private final Set<LOC> mUnsafeLocs;
    private boolean mIsFinished;

    public RcfgResultReporter(IIcfg<LOC> iIcfg, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mIcfg = iIcfg;
        this.mUnsafeLocs = new HashSet<LOC>();
        this.mIsFinished = false;
    }

    @Override
    public void reportPossibleError(AbstractCounterexample<DisjunctiveAbstractState<STATE>, ACTION, LOC> abstractCounterexample) {
        IcfgProgramExecution icfgProgramExecution2;
        HashMap<Integer, IProgramExecution.ProgramState<Term>> hashMap = new HashMap<Integer, IProgramExecution.ProgramState<Term>>();
        ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>();
        hashMap.put(-1, this.computeProgramState((DisjunctiveAbstractState)abstractCounterexample.getInitialState()));
        int n = 0;
        for (IcfgProgramExecution icfgProgramExecution2 : abstractCounterexample.getAbstractExecution()) {
            arrayList.add(((IcfgEdge)icfgProgramExecution2.getThird()).getLabel());
            hashMap.put(n, this.computeProgramState((DisjunctiveAbstractState)icfgProgramExecution2.getFirst()));
            ++n;
        }
        icfgProgramExecution2 = IcfgProgramExecution.create(arrayList, hashMap);
        Iterator<Object> iterator = this.getLast(abstractCounterexample);
        if (!this.mUnsafeLocs.add(iterator)) {
            throw new AssertionError((Object)("You added a possible error for this location twice: " + String.valueOf(iterator)));
        }
        UnprovableResult unprovableResult = new UnprovableResult(Activator.PLUGIN_ID, iterator, this.mServices.getBacktranslationService(), (IProgramExecution)icfgProgramExecution2, "abstract domain could reach this error location");
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)unprovableResult);
    }

    private IProgramExecution.ProgramState<Term> computeProgramState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return new IProgramExecution.ProgramState(Collections.emptyMap(), Term.class);
    }

    private LOC getLast(AbstractCounterexample<DisjunctiveAbstractState<STATE>, ACTION, LOC> abstractCounterexample) {
        int n = abstractCounterexample.getAbstractExecution().size();
        return (LOC)((IcfgLocation)((Triple)abstractCounterexample.getAbstractExecution().get(n - 1)).getSecond());
    }

    @Override
    public void reportFinished() {
        Object object;
        assert (!this.mIsFinished) : "You should not call this method twice";
        this.mIsFinished = true;
        Set set = IcfgUtils.getErrorLocations(this.mIcfg);
        if (this.mUnsafeLocs.isEmpty()) {
            object = AllSpecificationsHoldResult.createAllSpecificationsHoldResult((String)"Abstract Interpretation", (int)set.size());
            this.reportResult((IResult)object);
        }
        object = DataStructureUtils.difference((Set)set, this.mUnsafeLocs);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IcfgLocation icfgLocation = (IcfgLocation)iterator.next();
            PositiveResult positiveResult = new PositiveResult("Abstract Interpretation", (IElement)icfgLocation, this.mServices.getBacktranslationService());
            this.reportResult((IResult)positiveResult);
        }
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }
}

