/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.RewriteArrays2;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EqualitySupportingInvariantAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class MapEliminationLassoPreprocessor
extends LassoPreprocessor {
    private static final String DESCRIPTION = "Removes maps (arrays and UFs) by introducing new variables for each relevant argument";
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final Set<Term> mArrayIndexSupportingInvariants;
    private final MapEliminationSettings mSettings;

    public MapEliminationLassoPreprocessor(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, ReplacementVarFactory replacementVarFactory, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set, Set<Term> set2, MapEliminationSettings mapEliminationSettings) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mManagedScript = managedScript;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mReplacementVarFactory = replacementVarFactory;
        this.mOriginalStem = unmodifiableTransFormula;
        this.mOriginalLoop = unmodifiableTransFormula2;
        this.mModifiableGlobalsAtHonda = set;
        this.mArrayIndexSupportingInvariants = set2;
        this.mSettings = mapEliminationSettings;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lassoUnderConstruction) throws TermException {
        MapEliminator mapEliminator = new MapEliminator(this.mServices, this.mLogger, this.mManagedScript, this.mSymbolTable, this.mReplacementVarFactory, Arrays.asList(lassoUnderConstruction.getStem(), lassoUnderConstruction.getLoop()), this.mSettings);
        EqualityAnalysisResult equalityAnalysisResult = new EqualityAnalysisResult(mapEliminator.getDoubletons());
        EqualitySupportingInvariantAnalysis equalitySupportingInvariantAnalysis = new EqualitySupportingInvariantAnalysis(mapEliminator.getDoubletons(), this.mSymbolTable, this.mManagedScript, this.mOriginalStem, this.mOriginalLoop, this.mModifiableGlobalsAtHonda);
        EqualityAnalysisResult equalityAnalysisResult2 = equalitySupportingInvariantAnalysis.getEqualityAnalysisResult();
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisResult2.constructListOfEqualities(this.mManagedScript.getScript()));
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisResult2.constructListOfNotEquals(this.mManagedScript.getScript()));
        ModifiableTransFormula modifiableTransFormula = mapEliminator.eliminateMaps(lassoUnderConstruction.getStem(), equalityAnalysisResult, equalityAnalysisResult2);
        ModifiableTransFormula modifiableTransFormula2 = mapEliminator.eliminateMaps(lassoUnderConstruction.getLoop(), equalityAnalysisResult2, equalityAnalysisResult2);
        LassoUnderConstruction lassoUnderConstruction2 = new LassoUnderConstruction(modifiableTransFormula, modifiableTransFormula2);
        assert (RewriteArrays2.checkStemImplication(this.mServices, this.mLogger, lassoUnderConstruction, lassoUnderConstruction2, this.mSymbolTable, this.mManagedScript)) : "result of RewriteArrays too strong";
        return Collections.singleton(lassoUnderConstruction2);
    }
}

