/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitutionTerm;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.LinkedHashSet;
import java.util.Set;

class OctagonSubstitution {
    private final TermVariable mVar;
    private final Set<OctagonSubstitutionTerm> mGreaterEqThan;
    private final Set<OctagonSubstitutionTerm> mLesserEqThan;

    protected OctagonSubstitution(TermVariable termVariable) {
        this.mVar = termVariable;
        this.mGreaterEqThan = new LinkedHashSet<OctagonSubstitutionTerm>();
        this.mLesserEqThan = new LinkedHashSet<OctagonSubstitutionTerm>();
    }

    void addSubstitution(OctTerm octTerm) {
        if (octTerm.getFirstVar().equals(this.mVar)) {
            this.addSubstitution(octTerm, true);
        } else if (octTerm.getSecondVar().equals(this.mVar)) {
            this.addSubstitution(octTerm, false);
        }
    }

    void addSubstitution(OctTerm octTerm, boolean bl) {
        OctagonSubstitutionTerm octagonSubstitutionTerm;
        boolean bl2 = false;
        if (bl) {
            octagonSubstitutionTerm = octTerm.isOneVar() ? new OctagonSubstitutionTerm(octTerm.getValue()) : new OctagonSubstitutionTerm(octTerm.getValue(), octTerm.getSecondVar(), octTerm.isSecondNegative());
            if (octTerm.isFirstNegative()) {
                bl2 = true;
            }
        } else {
            octagonSubstitutionTerm = new OctagonSubstitutionTerm(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative());
            if (octTerm.isSecondNegative()) {
                bl2 = true;
            }
        }
        this.addSubstitution(octagonSubstitutionTerm, bl2);
    }

    void addSubstitution(OctagonSubstitutionTerm octagonSubstitutionTerm, boolean bl) {
        if (bl) {
            this.mGreaterEqThan.add(octagonSubstitutionTerm);
        } else {
            this.mLesserEqThan.add(octagonSubstitutionTerm);
        }
    }

    Set<OctagonSubstitutionTerm> getGreaterSubsitutions() {
        return this.mGreaterEqThan;
    }

    Set<OctagonSubstitutionTerm> getLesserSubsitutions() {
        return this.mLesserEqThan;
    }

    public String toString() {
        if (this.mGreaterEqThan.isEmpty() && this.mLesserEqThan.isEmpty()) {
            return " > Substitution for " + this.mVar.toString() + " empty. \n";
        }
        StringBuilder stringBuilder = new StringBuilder(" > Substitution for " + this.mVar.toString() + ":\n");
        stringBuilder.append("Greater Equal Than: ");
        for (OctagonSubstitutionTerm octagonSubstitutionTerm : this.mGreaterEqThan) {
            stringBuilder.append(octagonSubstitutionTerm.toString() + "; ");
        }
        stringBuilder.append("\nLesser Equal Than: ");
        for (OctagonSubstitutionTerm octagonSubstitutionTerm : this.mLesserEqThan) {
            stringBuilder.append(octagonSubstitutionTerm.toString() + "; ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

