/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctValue;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctMatrix;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ParametricOctMatrix {
    private ILogger mLogger;
    private OctMatrix mMatrix;
    private OctMatrix mSummands;
    private TermVariable mParametricVar;
    private boolean mParametric;
    private int mSize;
    private int mNextMaxValue = 0;
    private final Map<TermVariable, Integer> mVariableMapping;
    private final Map<Integer, TermVariable> mReverseMapping;
    public static final BiFunction<OctValue, OctValue, OctValue> sAddIgnoreInf = (octValue, octValue2) -> {
        if (octValue.isInfinity() && octValue2.isInfinity()) {
            return OctValue.INFINITY;
        }
        OctValue octValue3 = octValue.isInfinity() ? OctValue.ZERO : octValue;
        OctValue octValue4 = octValue2.isInfinity() ? OctValue.ZERO : octValue2;
        return octValue3.add(octValue4);
    };

    public ParametricOctMatrix() {
        this(0);
    }

    public ParametricOctMatrix(int n) {
        this.mVariableMapping = new HashMap<TermVariable, Integer>();
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.mSize = n;
        this.mParametric = false;
        this.mMatrix = new OctMatrix(n);
        this.mMatrix.fill(OctValue.INFINITY);
    }

    public ParametricOctMatrix(OctMatrix octMatrix, Map<TermVariable, Integer> map) {
        this.mSize = octMatrix.getSize();
        this.mMatrix = octMatrix.copy();
        this.mVariableMapping = map;
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.reverseMapping();
        this.mParametric = false;
    }

    public ParametricOctMatrix(OctMatrix octMatrix, Map<TermVariable, Integer> map, TermVariable termVariable) {
        this.mSize = octMatrix.getSize();
        this.mMatrix = octMatrix.copy();
        this.mVariableMapping = map;
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.reverseMapping();
        this.mParametric = true;
        this.mSummands = new OctMatrix(octMatrix.variables());
        this.mSummands.fill(OctValue.INFINITY);
        this.mParametricVar = termVariable;
    }

    public ParametricOctMatrix(OctMatrix octMatrix, OctMatrix octMatrix2, Map<TermVariable, Integer> map, TermVariable termVariable) {
        this(octMatrix, map, termVariable);
        this.mSummands = octMatrix2.copy();
        this.mParametric = true;
    }

    public void setLogger(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public ParametricOctMatrix add(ParametricOctMatrix parametricOctMatrix) {
        if (!this.mappingMatch(parametricOctMatrix)) {
            throw new IllegalArgumentException("Matrices need equal Mapping");
        }
        if (this.isParametric() || parametricOctMatrix.isParametric()) {
            return this.parametricAdd(parametricOctMatrix);
        }
        return new ParametricOctMatrix(this.mMatrix.add(parametricOctMatrix.getMatrix()), this.mVariableMapping);
    }

    private ParametricOctMatrix parametricAdd(ParametricOctMatrix parametricOctMatrix) {
        ParametricOctMatrix parametricOctMatrix2;
        if (this.mParametric && !parametricOctMatrix.isParametric()) {
            parametricOctMatrix2 = new ParametricOctMatrix(this.getMatrix(), this.addMatrices(this.getSummands(), parametricOctMatrix.getMatrix(), true), this.getMapping(), this.getParametricVar());
            this.debug("Set Summands of result");
        } else if (!this.mParametric && parametricOctMatrix.isParametric()) {
            this.debug("Matrix is not parametric, summand is.");
            parametricOctMatrix2 = parametricOctMatrix.copy();
            parametricOctMatrix2.mSummands = this.mMatrix.add(parametricOctMatrix.getSummands());
        } else {
            this.debug("Both are parametric.");
            if (!this.mParametricVar.equals(parametricOctMatrix.getParametricVar())) {
                throw new IllegalArgumentException("Matrices need the same parametric variable");
            }
            parametricOctMatrix2 = this.copy();
            parametricOctMatrix2.mSummands = this.mSummands.add(parametricOctMatrix.getSummands());
            parametricOctMatrix2.mMatrix = this.mMatrix.add(parametricOctMatrix.getMatrix());
        }
        return parametricOctMatrix2;
    }

    public ParametricOctMatrix subtract(ParametricOctMatrix parametricOctMatrix) {
        if (this.mParametric || parametricOctMatrix.isParametric()) {
            throw new UnsupportedOperationException("Matrix is parametric");
        }
        this.debug("Subtraction");
        OctMatrix octMatrix = ParametricOctMatrix.negateOctMatrix(parametricOctMatrix.getMatrix());
        this.debug("negated");
        this.debug(this.mSize);
        this.debug(parametricOctMatrix.getSize());
        ParametricOctMatrix parametricOctMatrix2 = new ParametricOctMatrix(this.mMatrix.add(octMatrix), this.mVariableMapping);
        this.debug("...finished.");
        return parametricOctMatrix2;
    }

    private static OctMatrix negateOctMatrix(OctMatrix octMatrix) {
        OctMatrix octMatrix2 = octMatrix.copy();
        int n = 0;
        while (n < 2 * octMatrix.variables()) {
            int n2 = 0;
            while (n2 < (n / 2 + 1) * 2) {
                octMatrix2.set(n, n2, octMatrix.get(n, n2).negateIfNotInfinity());
                ++n2;
            }
            ++n;
        }
        return octMatrix2;
    }

    public boolean isEqualTo(ParametricOctMatrix parametricOctMatrix) {
        if (parametricOctMatrix == null) {
            return false;
        }
        if (!this.getClass().equals(parametricOctMatrix.getClass())) {
            return false;
        }
        ParametricOctMatrix parametricOctMatrix2 = parametricOctMatrix;
        if (this.isParametric() != parametricOctMatrix2.isParametric()) {
            return false;
        }
        if (!this.getMatrix().isEqualTo(parametricOctMatrix2.getMatrix())) {
            return false;
        }
        this.debug(this.isParametric());
        this.debug(this.getParametricVar() == null);
        if (this.isParametric() && parametricOctMatrix2.isParametric()) {
            if (!this.getParametricVar().equals(parametricOctMatrix2.getParametricVar())) {
                return false;
            }
            if (!this.getSummands().isEqualTo(parametricOctMatrix2.getSummands())) {
                return false;
            }
        }
        if (!this.mVariableMapping.equals(parametricOctMatrix2.getMapping())) {
            return false;
        }
        Object object = new Object();
        object.hashCode();
        return true;
    }

    public ParametricOctMatrix multiplyVar(String string, ManagedScript managedScript) {
        if (this.isParametric()) {
            throw new IllegalArgumentException("Octagon already parametric.");
        }
        TermVariable termVariable = managedScript.constructFreshTermVariable(string, managedScript.getScript().sort("Int", new Sort[0]));
        return this.multipyVar(termVariable);
    }

    public ParametricOctMatrix multipyVar(TermVariable termVariable) {
        return new ParametricOctMatrix(this.mMatrix, this.mVariableMapping, termVariable);
    }

    public ParametricOctMatrix multiplyConstant(BigDecimal bigDecimal) {
        int n;
        OctMatrix octMatrix = this.mMatrix.copy();
        int n2 = 0;
        while (n2 < 2 * this.mMatrix.variables()) {
            n = 0;
            while (n < (n2 / 2 + 1) * 2) {
                OctValue octValue = this.mMatrix.get(n2, n).isInfinity() ? OctValue.INFINITY : new OctValue(this.mMatrix.get(n2, n).getValue().multiply(bigDecimal));
                octMatrix.set(n2, n, octValue);
                ++n;
            }
            ++n2;
        }
        if (!this.mParametric) {
            return new ParametricOctMatrix(octMatrix, this.mVariableMapping);
        }
        OctMatrix octMatrix2 = this.mSummands.copy();
        n = 0;
        while (n < 2 * this.mSummands.variables()) {
            int n3 = 0;
            while (n3 < (n / 2 + 1) * 2) {
                octMatrix2.set(n, n3, this.mSummands.get(n, n3).isInfinity() ? OctValue.INFINITY : new OctValue(this.mSummands.get(n, n3).getValue().multiply(bigDecimal)));
                ++n3;
            }
            ++n;
        }
        return new ParametricOctMatrix(octMatrix, octMatrix2, this.mVariableMapping, this.mParametricVar);
    }

    private OctMatrix addMatrices(OctMatrix octMatrix, OctMatrix octMatrix2, boolean bl) {
        if (!bl) {
            return octMatrix.add(octMatrix2);
        }
        return octMatrix.elementwiseOperation(octMatrix2, sAddIgnoreInf);
    }

    public int addVar(TermVariable termVariable) {
        this.debug("Adding " + termVariable.toString() + " to Mapping");
        this.mVariableMapping.put(termVariable, this.mNextMaxValue);
        this.reverseMapping(termVariable);
        if (this.mSize < this.mVariableMapping.size()) {
            this.debug("Size too small. " + this.mSize + " " + this.mVariableMapping.size() * 2);
            this.mMatrix = this.mMatrix.addVariables(1);
            this.mSize = this.mVariableMapping.size();
            assert (this.mSize == this.mMatrix.getSize()) : "ERROR MATRIX SIZES DO NOT MATCH";
        }
        this.mNextMaxValue += 2;
        return this.mVariableMapping.get(termVariable);
    }

    public void setValue(Object object, TermVariable termVariable, boolean bl) {
        this.setValue(object, termVariable, bl, termVariable, bl);
    }

    public void setValue(Object object, TermVariable termVariable, boolean bl, TermVariable termVariable2, boolean bl2) {
        int n;
        int n2;
        this.debug("Setting value: " + object.toString());
        this.debug("FirstVar: " + termVariable.toString());
        this.debug("SecondVar: " + termVariable2.toString());
        if (this.mVariableMapping.containsKey(termVariable)) {
            n2 = this.mVariableMapping.get(termVariable);
            this.debug("Row already known: " + n2);
        } else {
            n2 = this.addVar(termVariable);
            this.debug("Row new Variable: " + n2);
        }
        if (termVariable.equals(termVariable2)) {
            n = n2;
        } else if (this.mVariableMapping.containsKey(termVariable2)) {
            n = this.mVariableMapping.get(termVariable2);
            this.debug("Column already known: " + n);
        } else {
            n = this.addVar(termVariable2);
            this.debug("Column new Variable: " + n);
        }
        if (bl) {
            ++n2;
        }
        if (!bl2) {
            ++n;
        }
        this.debug("Setting [" + n2 + "," + n + "] = " + object.toString());
        this.setValue(n2, n, (BigDecimal)object);
    }

    private void setValue(int n, int n2, BigDecimal bigDecimal) {
        this.mMatrix.setMin(n, n2, new OctValue(bigDecimal));
    }

    private void reverseMapping() {
        for (TermVariable termVariable : this.mVariableMapping.keySet()) {
            this.mReverseMapping.put(this.mVariableMapping.get(termVariable), termVariable);
        }
    }

    private void reverseMapping(TermVariable termVariable) {
        this.mReverseMapping.put(this.mVariableMapping.get(termVariable), termVariable);
    }

    public OctConjunction toOctConjunction() {
        return this.toOctConjunction(0);
    }

    public OctConjunction toOctConjunction(int n) {
        this.debug("Converting to Octagon conjunction");
        OctConjunction octConjunction = new OctConjunction();
        ArrayList<OctTerm> arrayList = new ArrayList<OctTerm>();
        int n2 = 0;
        while (n2 < 2 * this.varCount()) {
            int n3 = 0;
            while (n3 < (n2 / 2 + 1) * 2) {
                OctValue octValue;
                this.debug("Row, Col: " + n2 + ", " + n3);
                OctValue octValue2 = this.mMatrix.get(n2, n3);
                this.debug(octValue2.toString());
                OctValue octValue3 = octValue = this.mParametric ? this.mSummands.get(n2, n3) : OctValue.INFINITY;
                if (!octValue2.isInfinity() || !octValue.isInfinity()) {
                    if (octValue2.isInfinity()) {
                        arrayList.add(this.toNonParametricTerm(octValue, n2, n3));
                    } else if (this.mParametric) {
                        arrayList.add(this.toParametricTerm(octValue2, octValue, n2, n3, n));
                    } else if (octValue.isInfinity()) {
                        arrayList.add(this.toNonParametricTerm(octValue2, n2, n3));
                    }
                }
                ++n3;
            }
            ++n2;
        }
        for (OctTerm octTerm : arrayList) {
            octConjunction.addTerm(octTerm);
        }
        return octConjunction;
    }

    private OctTerm toNonParametricTerm(OctValue octValue, int n, int n2) {
        boolean bl;
        boolean bl2 = n % 2 != 0;
        boolean bl3 = bl = n2 % 2 == 0;
        if ((n & 1) != 0) {
            --n;
        }
        if ((n2 & 1) != 0) {
            --n2;
        }
        return OctagonFactory.createTwoVarOctTerm(octValue.getValue(), this.mReverseMapping.get(n), bl2, this.mReverseMapping.get(n2), bl);
    }

    private OctTerm toParametricTerm(OctValue octValue, OctValue octValue2, int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = n % 2 != 0;
        boolean bl3 = bl = n2 % 2 == 0;
        if ((n & 1) != 0) {
            --n;
        }
        if ((n2 & 1) != 0) {
            --n2;
        }
        ParametricOctValue parametricOctValue = new ParametricOctValue(octValue.getValue(), octValue2.isInfinity() ? BigDecimal.ZERO : octValue2.getValue(), this.mParametricVar, new BigDecimal(n3));
        return OctagonFactory.createTwoVarOctTerm(parametricOctValue, this.mReverseMapping.get(n), bl2, this.mReverseMapping.get(n2), bl);
    }

    public Term toTerm(Script script) {
        return this.toOctConjunction().toTerm(script);
    }

    public OctMatrix getMatrix() {
        return this.mMatrix.copy();
    }

    public int getSize() {
        return this.mSize;
    }

    public int varCount() {
        this.mVariableMapping.size();
        int cfr_ignored_0 = this.mSize / 2;
        return this.mVariableMapping.size();
    }

    public boolean isParametric() {
        return this.mParametric;
    }

    public TermVariable getParametricVar() {
        if (!this.isParametric()) {
            return null;
        }
        return this.mParametricVar;
    }

    public OctMatrix getSummands() {
        if (!this.isParametric()) {
            return null;
        }
        return this.mSummands.copy();
    }

    public Object getValue(int n, int n2) {
        if (this.mParametric) {
            OctValue octValue = this.mMatrix.get(n, n2);
            if (octValue.equals((Object)OctValue.INFINITY)) {
                return null;
            }
            OctValue octValue2 = this.mSummands.get(n, n2);
            if (octValue2.equals((Object)OctValue.INFINITY)) {
                return new ParametricOctValue(octValue.getValue(), BigDecimal.ZERO, this.mParametricVar);
            }
            return new ParametricOctValue(octValue.getValue(), octValue2.getValue(), this.mParametricVar);
        }
        OctValue octValue = this.mMatrix.get(n, n2);
        if (octValue.equals((Object)OctValue.INFINITY)) {
            return null;
        }
        return octValue.getValue();
    }

    public Map<TermVariable, Integer> getMapping() {
        return this.mVariableMapping;
    }

    public ParametricOctMatrix copy() {
        if (this.mParametric) {
            return new ParametricOctMatrix(this.mMatrix, this.mSummands, this.mVariableMapping, this.mParametricVar);
        }
        return new ParametricOctMatrix(this.mMatrix, this.mVariableMapping);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ParametricOctMatrix");
        if (this.isParametric()) {
            stringBuilder.append(" with parametric Variable ").append(this.mParametricVar.toString()).append(":\n");
            stringBuilder.append("Coefficients: \n");
            stringBuilder.append(this.mMatrix.toString());
            stringBuilder.append("\n");
            stringBuilder.append("Summands: \n");
            stringBuilder.append(this.mSummands.toString());
        } else {
            stringBuilder.append(":\n");
            stringBuilder.append(this.mMatrix.toString());
        }
        stringBuilder.append("\n VariableMapping: ").append(this.mVariableMapping.toString());
        return stringBuilder.toString();
    }

    private boolean mappingMatch(ParametricOctMatrix parametricOctMatrix) {
        return parametricOctMatrix.getMapping().equals(this.mVariableMapping);
    }

    private void debug(Object object) {
        if (this.mLogger != null) {
            this.mLogger.debug(object);
        }
    }
}

