/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationManager;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;

public class BvToIntTransformation
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Translate Bitvectors to Integer Formulas";
    private final IUltimateServiceProvider mServices;
    private final ReplacementVarFactory mFac;
    final LinkedHashMap<Term, Term> mBacktranslationMap = new LinkedHashMap();
    private final boolean mUseNutzTransformation;

    public BvToIntTransformation(IUltimateServiceProvider iUltimateServiceProvider, ReplacementVarFactory replacementVarFactory, ManagedScript managedScript, boolean bl) {
        this.mFac = replacementVarFactory;
        this.mServices = iUltimateServiceProvider;
        this.mUseNutzTransformation = bl;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) throws TermException {
        IReplacementVarOrConst iReplacementVarOrConst;
        IProgramVar iProgramVar2;
        if (!modifiableTransFormula.getNonTheoryConsts().isEmpty()) {
            throw new UnsupportedOperationException("Non-theory constants: " + String.valueOf(modifiableTransFormula.getNonTheoryConsts()));
        }
        ModifiableTransFormula modifiableTransFormula2 = new ModifiableTransFormula(modifiableTransFormula);
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (IProgramVar iProgramVar2 : TransFormula.collectAllProgramVars((TransFormula)modifiableTransFormula)) {
            TermVariable termVariable;
            TermVariable termVariable2;
            iReplacementVarOrConst = this.mFac.getOrConstuctReplacementVar((Term)iProgramVar2.getTermVariable(), true, BvToIntTransformation.bvToIntSort(managedScript, iProgramVar2.getTerm().getSort()));
            this.mBacktranslationMap.put((Term)((IProgramVar)iReplacementVarOrConst).getTermVariable(), (Term)iProgramVar2.getTermVariable());
            if (modifiableTransFormula.getInVars().get(iProgramVar2) != null && modifiableTransFormula.getOutVars().get(iProgramVar2) != null) {
                if (((TermVariable)modifiableTransFormula.getInVars().get(iProgramVar2)).equals(modifiableTransFormula.getOutVars().get(iProgramVar2))) {
                    TermVariable termVariable3;
                    termVariable2 = termVariable3 = managedScript.constructFreshTermVariable("intInAndOutVar", BvToIntTransformation.bvToIntSort(managedScript, ((TermVariable)modifiableTransFormula.getInVars().get(iProgramVar2)).getSort()));
                    termVariable = termVariable3;
                } else {
                    termVariable2 = managedScript.constructFreshTermVariable("intInVar", BvToIntTransformation.bvToIntSort(managedScript, ((TermVariable)modifiableTransFormula.getInVars().get(iProgramVar2)).getSort()));
                    termVariable = managedScript.constructFreshTermVariable("intOutVar", BvToIntTransformation.bvToIntSort(managedScript, ((TermVariable)modifiableTransFormula.getOutVars().get(iProgramVar2)).getSort()));
                }
                linkedHashMap.put((Term)modifiableTransFormula.getInVars().get(iProgramVar2), termVariable2);
                modifiableTransFormula2.addInVar((IProgramVar)iReplacementVarOrConst, termVariable2);
                linkedHashMap.put((Term)modifiableTransFormula.getOutVars().get(iProgramVar2), termVariable);
                modifiableTransFormula2.addOutVar((IProgramVar)iReplacementVarOrConst, termVariable);
                continue;
            }
            if (modifiableTransFormula.getInVars().get(iProgramVar2) != null) {
                termVariable2 = managedScript.constructFreshTermVariable("intInVar", BvToIntTransformation.bvToIntSort(managedScript, ((TermVariable)modifiableTransFormula.getInVars().get(iProgramVar2)).getSort()));
                modifiableTransFormula2.addInVar((IProgramVar)iReplacementVarOrConst, termVariable2);
                linkedHashMap.put((Term)modifiableTransFormula.getInVars().get(iProgramVar2), termVariable2);
            }
            if (modifiableTransFormula.getOutVars().get(iProgramVar2) == null) continue;
            termVariable = managedScript.constructFreshTermVariable("intOutVar", BvToIntTransformation.bvToIntSort(managedScript, ((TermVariable)modifiableTransFormula.getOutVars().get(iProgramVar2)).getSort()));
            modifiableTransFormula2.addOutVar((IProgramVar)iReplacementVarOrConst, termVariable);
            linkedHashMap.put((Term)modifiableTransFormula.getOutVars().get(iProgramVar2), termVariable);
        }
        for (IProgramVar iProgramVar2 : modifiableTransFormula.getAuxVars()) {
            iReplacementVarOrConst = managedScript.constructFreshTermVariable(iProgramVar2.getName(), BvToIntTransformation.bvToIntSort(managedScript, iProgramVar2.getSort()));
            linkedHashMap.put(iProgramVar2, iReplacementVarOrConst);
            modifiableTransFormula2.addAuxVars(Collections.singleton(iReplacementVarOrConst));
        }
        iProgramVar2 = new TranslationManager(managedScript, TranslationConstrainer.ConstraintsForBitwiseOperations.SUM, this.mUseNutzTransformation);
        iProgramVar2.setReplacementVarMaps(linkedHashMap);
        Triple triple = iProgramVar2.translateBvtoInt(modifiableTransFormula.getFormula());
        if (!((Set)triple.getSecond()).isEmpty() || ((Boolean)triple.getThird()).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        modifiableTransFormula2.setFormula((Term)triple.getFirst());
        return modifiableTransFormula2;
    }

    public static Sort bvToIntSort(ManagedScript managedScript, Sort sort) {
        if (SmtSortUtils.isBitvecSort((Sort)sort)) {
            return SmtSortUtils.getIntSort((ManagedScript)managedScript);
        }
        if (SmtSortUtils.isArraySort((Sort)sort)) {
            Sort[] sortArray = new Sort[sort.getArguments().length];
            int n = 0;
            while (n < sort.getArguments().length) {
                sortArray[n] = BvToIntTransformation.bvToIntSort(managedScript, sort.getArguments()[n]);
                ++n;
            }
            assert (sortArray.length == 2);
            Sort sort2 = sortArray[0];
            Sort sort3 = sortArray[1];
            return SmtSortUtils.getArraySort((Script)managedScript.getScript(), (Sort)sort2, (Sort)sort3);
        }
        if (SmtSortUtils.isBoolSort((Sort)sort)) {
            return sort;
        }
        return sort;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        return true;
    }

    public LinkedHashMap<Term, Term> getBacktranslationOfVariables() {
        return this.mBacktranslationMap;
    }
}

