/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.CachedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ConditionTransformingIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.DefaultIndependenceCache;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.DisjunctiveConditionalIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ProtectedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.UnionIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction.IAbstraction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction.IndependenceRelationWithAbstraction;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.PredicateTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.DebugPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticConditionEliminator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceConditionGenerator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SyntacticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.TermTransferringIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.ThreadSeparatingIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public abstract class IndependenceBuilder<L, S, B extends IndependenceBuilder<L, S, B>> {
    private static final String UNCONDITIONAL_ERROR = "Condition transformation for unconditional relation is useless";
    protected final IIndependenceRelation<S, L> mRelation;
    protected final Function<IIndependenceRelation<S, L>, B> mCreator;

    private IndependenceBuilder(IIndependenceRelation<S, L> iIndependenceRelation, Function<IIndependenceRelation<S, L>, B> function) {
        this.mRelation = iIndependenceRelation;
        this.mCreator = function;
    }

    public IIndependenceRelation<S, L> build() {
        return this.mRelation;
    }

    public static <L extends IAction> PredicateActionIndependenceBuilder<L, ?> semantic(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, boolean bl2) {
        return new PredicateActionIndependenceBuilder.Impl(new SemanticIndependenceRelation(iUltimateServiceProvider, managedScript, bl, bl2));
    }

    public static <L extends IAction> PredicateActionIndependenceBuilder<L, ?> semantic(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, boolean bl2, SemanticIndependenceRelation.IndependenceConditions independenceConditions, BasicPredicateFactory basicPredicateFactory, SemanticIndependenceConditionGenerator semanticIndependenceConditionGenerator) {
        return new PredicateActionIndependenceBuilder.Impl(new SemanticIndependenceRelation(iUltimateServiceProvider, managedScript, bl, bl2, independenceConditions, basicPredicateFactory, semanticIndependenceConditionGenerator));
    }

    public static <L extends IAction, S> ActionIndependenceBuilder<L, S, ?> syntactic() {
        return new ActionIndependenceBuilder.Impl(new SyntacticIndependenceRelation());
    }

    public static <L, S> IndependenceBuilder<L, S, ?> fromIndependence(IIndependenceRelation<S, L> iIndependenceRelation) {
        return new Impl<L, S>(iIndependenceRelation);
    }

    public static <L extends IAction> PredicateActionIndependenceBuilder<L, ?> fromPredicateActionIndependence(IIndependenceRelation<IPredicate, L> iIndependenceRelation) {
        return new PredicateActionIndependenceBuilder.Impl<L>(iIndependenceRelation);
    }

    public static <L extends IAction, S> ActionIndependenceBuilder<L, S, ?> fromActionIndependence(IIndependenceRelation<S, L> iIndependenceRelation) {
        return new ActionIndependenceBuilder.Impl<L, S>(iIndependenceRelation);
    }

    public B ifThen(boolean bl, Function<? super B, ? extends B> function) {
        return this.ifThenElse(bl, function, Function.identity());
    }

    public <C extends IndependenceBuilder<L, S, C>> C ifThenElse(boolean bl, Function<? super B, ? extends C> function, Function<? super B, ? extends C> function2) {
        if (bl) {
            return (C)((IndependenceBuilder)function.apply(this.mCreator.apply(this.mRelation)));
        }
        return (C)((IndependenceBuilder)function2.apply(this.mCreator.apply(this.mRelation)));
    }

    public B unionLeft(IIndependenceRelation<S, L> iIndependenceRelation) {
        return this.unionLeft(List.of(iIndependenceRelation));
    }

    public B unionLeft(List<IIndependenceRelation<S, L>> list) {
        return this.union(list, List.of());
    }

    public B unionRight(IIndependenceRelation<S, L> iIndependenceRelation) {
        return this.unionRight(List.of(iIndependenceRelation));
    }

    public B unionRight(List<IIndependenceRelation<S, L>> list) {
        return this.union(List.of(), list);
    }

    public B unionLeft(IIndependenceRelation<S, L> iIndependenceRelation, Function<Stream<S>, S> function) {
        return this.unionLeft(List.of(iIndependenceRelation), function);
    }

    public B unionLeft(List<IIndependenceRelation<S, L>> list, Function<Stream<S>, S> function) {
        return this.union(list, List.of(), function);
    }

    public B unionRight(IIndependenceRelation<S, L> iIndependenceRelation, Function<Stream<S>, S> function) {
        return this.unionRight(List.of(iIndependenceRelation), function);
    }

    public B unionRight(List<IIndependenceRelation<S, L>> list, Function<Stream<S>, S> function) {
        return this.union(List.of(), list, function);
    }

    public B union(List<IIndependenceRelation<S, L>> list, List<IIndependenceRelation<S, L>> list2) {
        ArrayList<IIndependenceRelation<S, L>> arrayList = new ArrayList<IIndependenceRelation<S, L>>(list.size() + 1 + list2.size());
        arrayList.addAll(list);
        arrayList.add(this.mRelation);
        arrayList.addAll(list2);
        return (B)((IndependenceBuilder)this.mCreator.apply((IIndependenceRelation<S, L>)new UnionIndependenceRelation(arrayList)));
    }

    public B union(List<IIndependenceRelation<S, L>> list, List<IIndependenceRelation<S, L>> list2, Function<Stream<S>, S> function) {
        ArrayList<IIndependenceRelation<S, L>> arrayList = new ArrayList<IIndependenceRelation<S, L>>(list.size() + 1 + list2.size());
        arrayList.addAll(list);
        arrayList.add(this.mRelation);
        arrayList.addAll(list2);
        return (B)((IndependenceBuilder)this.mCreator.apply((IIndependenceRelation<S, L>)new UnionIndependenceRelation(arrayList, function)));
    }

    public B ensureUnconditional() {
        if (this.mRelation.isConditional()) {
            return (B)((IndependenceBuilder)this.mCreator.apply(ConditionTransformingIndependenceRelation.unconditional(this.mRelation)));
        }
        return (B)((IndependenceBuilder)this.mCreator.apply(this.mRelation));
    }

    public B cached() {
        return this.cached((CachedIndependenceRelation.IIndependenceCache<S, L>)new DefaultIndependenceCache());
    }

    public B cached(CachedIndependenceRelation.IIndependenceCache<S, L> iIndependenceCache) {
        return (B)((IndependenceBuilder)this.mCreator.apply((IIndependenceRelation<S, L>)new CachedIndependenceRelation(this.mRelation, iIndependenceCache)));
    }

    public B withFilteredConditions(Predicate<S> predicate) {
        if (this.mRelation.isConditional()) {
            UnaryOperator unaryOperator = object -> predicate.test(object) ? object : null;
            return (B)((IndependenceBuilder)this.mCreator.apply((IIndependenceRelation<S, L>)new ConditionTransformingIndependenceRelation(this.mRelation, (Function)unaryOperator, (Function)unaryOperator)));
        }
        return (B)((IndependenceBuilder)this.mCreator.apply(this.mRelation));
    }

    public abstract <T> IndependenceBuilder<L, T, ?> unconditional();

    public abstract <T> IndependenceBuilder<L, T, ?> withTransformedConditions(Function<T, S> var1);

    public static abstract class ActionIndependenceBuilder<L extends IAction, S, B extends ActionIndependenceBuilder<L, S, B>>
    extends IndependenceBuilder<L, S, B> {
        protected ActionIndependenceBuilder(IIndependenceRelation<S, L> iIndependenceRelation, Function<IIndependenceRelation<S, L>, B> function) {
            super(iIndependenceRelation, function);
        }

        public B withSyntacticCheck() {
            return (B)((ActionIndependenceBuilder)this.unionLeft(new SyntacticIndependenceRelation(), (Stream<S> stream) -> stream.findAny().orElse(null)));
        }

        public B threadSeparated() {
            return (B)((ActionIndependenceBuilder)this.mCreator.apply(new ThreadSeparatingIndependenceRelation(this.mRelation)));
        }

        public <H> B withAbstraction(IAbstraction<H, L> iAbstraction, H h) {
            if (iAbstraction == null) {
                return (B)((ActionIndependenceBuilder)this.mCreator.apply(this.mRelation));
            }
            return (B)((ActionIndependenceBuilder)this.mCreator.apply(new IndependenceRelationWithAbstraction(this.mRelation, iAbstraction, h)));
        }

        public B protectAgainstQuantifiers() {
            return (B)((ActionIndependenceBuilder)this.mCreator.apply(new ProtectedIndependenceRelation(this.mRelation, iAction -> QuantifierUtils.isQuantifierFree((Term)iAction.getTransformula().getFormula()))));
        }

        @Override
        public abstract <T> ActionIndependenceBuilder<L, T, ?> unconditional();

        @Override
        public abstract <T> ActionIndependenceBuilder<L, T, ?> withTransformedConditions(Function<T, S> var1);

        private static final class Impl<L extends IAction, S>
        extends ActionIndependenceBuilder<L, S, Impl<L, S>> {
            private Impl(IIndependenceRelation<S, L> iIndependenceRelation) {
                super(iIndependenceRelation, Impl::new);
            }

            @Override
            public <T> ActionIndependenceBuilder<L, T, ?> unconditional() {
                return new Impl<L, S>(ConditionTransformingIndependenceRelation.unconditional((IIndependenceRelation)this.mRelation));
            }

            @Override
            public <T> ActionIndependenceBuilder<L, T, ?> withTransformedConditions(Function<T, S> function) {
                assert (this.mRelation.isConditional()) : "Condition transformation for unconditional relation is useless";
                return new Impl<L, S>(new ConditionTransformingIndependenceRelation(this.mRelation, function));
            }
        }
    }

    private static final class Impl<L, S>
    extends IndependenceBuilder<L, S, Impl<L, S>> {
        private Impl(IIndependenceRelation<S, L> iIndependenceRelation) {
            super(iIndependenceRelation, Impl::new);
        }

        public <T> Impl<L, T> unconditional() {
            return new Impl<L, S>(ConditionTransformingIndependenceRelation.unconditional((IIndependenceRelation)this.mRelation));
        }

        public <T> Impl<L, T> withTransformedConditions(Function<T, S> function) {
            assert (this.mRelation.isConditional()) : "Condition transformation for unconditional relation is useless";
            return new Impl<L, S>(new ConditionTransformingIndependenceRelation(this.mRelation, function));
        }
    }

    public static abstract class PredicateActionIndependenceBuilder<L extends IAction, B extends PredicateActionIndependenceBuilder<L, B>>
    extends ActionIndependenceBuilder<L, IPredicate, B> {
        protected PredicateActionIndependenceBuilder(IIndependenceRelation<IPredicate, L> iIndependenceRelation, Function<IIndependenceRelation<IPredicate, L>, B> function) {
            super(iIndependenceRelation, function);
        }

        public B withConditionElimination(Predicate<IPredicate> predicate) {
            if (this.mRelation.isConditional()) {
                return (B)((PredicateActionIndependenceBuilder)this.mCreator.apply(new SemanticConditionEliminator(this.mRelation, predicate)));
            }
            return (B)((PredicateActionIndependenceBuilder)this.mCreator.apply(this.mRelation));
        }

        public abstract B transferTerms(TransferrerWithVariableCache var1, PredicateTransferrer var2, ICopyActionFactory<L> var3, boolean var4);

        public abstract B withTransformedPredicates(UnaryOperator<IPredicate> var1);

        public abstract B ignoreDebugPredicates();

        public abstract <C extends Collection<IPredicate>> B withDisjunctivePredicates(Function<IPredicate, C> var1);

        public abstract <C extends Collection<IPredicate>> B withDisjunctivePredicates(Function<IPredicate, C> var1, Function<List<IPredicate>, C> var2, DisjunctiveConditionalIndependenceRelation.IConditionMerger<L, IPredicate, C> var3);

        private static final class Impl<L extends IAction>
        extends PredicateActionIndependenceBuilder<L, Impl<L>> {
            private Impl(IIndependenceRelation<IPredicate, L> iIndependenceRelation) {
                super(iIndependenceRelation, Impl::new);
            }

            @Override
            public <T> ActionIndependenceBuilder.Impl<L, T> unconditional() {
                return new ActionIndependenceBuilder.Impl(ConditionTransformingIndependenceRelation.unconditional((IIndependenceRelation)this.mRelation));
            }

            public <T> ActionIndependenceBuilder.Impl<L, T> withTransformedConditions(Function<T, IPredicate> function) {
                assert (this.mRelation.isConditional()) : "Condition transformation for unconditional relation is useless";
                return new ActionIndependenceBuilder.Impl(new ConditionTransformingIndependenceRelation(this.mRelation, function));
            }

            @Override
            public Impl<L> transferTerms(TransferrerWithVariableCache transferrerWithVariableCache, PredicateTransferrer predicateTransferrer, ICopyActionFactory<L> iCopyActionFactory, boolean bl) {
                return new Impl<L>(new TermTransferringIndependenceRelation<L>(this.mRelation, transferrerWithVariableCache, predicateTransferrer, iCopyActionFactory, bl));
            }

            @Override
            public Impl<L> withTransformedPredicates(UnaryOperator<IPredicate> unaryOperator) {
                assert (this.mRelation.isConditional()) : "Condition transformation for unconditional relation is useless";
                return new Impl<L>(new ConditionTransformingIndependenceRelation(this.mRelation, unaryOperator));
            }

            @Override
            public Impl<L> ignoreDebugPredicates() {
                if (this.mRelation.isConditional()) {
                    return (Impl)this.withFilteredConditions(DebugPredicate.class::isInstance);
                }
                return this;
            }

            @Override
            public <C extends Collection<IPredicate>> Impl<L> withDisjunctivePredicates(Function<IPredicate, C> function) {
                if (this.mRelation.isConditional()) {
                    return new Impl<L>(new ConditionTransformingIndependenceRelation((IIndependenceRelation)new DisjunctiveConditionalIndependenceRelation(this.mRelation), function));
                }
                return this;
            }

            @Override
            public <C extends Collection<IPredicate>> Impl<L> withDisjunctivePredicates(Function<IPredicate, C> function, Function<List<IPredicate>, C> function2, DisjunctiveConditionalIndependenceRelation.IConditionMerger<L, IPredicate, C> iConditionMerger) {
                if (this.mRelation.isConditional()) {
                    return new Impl<L>(new ConditionTransformingIndependenceRelation((IIndependenceRelation)new DisjunctiveConditionalIndependenceRelation(this.mRelation, function2, iConditionMerger), function, collection -> (IPredicate)DataStructureUtils.getOneAndOnly((Iterable)collection, (String)"condition")));
                }
                return this;
            }
        }
    }
}

