/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class ModifiableNestedFormulas<L extends IAction, TF, SF>
extends NestedFormulas<L, TF, SF> {
    private final TF[] mTerms;
    private final Map<Integer, TF> mLocalVarAssignmentAtCall = new HashMap<Integer, TF>();
    private final Map<Integer, TF> mGlobalOldVarAssignmentAtCall = new HashMap<Integer, TF>();

    public ModifiableNestedFormulas(Counterexample<L> counterexample, SortedMap<Integer, SF> sortedMap) {
        super(counterexample, sortedMap);
        this.mTerms = new Object[counterexample.length()];
    }

    @Override
    protected TF getFormulaFromValidNonCallPos(int n) {
        return this.mTerms[n];
    }

    @Override
    protected TF getLocalVarAssignmentFromValidPos(int n) {
        return this.mLocalVarAssignmentAtCall.get(n);
    }

    @Override
    protected TF getGlobalVarAssignmentFromValidPos(int n) {
        return this.mTerms[n];
    }

    @Override
    protected TF getOldVarAssignmentFromValidPos(int n) {
        return this.mGlobalOldVarAssignmentAtCall.get(n);
    }

    void setFormulaAtNonCallPos(int n, TF TF) {
        assert (!super.getTrace().isCallPosition(n));
        assert (this.mTerms[n] == null) : "already set";
        this.mTerms[n] = TF;
    }

    void setLocalVarAssignmentAtPos(int n, TF TF) {
        assert (super.getTrace().isCallPosition(n) || super.getTrace().isPendingReturn(n));
        assert (this.mLocalVarAssignmentAtCall.get(n) == null) : "already set";
        this.mLocalVarAssignmentAtCall.put(n, TF);
    }

    void setOldVarAssignmentAtPos(int n, TF TF) {
        assert (super.getTrace().isCallPosition(n) || super.getTrace().isPendingReturn(n));
        assert (this.mGlobalOldVarAssignmentAtCall.get(n) == null) : "already set";
        this.mGlobalOldVarAssignmentAtCall.put(n, TF);
    }

    void setGlobalVarAssignmentAtPos(int n, TF TF) {
        assert (super.getTrace().isCallPosition(n) || super.getTrace().isPendingReturn(n));
        assert (this.mTerms[n] == null) : "already set";
        this.mTerms[n] = TF;
    }
}

