/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.SettingsManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.util.RcpUtils;
import de.uni_freiburg.informatik.ultimate.ep.UltimateExtensionPoints;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class UltimateCore
implements IApplication,
ICore<RunDefinition>,
IUltimatePlugin {
    private static String[] sPluginNames;
    private ILogger mLogger;
    private IController<RunDefinition> mCurrentController;
    private ToolchainWalker mToolchainWalker;
    private ToolchainStorage mCoreStorage;
    private PluginFactory mPluginFactory;
    private SettingsManager mSettingsManager;
    private ToolchainManager mToolchainManager;
    private ILoggingService mLoggingService;
    private JobChangeAdapter mJobChangeAdapter;
    private String mUltimateVersion;

    public final Object startManually(IController<RunDefinition> iController) throws Exception {
        this.setCurrentController(iController);
        return this.start(null);
    }

    public final Object start(IApplicationContext iApplicationContext) throws Exception {
        String string;
        Object object;
        String string2;
        this.mCoreStorage = new ToolchainStorage();
        this.mLoggingService = this.mCoreStorage.getLoggingService();
        this.mLogger = this.mLoggingService.getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.mLogger.debug((Object)"Initializing application");
        ILogger iLogger = this.mLogger;
        this.mJobChangeAdapter = new UltimateJobChangeAdapter(iLogger);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.mJobChangeAdapter);
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mSettingsManager = new SettingsManager(this.mLogger);
        this.mSettingsManager.registerPlugin(this);
        this.mLoggingService.reloadLoggers();
        try {
            string2 = UltimateCore.getCliWorkspaceLoc();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.mLogger.fatal((Object)illegalArgumentException.getMessage());
            return -2;
        }
        if (string2 != null) {
            object = Platform.getInstanceLocation();
            if (object == null) {
                this.mLogger.fatal((Object)"Specifying -data @none is not supported");
                return -2;
            }
            if (object.isSet()) {
                this.mLogger.fatal((Object)"You did specify -ultimatedata without specifying -data @noDefault");
                return -2;
            }
            String string3 = UUID.randomUUID().toString().substring(0, 10).replace("-", "");
            string = Path.fromOSString((String)string2).append(string3).toOSString();
            object.set(new URL("file", null, string), false);
            File file = new File(string);
            Thread thread = new Thread(() -> CoreUtil.deleteDirectory((File)file), "DeleteRandomWorkspace");
            Runtime.getRuntime().addShutdownHook(thread);
        }
        this.mPluginFactory = new PluginFactory(this.mSettingsManager, this.mLogger);
        this.setCurrentController(this.mPluginFactory.getController());
        this.mToolchainManager = new ToolchainManager(this.mLoggingService, this.mPluginFactory, this.getCurrentController());
        try {
            object = this.activateController();
            this.mToolchainManager.close();
            ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
            string = object;
            return string;
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.mJobChangeAdapter);
            this.mJobChangeAdapter = null;
            this.mCoreStorage.clear();
            Platform.getInstanceLocation().release();
        }
    }

    private static String getCliWorkspaceLoc() {
        String[] stringArray;
        EnvironmentInfo environmentInfo = RcpUtils.getEnvironmentInfo();
        Iterator iterator = Arrays.stream(environmentInfo.getCommandLineArgs()).iterator();
        String string = null;
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!"-ultimatedata".equals(stringArray)) continue;
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("-ultimatedata has no argument");
            }
            string = (String)iterator.next();
            break;
        }
        if (string == null) {
            return null;
        }
        String[] stringArray2 = stringArray = new String[]{"@user.home"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.contains(string2)) {
                string = string.replace(string2, environmentInfo.getProperty(string2.substring(1)));
            }
            ++n2;
        }
        return string;
    }

    private int activateController() {
        this.mLogger.debug((Object)"Initializing controller ...");
        if (this.getCurrentController() == null) {
            this.mLogger.fatal((Object)"Could not find a controller. Ultimate will exit.");
            return -1;
        }
        this.mLoggingService.setCurrentControllerID(this.getCurrentControllerID());
        int n = this.getCurrentController().init((ICore)this);
        String string = "Preparing to exit Ultimate with return code " + n;
        if (n == 0) {
            this.mLogger.debug((Object)string);
        } else {
            this.mLogger.warn((Object)string);
        }
        return n;
    }

    public void cancelToolchain() {
        this.mToolchainWalker.cancelToolchain();
    }

    public IUltimatePlugin[] getRegisteredUltimatePlugins() {
        LinkedHashSet<UltimateCore> linkedHashSet = new LinkedHashSet<UltimateCore>();
        linkedHashSet.add(this);
        linkedHashSet.add((UltimateCore)this.getCurrentController());
        linkedHashSet.addAll(this.mPluginFactory.getAllAvailableToolchainPlugins());
        return linkedHashSet.toArray(new IUltimatePlugin[linkedHashSet.size()]);
    }

    public String[] getRegisteredUltimatePluginIDs() {
        List<String> list = this.mPluginFactory.getPluginIds();
        return list.toArray(new String[list.size()]);
    }

    public void loadPreferences(String string, boolean bl) {
        this.mSettingsManager.loadPreferencesFromFile(this, string, bl);
        this.mLoggingService.reloadLoggers();
    }

    public void savePreferences(String string) {
        this.mSettingsManager.savePreferences(this, string);
    }

    public void resetPreferences(boolean bl) {
        this.mSettingsManager.resetPreferences(this, bl);
    }

    public IToolchain<RunDefinition> requestToolchain(File[] fileArray) {
        return this.mToolchainManager.requestToolchain(fileArray);
    }

    public void releaseToolchain(IToolchain<RunDefinition> iToolchain) {
        this.mToolchainManager.releaseToolchain(iToolchain);
    }

    public void stop() {
        this.mLogger.warn((Object)"Received 'Stop'-Command, ignoring...");
    }

    private void setCurrentController(IController<RunDefinition> iController) {
        if (this.mCurrentController != null) {
            if (iController == null) {
                this.mLogger.warn((Object)("Controller already set! Using " + this.mCurrentController.getPluginName() + " and ignoring request to set controller to NULL (this may indicate test mode!)"));
            } else {
                this.mLogger.warn((Object)("Controller already set! Using " + this.mCurrentController.getPluginName() + " and ignoring request to set " + iController.getPluginName()));
            }
            return;
        }
        assert (iController != null) : "There is no controller";
        this.mCurrentController = iController;
    }

    private IController<RunDefinition> getCurrentController() {
        return this.mCurrentController;
    }

    private String getCurrentControllerID() {
        if (this.getCurrentController() == null) {
            return "de.uni_freiburg.informatik.ultimate.core";
        }
        return this.getCurrentController().getPluginID();
    }

    public static synchronized String[] getPluginNames() {
        if (sPluginNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : UltimateExtensionPoints.PLUGIN_EPS) {
                IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    String string2 = iConfigurationElement.getAttribute("class");
                    arrayList.add(string2.substring(0, string2.lastIndexOf(46)));
                    ++n2;
                }
            }
            sPluginNames = arrayList.toArray(new String[arrayList.size()]);
        }
        return sPluginNames;
    }

    public IToolchainData<RunDefinition> createToolchainData(String string) throws FileNotFoundException, JAXBException, SAXException {
        if (!new File(string).exists()) {
            throw new FileNotFoundException("The specified toolchain file " + string + " was not found");
        }
        ToolchainStorage toolchainStorage = new ToolchainStorage();
        return new ToolchainData(string, (IUltimateServiceProvider)toolchainStorage, (IToolchainStorage)toolchainStorage);
    }

    public IToolchainData<RunDefinition> createToolchainData() {
        ToolchainStorage toolchainStorage = new ToolchainStorage();
        return new ToolchainData((IUltimateServiceProvider)toolchainStorage, (IToolchainStorage)toolchainStorage);
    }

    public String getPluginName() {
        return "UltimateCore";
    }

    public String getPluginID() {
        return "de.uni_freiburg.informatik.ultimate.core";
    }

    public IPreferenceInitializer getPreferences() {
        return new CorePreferenceInitializer();
    }

    public ILoggingService getCoreLoggingService() {
        return this.mCoreStorage.getLoggingService();
    }

    public IPreferenceProvider getPreferenceProvider(String string) {
        return this.mCoreStorage.getPreferenceProvider(string);
    }

    public String getUltimateVersionString() {
        if (this.mUltimateVersion == null) {
            this.mUltimateVersion = this.createVersionString();
        }
        return this.mUltimateVersion;
    }

    private String createVersionString() {
        Bundle bundle = Platform.getBundle((String)"de.uni_freiburg.informatik.ultimate.core");
        if (bundle == null) {
            return "UNKNOWN";
        }
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary == null) {
            return "UNKNOWN";
        }
        String string = (String)dictionary.get("Bundle-Version");
        String string2 = CoreUtil.readGitVersion((ClassLoader)this.getClass().getClassLoader());
        if (string2 == null) {
            return string;
        }
        return string + "-" + string2;
    }

    public static final class UltimateJobChangeAdapter
    extends JobChangeAdapter {
        private final ILogger mLogger;

        private UltimateJobChangeAdapter(ILogger iLogger) {
            this.mLogger = iLogger;
        }

        public void done(IJobChangeEvent iJobChangeEvent) {
            if (iJobChangeEvent == null || iJobChangeEvent.getResult() == null || iJobChangeEvent.getResult().getException() == null) {
                return;
            }
            this.mLogger.error((Object)"Error during toolchain job processing:", iJobChangeEvent.getResult().getException());
        }
    }
}

