/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerObserver;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.preferences.BuchiAutomizerPreferenceInitializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BuchiAutomizer
implements IGenerator {
    private ILogger mLogger;
    private BuchiAutomizerObserver mObserver;
    private List<IObserver> mObservers;
    private ModelType mInputDefinition;
    private IUltimateServiceProvider mServices;

    public String getPluginName() {
        return "BuchiAutomizer";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public void init() {
        this.mObserver = new BuchiAutomizerObserver(this.mServices);
        this.mObservers = Collections.singletonList(this.mObserver);
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.ALL;
    }

    public List<String> getDesiredToolIds() {
        return null;
    }

    public void setInputDefinition(ModelType modelType) {
        this.mInputDefinition = modelType;
    }

    public List<IObserver> getObservers() {
        if (BuchiAutomizer.programContainsErrors(this.mServices.getResultService())) {
            this.mLogger.info((Object)"Another Plugin discovered errors, I will not analyze termination");
            return Collections.emptyList();
        }
        this.mLogger.info((Object)"Safety of program was proven or not checked, starting termination analysis");
        return this.mObservers;
    }

    public ModelType getOutputDefinition() {
        return new ModelType(Activator.PLUGIN_ID, this.mInputDefinition.getType(), (Collection)this.mInputDefinition.getFileNames());
    }

    public IElement getModel() {
        if (this.mObserver != null) {
            return this.mObserver.getModel();
        }
        return null;
    }

    public boolean isGuiRequired() {
        return false;
    }

    public IPreferenceInitializer getPreferences() {
        return new BuchiAutomizerPreferenceInitializer();
    }

    private static boolean programContainsErrors(IResultService iResultService) {
        for (Map.Entry entry : iResultService.getResults().entrySet()) {
            for (IResult iResult : (List)entry.getValue()) {
                if (!(iResult instanceof CounterExampleResult)) continue;
                return true;
            }
        }
        return false;
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void finish() {
    }
}

