/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StatisticsType<T extends Enum<T>>
implements IStatisticsType {
    public static final Function<Object, Function<Object, Object>> INTEGER_ADDITION = object -> object2 -> (Integer)object + (Integer)object2;
    public static final Function<Object, Function<Object, Object>> LONG_ADDITION = object -> object2 -> (Long)object + (Long)object2;
    public static final Function<Object, Function<Object, Object>> IN_CA_RE_ADDITION = object -> object2 -> {
        ((InCaReCounter)object).add((InCaReCounter)object2);
        return object;
    };
    public static final Function<Object, Function<Object, Object>> DOUBLE_ADDITION = object -> object2 -> (Double)object + (Double)object2;
    public static final Function<Object, Function<Object, Object>> STATISTICS_DATA_AGGREGATION = object -> object2 -> {
        ((StatisticsData)object).aggregateBenchmarkData((StatisticsData)object2);
        return object;
    };
    public static final Function<Object, Function<Object, Object>> STATISTICS_AGGREGATOR_AGGREGATION = object -> object2 -> {
        ((StatisticsAggregator)object).aggregateBenchmarkData((StatisticsAggregator)object2);
        return object;
    };
    public static final Function<String, Function<Object, String>> KEY_BEFORE_DATA = string -> object -> string + ": " + String.valueOf(object);
    public static final Function<String, Function<Object, String>> DATA_BEFORE_KEY = string -> object -> String.valueOf(object) + " " + string;
    public static final Function<String, Function<Object, String>> NANOS_BEFORE_KEY = string -> object -> StatisticsType.prettyprintNanoseconds((Long)object) + " " + string;
    public static final Function<String, Function<Object, String>> KEY_BEFORE_NANOS = string -> object -> string + ": " + StatisticsType.prettyprintNanoseconds((Long)object);
    public static final Function<Object, Function<Object, Object>> INTEGER_MAX = object -> object2 -> Math.max((Integer)object, (Integer)object2);
    private final Class<T> mKeyType;

    public StatisticsType(Class<T> clazz) {
        this.mKeyType = clazz;
    }

    @Override
    public Collection<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enum[] enumArray = (Enum[])this.mKeyType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enum_ = enumArray[n2];
            arrayList.add(enum_.toString());
            ++n2;
        }
        return arrayList;
    }

    @Override
    public Object aggregate(String string, Object object, Object object2) {
        T t = Enum.valueOf(this.mKeyType, string);
        return ((IStatisticsElement)t).aggregate(object, object2);
    }

    @Override
    public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        return StatisticsType.prettyprintBenchmarkData(this.getKeys(), this.mKeyType, iStatisticsDataProvider);
    }

    public static <T extends Enum<T>> String prettyprintBenchmarkData(Collection<String> collection, Class<T> clazz, IStatisticsDataProvider iStatisticsDataProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : collection) {
            stringBuilder.append(string);
            Object object = iStatisticsDataProvider.getValue(string2);
            T t = Enum.valueOf(clazz, string2);
            stringBuilder.append(((IStatisticsElement)t).prettyprint(object));
            string = ", ";
        }
        return stringBuilder.toString();
    }

    public static String prettyprintBenchmarkData(String string, IStatisticsDataProvider iStatisticsDataProvider) {
        return string + " " + String.valueOf(iStatisticsDataProvider.getValue(string));
    }

    public static String prettyprintNanoseconds(long l) {
        return CoreUtil.toTimeString(l, TimeUnit.NANOSECONDS, TimeUnit.SECONDS, 1);
    }
}

