/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.buchiprogramproduct.productgenerator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DuplicatedDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import java.util.Objects;

public final class ProductLocationNameGenerator {
    private static final String NONWA = "NONWA";
    private int mHelperUnifique = 0;

    protected ProductLocationNameGenerator() {
    }

    protected static DebugIdentifier generateStateName(BoogieIcfgLocation boogieIcfgLocation) {
        return ProductLocationNameGenerator.generateStateName(boogieIcfgLocation, null);
    }

    protected static DebugIdentifier generateStateName(BoogieIcfgLocation boogieIcfgLocation, String string) {
        if (string == null) {
            return new BuchiProgramDebugIdentifier(boogieIcfgLocation.getDebugIdentifier(), NONWA);
        }
        return new BuchiProgramDebugIdentifier(boogieIcfgLocation.getDebugIdentifier(), string);
    }

    protected DebugIdentifier generateHelperStateName(DebugIdentifier debugIdentifier) {
        ++this.mHelperUnifique;
        if (this.mHelperUnifique < 0) {
            throw new IllegalArgumentException();
        }
        return new BuchiProgramHelperStateDebugIdentifier(debugIdentifier, this.mHelperUnifique);
    }

    protected static boolean isHelperState(BoogieIcfgLocation boogieIcfgLocation) {
        if (boogieIcfgLocation == null) {
            return false;
        }
        return boogieIcfgLocation.getDebugIdentifier() instanceof BuchiProgramHelperStateDebugIdentifier;
    }

    private static final class BuchiProgramDebugIdentifier
    extends DebugIdentifier {
        private final DebugIdentifier mIcfgDebugIdentifier;
        private final String mNwaState;

        public BuchiProgramDebugIdentifier(DebugIdentifier debugIdentifier, String string) {
            this.mIcfgDebugIdentifier = Objects.requireNonNull(debugIdentifier);
            this.mNwaState = Objects.requireNonNull(string);
        }

        public String toString() {
            return this.mIcfgDebugIdentifier.toString() + "_" + this.mNwaState;
        }

        public int hashCode() {
            return Objects.hash(this.mIcfgDebugIdentifier, this.mNwaState);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            BuchiProgramDebugIdentifier buchiProgramDebugIdentifier = (BuchiProgramDebugIdentifier)((Object)object);
            if (this.mIcfgDebugIdentifier == null ? buchiProgramDebugIdentifier.mIcfgDebugIdentifier != null : !this.mIcfgDebugIdentifier.equals(buchiProgramDebugIdentifier.mIcfgDebugIdentifier)) {
                return false;
            }
            return !(this.mNwaState == null ? buchiProgramDebugIdentifier.mNwaState != null : !this.mNwaState.equals(buchiProgramDebugIdentifier.mNwaState));
        }
    }

    private static final class BuchiProgramHelperStateDebugIdentifier
    extends DuplicatedDebugIdentifier {
        public BuchiProgramHelperStateDebugIdentifier(DebugIdentifier debugIdentifier, int n) {
            super(debugIdentifier, n);
        }
    }
}

