/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Literal;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Regex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.sifa.LoopPointVisitor;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.LocationMarkerTransition;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.IDagOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public final class RegexDagUtils {
    private RegexDagUtils() {
    }

    public static IcfgLocation singleSourceLocation(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay) {
        return RegexDagUtils.getOnly(RegexDagUtils.sinkLocations(regexDag, iDagOverlay));
    }

    public static Set<IcfgLocation> sourceLocations(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay) {
        return RegexDagUtils.nextLocations(iDagOverlay.sinks(regexDag), IIcfgTransition::getSource, iDagOverlay::successorsOf);
    }

    public static IcfgLocation singleSinkLocation(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay) {
        return RegexDagUtils.getOnly(RegexDagUtils.sinkLocations(regexDag, iDagOverlay));
    }

    public static Set<IcfgLocation> sinkLocations(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay) {
        return RegexDagUtils.nextLocations(iDagOverlay.sinks(regexDag), IIcfgTransition::getTarget, iDagOverlay::predecessorsOf);
    }

    private static IcfgLocation getOnly(Set<IcfgLocation> set) {
        if (set.size() != 1) {
            throw new IllegalArgumentException("Expected one location but found " + set.size());
        }
        return set.iterator().next();
    }

    private static <T extends IIcfgTransition<IcfgLocation>> Set<IcfgLocation> nextLocations(Collection<RegexDagNode<T>> collection, Function<T, IcfgLocation> function, Function<RegexDagNode<T>, Collection<RegexDagNode<T>>> function2) {
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        ArrayDeque<RegexDagNode<T>> arrayDeque = new ArrayDeque<RegexDagNode<T>>(collection);
        while (!arrayDeque.isEmpty()) {
            RegexDagNode regexDagNode = (RegexDagNode)((Object)arrayDeque.remove());
            IRegex iRegex = regexDagNode.getContent();
            if (iRegex instanceof Literal) {
                IIcfgTransition iIcfgTransition = (IIcfgTransition)((Literal)iRegex).getLetter();
                hashSet.add(function.apply(iIcfgTransition));
                continue;
            }
            if (iRegex instanceof Star) {
                hashSet.add((IcfgLocation)iRegex.accept(new LoopPointVisitor()));
                continue;
            }
            if (iRegex instanceof Epsilon || iRegex instanceof EmptySet) {
                arrayDeque.addAll(function2.apply(regexDagNode));
                continue;
            }
            throw new AssertionError((Object)("Illegal regex type in RegexDag: " + String.valueOf(iRegex)));
        }
        return hashSet;
    }

    public static IRegex<IIcfgTransition<IcfgLocation>> markRegex(IRegex<IIcfgTransition<IcfgLocation>> iRegex, IcfgLocation icfgLocation) {
        return Regex.concat(iRegex, (IRegex)Regex.literal((Object)new LocationMarkerTransition(icfgLocation)));
    }
}

